/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.CaseFormat;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;

class HistoryJsonUtils {
    private static final JsonPath EVENT_TYPE_PATH = JsonPath.compile((String)"$.events.*.eventType", (Predicate[])new Predicate[0]);
    private static final JsonPath TASK_QUEUE_KIND_PATH = JsonPath.compile((String)"$.events.*.*.taskQueue.kind", (Predicate[])new Predicate[0]);
    private static final String EVENT_TYPE_PREFIX = "EVENT_TYPE_";
    private static final String TASK_QUEUE_KIND_PREFIX = "TASK_QUEUE_KIND_";

    HistoryJsonUtils() {
    }

    public static String protoJsonToHistoryFormatJson(String protoJson) {
        DocumentContext parsed = JsonPath.parse((String)protoJson);
        parsed.map(EVENT_TYPE_PATH, (currentValue, configuration) -> HistoryJsonUtils.enumProtoToHistory((String)currentValue, EVENT_TYPE_PREFIX));
        parsed.map(TASK_QUEUE_KIND_PATH, (currentValue, configuration) -> HistoryJsonUtils.enumProtoToHistory((String)currentValue, TASK_QUEUE_KIND_PREFIX));
        return parsed.jsonString();
    }

    public static String historyFormatJsonToProtoJson(String historyFormatJson) {
        DocumentContext parsed = JsonPath.parse((String)historyFormatJson);
        parsed.map(EVENT_TYPE_PATH, (currentValue, configuration) -> HistoryJsonUtils.enumHistoryToProto((String)currentValue, EVENT_TYPE_PREFIX));
        parsed.map(TASK_QUEUE_KIND_PATH, (currentValue, configuration) -> HistoryJsonUtils.enumHistoryToProto((String)currentValue, TASK_QUEUE_KIND_PREFIX));
        return parsed.jsonString();
    }

    private static String enumProtoToHistory(String protoEnumValue, String prefix) {
        if (!protoEnumValue.startsWith(prefix)) {
            throw new IllegalArgumentException("protoEnumValue should start with " + prefix + " prefix");
        }
        protoEnumValue = protoEnumValue.substring(prefix.length());
        return HistoryJsonUtils.screamingCaseEventTypeToCamelCase(protoEnumValue);
    }

    private static String enumHistoryToProto(String historyEnumValue, String prefix) {
        return prefix + HistoryJsonUtils.camelCaseToScreamingCase(historyEnumValue);
    }

    private static String camelCaseToScreamingCase(String camel) {
        return (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).convert((Object)camel);
    }

    private static String screamingCaseEventTypeToCamelCase(String screaming) {
        return (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)screaming);
    }
}

