/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.external;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.client.ActivityCanceledException;
import io.temporal.client.ActivityCompletionFailureException;
import io.temporal.client.ActivityNotExistsException;
import io.temporal.common.converter.DataConverter;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.client.ActivityClientHelper;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManualActivityCompletionClientImpl
implements ManualActivityCompletionClient {
    private static final Logger log = LoggerFactory.getLogger(ManualActivityCompletionClientImpl.class);
    private final WorkflowServiceStubs service;
    private final WorkflowExecution execution;
    private final DataConverter dataConverter;
    private final String namespace;
    private final String identity;
    private final String activityId;
    private final Scope metricsScope;
    private final byte[] taskToken;

    ManualActivityCompletionClientImpl(WorkflowServiceStubs service, String namespace, String identity, byte[] taskToken, DataConverter dataConverter, Scope metricsScope) {
        this.service = service;
        this.execution = null;
        this.dataConverter = dataConverter;
        this.namespace = namespace;
        this.identity = identity;
        this.activityId = null;
        this.metricsScope = metricsScope;
        this.taskToken = taskToken;
    }

    ManualActivityCompletionClientImpl(WorkflowServiceStubs service, String namespace, String identity, WorkflowExecution execution, String activityId, DataConverter dataConverter, Scope metricsScope) {
        this.service = service;
        this.taskToken = null;
        this.namespace = namespace;
        this.identity = identity;
        this.execution = execution;
        this.activityId = activityId;
        this.dataConverter = dataConverter;
        this.metricsScope = metricsScope;
    }

    @Override
    public void complete(Object result) {
        Optional<Payloads> payloads = this.dataConverter.toPayloads(result);
        if (this.taskToken != null) {
            RespondActivityTaskCompletedRequest.Builder request = RespondActivityTaskCompletedRequest.newBuilder().setNamespace(this.namespace).setIdentity(this.identity).setTaskToken(ByteString.copyFrom((byte[])this.taskToken));
            payloads.ifPresent(arg_0 -> ((RespondActivityTaskCompletedRequest.Builder)request).setResult(arg_0));
            try {
                GrpcRetryer.retry((RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCompleted(request.build()));
            }
            catch (Exception e) {
                this.processException(e);
            }
        } else {
            if (this.activityId == null) {
                throw new IllegalArgumentException("Either activity id or task token are required");
            }
            RespondActivityTaskCompletedByIdRequest.Builder request = RespondActivityTaskCompletedByIdRequest.newBuilder().setActivityId(this.activityId).setNamespace(this.namespace).setWorkflowId(this.execution.getWorkflowId()).setRunId(this.execution.getRunId());
            payloads.ifPresent(arg_0 -> ((RespondActivityTaskCompletedByIdRequest.Builder)request).setResult(arg_0));
            try {
                ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCompletedById(request.build());
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
    }

    @Override
    public void fail(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("null exception");
        }
        if (exception instanceof TemporalFailure) {
            ((TemporalFailure)exception).setDataConverter(this.dataConverter);
        }
        if (this.taskToken != null) {
            RespondActivityTaskFailedRequest request = RespondActivityTaskFailedRequest.newBuilder().setFailure(FailureConverter.exceptionToFailure(exception)).setNamespace(this.namespace).setTaskToken(ByteString.copyFrom((byte[])this.taskToken)).build();
            try {
                GrpcRetryer.retry((RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskFailed(request));
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    throw new ActivityNotExistsException(e);
                }
                throw new ActivityCompletionFailureException(e);
            }
            catch (Exception e) {
                throw new ActivityCompletionFailureException(e);
            }
        }
        if (this.activityId == null) {
            throw new IllegalArgumentException("Either activity id or task token are required");
        }
        RespondActivityTaskFailedByIdRequest request = RespondActivityTaskFailedByIdRequest.newBuilder().setFailure(FailureConverter.exceptionToFailure(exception)).setNamespace(this.namespace).setWorkflowId(this.execution.getWorkflowId()).setRunId(this.execution.getRunId()).setActivityId(this.activityId).build();
        try {
            GrpcRetryer.retry((RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskFailedById(request));
        }
        catch (Exception e) {
            this.processException(e);
        }
    }

    @Override
    public void recordHeartbeat(Object details) throws CanceledFailure {
        try {
            RecordActivityTaskHeartbeatResponse status;
            if (this.taskToken != null ? (status = ActivityClientHelper.sendHeartbeatRequest(this.service, this.namespace, this.identity, this.taskToken, this.dataConverter, this.metricsScope, details)).getCancelRequested() : (status = ActivityClientHelper.recordActivityTaskHeartbeatById(this.service, this.namespace, this.identity, this.execution, this.activityId, this.dataConverter, this.metricsScope, details)).getCancelRequested()) {
                throw new ActivityCanceledException();
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
    }

    @Override
    public void reportCancellation(Object details) {
        Optional<Payloads> convertedDetails = this.dataConverter.toPayloads(details);
        if (this.taskToken != null) {
            RespondActivityTaskCanceledRequest.Builder request = RespondActivityTaskCanceledRequest.newBuilder().setNamespace(this.namespace).setTaskToken(ByteString.copyFrom((byte[])this.taskToken));
            if (convertedDetails.isPresent()) {
                request.setDetails(convertedDetails.get());
            }
            try {
                GrpcRetryer.retry((RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCanceled(request.build()));
            }
            catch (Exception e) {
                log.info("reportCancellation", (Throwable)e);
            }
        } else {
            if (this.activityId == null) {
                throw new IllegalArgumentException("Either activity id or task token are required");
            }
            RespondActivityTaskCanceledByIdRequest.Builder request = RespondActivityTaskCanceledByIdRequest.newBuilder().setNamespace(this.namespace).setWorkflowId(this.execution.getWorkflowId()).setRunId(OptionsUtils.safeGet(this.execution.getRunId())).setActivityId(this.activityId);
            if (convertedDetails.isPresent()) {
                request.setDetails(convertedDetails.get());
            }
            try {
                GrpcRetryer.retry((RpcRetryOptions)RpcRetryOptions.newBuilder().buildWithDefaultsFrom(this.service.getOptions().getRpcRetryOptions()), () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).respondActivityTaskCanceledById(request.build()));
            }
            catch (Exception e) {
                log.warn("reportCancellation", (Throwable)e);
            }
        }
    }

    private void processException(Exception e) {
        StatusRuntimeException sre;
        if (e instanceof StatusRuntimeException && (sre = (StatusRuntimeException)((Object)e)).getStatus().getCode() == Status.Code.NOT_FOUND) {
            throw new ActivityNotExistsException(this.activityId, (Throwable)sre);
        }
        throw new ActivityCompletionFailureException(this.activityId, (Throwable)e);
    }
}

