/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.history;

import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.history.MarkerUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class VersionMarkerUtils {
    public static final String MARKER_CHANGE_ID_KEY = "changeId";
    public static final String MARKER_VERSION_KEY = "version";
    private static final DataConverter DATA_CONVERTER = DataConverter.getDefaultInstance();

    @Nullable
    public static String tryGetChangeIdFromVersionMarkerEvent(HistoryEvent event) {
        if (!VersionMarkerUtils.hasVersionMarkerStructure(event)) {
            return null;
        }
        Map detailsMap = event.getMarkerRecordedEventAttributes().getDetailsMap();
        Optional<Payloads> oid = Optional.ofNullable((Payloads)detailsMap.get(MARKER_CHANGE_ID_KEY));
        String changeId = DATA_CONVERTER.fromPayloads(0, oid, String.class, (Type)((Object)String.class));
        return changeId;
    }

    public static boolean hasVersionMarkerStructure(HistoryEvent event) {
        return MarkerUtils.verifyMarkerName(event, "Version");
    }

    @Nullable
    public static String getChangeId(MarkerRecordedEventAttributes markerAttributes) {
        Optional<Payloads> payloads = Optional.ofNullable((Payloads)markerAttributes.getDetailsMap().get(MARKER_CHANGE_ID_KEY));
        String changeId = DATA_CONVERTER.fromPayloads(0, payloads, String.class, (Type)((Object)String.class));
        return changeId;
    }

    @Nullable
    public static Integer getVersion(MarkerRecordedEventAttributes markerAttributes) {
        Optional<Payloads> payloads = Optional.ofNullable((Payloads)markerAttributes.getDetailsMap().get(MARKER_VERSION_KEY));
        Integer versionId = DATA_CONVERTER.fromPayloads(0, payloads, Integer.class, (Type)((Object)Integer.class));
        return versionId;
    }

    public static RecordMarkerCommandAttributes createMarkerAttributes(String changeId, Integer version) {
        Preconditions.checkNotNull((Object)version, (Object)MARKER_VERSION_KEY);
        HashMap<String, Payloads> details = new HashMap<String, Payloads>();
        details.put(MARKER_CHANGE_ID_KEY, DATA_CONVERTER.toPayloads(changeId).get());
        details.put(MARKER_VERSION_KEY, DATA_CONVERTER.toPayloads(version).get());
        return RecordMarkerCommandAttributes.newBuilder().setMarkerName("Version").putAllDetails(details).build();
    }
}

