/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.protobuf.util.Timestamps;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.Duration;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionCancelRequestedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionSignaledEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContextImpl;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.worker.WorkflowImplementationOptions;
import java.util.Optional;

final class ReplayWorkflowExecutor {
    private final ReplayWorkflow workflow;
    private final WorkflowStateMachines workflowStateMachines;
    private final ReplayWorkflowContextImpl context;
    private final Scope metricsScope;
    private boolean completed;
    private WorkflowExecutionException failure;
    private boolean cancelRequested;

    public ReplayWorkflowExecutor(ReplayWorkflow workflow, WorkflowStateMachines workflowStateMachines, ReplayWorkflowContextImpl context) {
        this.workflow = workflow;
        this.workflowStateMachines = workflowStateMachines;
        this.context = context;
        this.metricsScope = context.getMetricsScope();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void eventLoop() {
        if (this.completed) {
            return;
        }
        try {
            this.completed = this.workflow.eventLoop();
        }
        catch (WorkflowExecutionException e) {
            this.failure = e;
            this.completed = true;
        }
        catch (CanceledFailure e) {
            if (!this.cancelRequested) {
                this.failure = this.workflow.mapUnexpectedException(e);
            }
            this.completed = true;
        }
        if (this.completed) {
            this.completeWorkflow();
        }
    }

    private void completeWorkflow() {
        if (this.cancelRequested) {
            this.workflowStateMachines.cancelWorkflow();
            this.metricsScope.counter("temporal_workflow_canceled").inc(1L);
        } else if (this.failure != null) {
            this.workflowStateMachines.failWorkflow(this.failure.getFailure());
            this.metricsScope.counter("temporal_workflow_failed").inc(1L);
        } else {
            ContinueAsNewWorkflowExecutionCommandAttributes attributes = this.context.getContinueAsNewOnCompletion();
            if (attributes != null) {
                this.workflowStateMachines.continueAsNewWorkflow(attributes);
                this.metricsScope.counter("temporal_workflow_continue_as_new").inc(1L);
            } else {
                Optional<Payloads> workflowOutput = this.workflow.getOutput();
                this.workflowStateMachines.completeWorkflow(workflowOutput);
                this.metricsScope.counter("temporal_workflow_completed").inc(1L);
            }
        }
        Duration d = ProtobufTimeUtils.toM3Duration(Timestamps.fromMillis((long)System.currentTimeMillis()), Timestamps.fromMillis((long)this.context.getRunStartedTimestampMillis()));
        this.metricsScope.timer("temporal_workflow_endtoend_latency").record(d);
    }

    public void handleWorkflowExecutionCancelRequested(HistoryEvent event) {
        WorkflowExecutionCancelRequestedEventAttributes attributes = event.getWorkflowExecutionCancelRequestedEventAttributes();
        this.context.setCancelRequested(true);
        String cause = attributes.getCause();
        this.workflow.cancel(cause);
        this.cancelRequested = true;
    }

    public void handleWorkflowExecutionSignaled(HistoryEvent event) {
        WorkflowExecutionSignaledEventAttributes signalAttributes = event.getWorkflowExecutionSignaledEventAttributes();
        if (this.completed) {
            throw new IllegalStateException("Signal received after workflow is closed.");
        }
        Optional<Payloads> input = signalAttributes.hasInput() ? Optional.of(signalAttributes.getInput()) : Optional.empty();
        this.workflow.handleSignal(signalAttributes.getSignalName(), input, event.getEventId());
    }

    public Optional<Payloads> query(WorkflowQuery query) {
        return this.workflow.query(query);
    }

    public WorkflowImplementationOptions getWorkflowImplementationOptions() {
        return this.workflow.getWorkflowImplementationOptions();
    }

    public void close() {
        this.workflow.close();
    }

    public void start(HistoryEvent startWorkflowEvent) {
        this.workflow.start(startWorkflowEvent, this.context);
    }

    public WorkflowExecutionException mapUnexpectedException(Throwable exception) {
        return this.workflow.mapUnexpectedException(exception);
    }
}

