/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.FailWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.QueryResultType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.ResetStickyTaskQueueRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowFactory;
import io.temporal.internal.replay.ReplayWorkflowRunTaskHandler;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.replay.WorkflowRunTaskHandler;
import io.temporal.internal.replay.WorkflowTaskResult;
import io.temporal.internal.worker.LocalActivityWorker;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.internal.worker.WorkflowTaskHandler;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplayWorkflowTaskHandler
implements WorkflowTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(ReplayWorkflowTaskHandler.class);
    private final ReplayWorkflowFactory workflowFactory;
    private final String namespace;
    private final WorkflowExecutorCache cache;
    private final SingleWorkerOptions options;
    private final Duration stickyTaskQueueScheduleToStartTimeout;
    private final Functions.Func<Boolean> shutdownFn;
    private final WorkflowServiceStubs service;
    private final String stickyTaskQueueName;
    private final BiFunction<LocalActivityWorker.Task, Duration, Boolean> localActivityTaskPoller;

    public ReplayWorkflowTaskHandler(String namespace, ReplayWorkflowFactory asyncWorkflowFactory, WorkflowExecutorCache cache, SingleWorkerOptions options, String stickyTaskQueueName, Duration stickyTaskQueueScheduleToStartTimeout, WorkflowServiceStubs service, Functions.Func<Boolean> shutdownFn, BiFunction<LocalActivityWorker.Task, Duration, Boolean> localActivityTaskPoller) {
        this.namespace = namespace;
        this.workflowFactory = asyncWorkflowFactory;
        this.cache = cache;
        this.options = options;
        this.stickyTaskQueueName = stickyTaskQueueName;
        this.stickyTaskQueueScheduleToStartTimeout = stickyTaskQueueScheduleToStartTimeout;
        this.shutdownFn = shutdownFn;
        this.service = Objects.requireNonNull(service);
        this.localActivityTaskPoller = localActivityTaskPoller;
    }

    @Override
    public WorkflowTaskHandler.Result handleWorkflowTask(PollWorkflowTaskQueueResponse workflowTask) throws Exception {
        String workflowType = workflowTask.getWorkflowType().getName();
        Scope metricsScope = this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"workflow_type", (Object)workflowType));
        try {
            if (workflowTask.hasQuery()) {
                return this.handleQueryOnlyWorkflowTask(workflowTask.toBuilder(), metricsScope);
            }
            return this.handleWorkflowTaskWithEmbeddedQuery(workflowTask.toBuilder(), metricsScope);
        }
        catch (Throwable e) {
            metricsScope.counter("temporal_workflow_task_execution_failed").inc(1L);
            return this.failureToResult(workflowTask, e);
        }
    }

    private WorkflowTaskHandler.Result failureToResult(PollWorkflowTaskQueueResponse workflowTask, Throwable e) throws Exception {
        String workflowType = workflowTask.getWorkflowType().getName();
        if (e instanceof WorkflowExecutionException) {
            RespondWorkflowTaskCompletedRequest response = RespondWorkflowTaskCompletedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).setIdentity(this.options.getIdentity()).setNamespace(this.namespace).setBinaryChecksum(this.options.getBinaryChecksum()).addCommands(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION).setFailWorkflowExecutionCommandAttributes(FailWorkflowExecutionCommandAttributes.newBuilder().setFailure(((WorkflowExecutionException)e).getFailure())).build()).build();
            return new WorkflowTaskHandler.Result(workflowType, response, null, null, null, false);
        }
        if (workflowTask.getAttempt() > 1) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (Exception)e;
        }
        if (log.isErrorEnabled() && !this.shutdownFn.apply().booleanValue()) {
            WorkflowExecution execution = workflowTask.getWorkflowExecution();
            log.error("Workflow task failure. startedEventId=" + workflowTask.getStartedEventId() + ", WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + ". If seen continuously the workflow might be stuck.", e);
        }
        Failure failure = FailureConverter.exceptionToFailure(e);
        RespondWorkflowTaskFailedRequest failedRequest = RespondWorkflowTaskFailedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).setFailure(failure).build();
        return new WorkflowTaskHandler.Result(workflowType, null, failedRequest, null, null, false);
    }

    private WorkflowRunTaskHandler getOrCreateWorkflowExecutor(PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope, AtomicBoolean createdNew) throws Exception {
        WorkflowRunTaskHandler workflowRunTaskHandler = this.stickyTaskQueueName == null ? this.createStatefulHandler(workflowTask, metricsScope) : this.cache.getOrCreate((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, metricsScope, () -> {
            createdNew.set(true);
            return this.createStatefulHandler(workflowTask, metricsScope);
        });
        return workflowRunTaskHandler;
    }

    private WorkflowTaskHandler.Result handleWorkflowTaskWithEmbeddedQuery(PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope) throws Throwable {
        AtomicBoolean createdNew = new AtomicBoolean();
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        String runId = execution.getRunId();
        WorkflowRunTaskHandler workflowRunTaskHandler = null;
        try {
            workflowRunTaskHandler = this.getOrCreateWorkflowExecutor(workflowTask, metricsScope, createdNew);
            WorkflowTaskResult result = workflowRunTaskHandler.handleWorkflowTask((PollWorkflowTaskQueueResponseOrBuilder)workflowTask);
            if (result.isFinalCommand()) {
                this.cache.invalidate(execution, metricsScope);
            } else if (this.stickyTaskQueueName != null && createdNew.get()) {
                this.cache.addToCache(runId, workflowRunTaskHandler);
            }
            WorkflowTaskHandler.Result result2 = this.createCompletedRequest(workflowTask.getWorkflowType().getName(), (PollWorkflowTaskQueueResponseOrBuilder)workflowTask, result);
            return result2;
        }
        catch (Throwable e) {
            if (workflowRunTaskHandler != null) {
                workflowRunTaskHandler.close();
            }
            if (this.stickyTaskQueueName != null) {
                this.cache.invalidate(execution, metricsScope);
                if (!WorkflowExecutionUtils.isFullHistory((PollWorkflowTaskQueueResponseOrBuilder)workflowTask)) {
                    this.resetStickyTaskQueue(execution);
                }
            }
            throw e;
        }
        finally {
            if (this.stickyTaskQueueName == null && workflowRunTaskHandler != null) {
                workflowRunTaskHandler.close();
            } else {
                this.cache.markProcessingDone(runId);
            }
        }
    }

    private void resetStickyTaskQueue(WorkflowExecution execution) {
        this.service.futureStub().resetStickyTaskQueue(ResetStickyTaskQueueRequest.newBuilder().setNamespace(this.namespace).setExecution(execution).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowTaskHandler.Result handleQueryOnlyWorkflowTask(PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope) {
        RespondQueryTaskCompletedRequest.Builder queryCompletedRequest = RespondQueryTaskCompletedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).setNamespace(this.namespace);
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        String runId = execution.getRunId();
        WorkflowRunTaskHandler workflowRunTaskHandler = null;
        AtomicBoolean createdNew = new AtomicBoolean();
        try {
            workflowRunTaskHandler = this.getOrCreateWorkflowExecutor(workflowTask, metricsScope, createdNew);
            Optional<Payloads> queryResult = workflowRunTaskHandler.handleQueryWorkflowTask((PollWorkflowTaskQueueResponseOrBuilder)workflowTask, workflowTask.getQuery());
            if (this.stickyTaskQueueName != null && createdNew.get()) {
                this.cache.addToCache(runId, workflowRunTaskHandler);
            }
            if (queryResult.isPresent()) {
                queryCompletedRequest.setQueryResult(queryResult.get());
            }
            queryCompletedRequest.setCompletedType(QueryResultType.QUERY_RESULT_TYPE_ANSWERED);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            queryCompletedRequest.setErrorMessage(sw.toString());
            queryCompletedRequest.setCompletedType(QueryResultType.QUERY_RESULT_TYPE_FAILED);
        }
        finally {
            if (this.stickyTaskQueueName == null && workflowRunTaskHandler != null) {
                workflowRunTaskHandler.close();
            } else {
                this.cache.markProcessingDone(runId);
            }
        }
        return new WorkflowTaskHandler.Result(workflowTask.getWorkflowType().getName(), null, null, queryCompletedRequest.build(), null, false);
    }

    private WorkflowTaskHandler.Result createCompletedRequest(String workflowType, PollWorkflowTaskQueueResponseOrBuilder workflowTask, WorkflowTaskResult result) {
        WorkflowExecution execution = workflowTask.getWorkflowExecution();
        if (log.isTraceEnabled()) {
            log.trace("WorkflowTask startedEventId=" + workflowTask.getStartedEventId() + ", WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + " completed with \n" + WorkflowExecutionUtils.prettyPrintCommands(result.getCommands()));
        } else if (log.isDebugEnabled()) {
            log.debug("WorkflowTask startedEventId=" + workflowTask.getStartedEventId() + ", WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + " completed with " + result.getCommands().size() + " new commands");
        }
        RespondWorkflowTaskCompletedRequest.Builder completedRequest = RespondWorkflowTaskCompletedRequest.newBuilder().setTaskToken(workflowTask.getTaskToken()).addAllCommands(result.getCommands()).putAllQueryResults(result.getQueryResults()).setForceCreateNewWorkflowTask(result.isForceWorkflowTask()).setReturnNewWorkflowTask(result.isForceWorkflowTask());
        if (!(this.stickyTaskQueueName == null || this.stickyTaskQueueScheduleToStartTimeout != null && this.stickyTaskQueueScheduleToStartTimeout.isZero())) {
            StickyExecutionAttributes.Builder attributes = StickyExecutionAttributes.newBuilder().setWorkerTaskQueue(InternalUtils.createStickyTaskQueue(this.stickyTaskQueueName));
            if (this.stickyTaskQueueScheduleToStartTimeout != null) {
                attributes.setScheduleToStartTimeout(ProtobufTimeUtils.toProtoDuration(this.stickyTaskQueueScheduleToStartTimeout));
            }
            completedRequest.setStickyAttributes(attributes);
        }
        return new WorkflowTaskHandler.Result(workflowType, completedRequest.build(), null, null, null, result.isFinalCommand());
    }

    @Override
    public boolean isAnyTypeSupported() {
        return this.workflowFactory.isAnyTypeSupported();
    }

    private WorkflowRunTaskHandler createStatefulHandler(PollWorkflowTaskQueueResponse.Builder workflowTask, Scope metricsScope) throws Exception {
        WorkflowType workflowType = workflowTask.getWorkflowType();
        List events = workflowTask.getHistory().getEventsList();
        if (events.isEmpty() || ((HistoryEvent)events.get(0)).getEventId() > 1L) {
            GetWorkflowExecutionHistoryRequest getHistoryRequest = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.namespace).setExecution(workflowTask.getWorkflowExecution()).build();
            GetWorkflowExecutionHistoryResponse getHistoryResponse = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).getWorkflowExecutionHistory(getHistoryRequest);
            workflowTask.setHistory(getHistoryResponse.getHistory()).setNextPageToken(getHistoryResponse.getNextPageToken());
        }
        ReplayWorkflow workflow = this.workflowFactory.getWorkflow(workflowType);
        return new ReplayWorkflowRunTaskHandler(this.service, this.namespace, workflow, (PollWorkflowTaskQueueResponseOrBuilder)workflowTask, this.options, metricsScope, this.localActivityTaskPoller);
    }
}

