/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.replay;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.common.ProtobufTimeUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class WorkflowContext {
    private final long runStartedTimestampMillis;
    private boolean cancelRequested;
    private ContinueAsNewWorkflowExecutionCommandAttributes continueAsNewOnCompletion;
    private final WorkflowExecutionStartedEventAttributes startedAttributes;
    private final String namespace;
    private String currentRunId;
    private SearchAttributes.Builder searchAttributes;
    private final List<ContextPropagator> contextPropagators;
    private final WorkflowExecution workflowExecution;

    WorkflowContext(String namespace, WorkflowExecution workflowExecution, WorkflowExecutionStartedEventAttributes startedAttributes, long runStartedTimestampMillis, List<ContextPropagator> contextPropagators) {
        this.namespace = namespace;
        this.workflowExecution = workflowExecution;
        this.startedAttributes = startedAttributes;
        this.currentRunId = startedAttributes.getOriginalExecutionRunId();
        if (startedAttributes.hasSearchAttributes()) {
            this.searchAttributes = startedAttributes.getSearchAttributes().toBuilder();
        }
        this.runStartedTimestampMillis = runStartedTimestampMillis;
        this.contextPropagators = contextPropagators;
    }

    WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    WorkflowType getWorkflowType() {
        return this.startedAttributes.getWorkflowType();
    }

    boolean isCancelRequested() {
        return this.cancelRequested;
    }

    void setCancelRequested(boolean flag) {
        this.cancelRequested = flag;
    }

    ContinueAsNewWorkflowExecutionCommandAttributes getContinueAsNewOnCompletion() {
        return this.continueAsNewOnCompletion;
    }

    void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionCommandAttributes parameters) {
        this.continueAsNewOnCompletion = parameters;
    }

    Optional<String> getContinuedExecutionRunId() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        String runId = attributes.getContinuedExecutionRunId();
        return runId.isEmpty() ? Optional.empty() : Optional.of(runId);
    }

    WorkflowExecution getParentWorkflowExecution() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.hasParentWorkflowExecution() ? attributes.getParentWorkflowExecution() : null;
    }

    Duration getWorkflowRunTimeout() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return ProtobufTimeUtils.toJavaDuration(attributes.getWorkflowRunTimeout());
    }

    Duration getWorkflowExecutionTimeout() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return ProtobufTimeUtils.toJavaDuration(attributes.getWorkflowExecutionTimeout());
    }

    long getWorkflowExecutionExpirationTimestampMillis() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return Timestamps.toMillis((Timestamp)attributes.getWorkflowExecutionExpirationTime());
    }

    long getRunStartedTimestampMillis() {
        return this.runStartedTimestampMillis;
    }

    Duration getWorkflowTaskTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.startedAttributes.getWorkflowTaskTimeout());
    }

    String getTaskQueue() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getTaskQueue().getName();
    }

    String getNamespace() {
        return this.namespace;
    }

    private WorkflowExecutionStartedEventAttributes getWorkflowStartedEventAttributes() {
        return this.startedAttributes;
    }

    void setCurrentRunId(String currentRunId) {
        this.currentRunId = currentRunId;
    }

    String getCurrentRunId() {
        return this.currentRunId;
    }

    public Map<String, Payload> getHeader() {
        return this.startedAttributes.getHeader().getFieldsMap();
    }

    public Payload getMemo(String key) {
        return (Payload)this.startedAttributes.getMemo().getFieldsMap().get(key);
    }

    SearchAttributes getSearchAttributes() {
        return this.searchAttributes == null || this.searchAttributes.getIndexedFieldsCount() == 0 ? null : this.searchAttributes.build();
    }

    int getAttempt() {
        return this.startedAttributes.getAttempt();
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    Map<String, Object> getPropagatedContexts() {
        if (this.contextPropagators == null || this.contextPropagators.isEmpty()) {
            return new HashMap<String, Object>();
        }
        Header headers = this.startedAttributes.getHeader();
        HashMap<String, Payload> headerData = new HashMap<String, Payload>(headers.getFieldsMap());
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (ContextPropagator propagator : this.contextPropagators) {
            contextData.put(propagator.getName(), propagator.deserializeContext(headerData));
        }
        return contextData;
    }

    void mergeSearchAttributes(SearchAttributes searchAttributes) {
        if (searchAttributes == null || searchAttributes.getIndexedFieldsCount() == 0) {
            return;
        }
        if (this.searchAttributes == null) {
            this.searchAttributes = SearchAttributes.newBuilder();
        }
        this.searchAttributes.putAllIndexedFields(searchAttributes.getIndexedFieldsMap());
    }
}

