/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.temporal.api.command.v1.CancelWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.ActivityTaskScheduledEventAttributes;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.StartChildWorkflowExecutionInitiatedEventAttributes;
import io.temporal.api.history.v1.TimerStartedEventAttributes;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.history.MarkerUtils;
import io.temporal.internal.history.VersionMarkerUtils;
import io.temporal.internal.replay.ExecuteActivityParameters;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.replay.InternalWorkflowTaskException;
import io.temporal.internal.replay.StartChildWorkflowExecutionParameters;
import io.temporal.internal.statemachines.ActivityStateMachine;
import io.temporal.internal.statemachines.CancelExternalStateMachine;
import io.temporal.internal.statemachines.CancelWorkflowStateMachine;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.ChildWorkflowStateMachine;
import io.temporal.internal.statemachines.CompleteWorkflowStateMachine;
import io.temporal.internal.statemachines.ContinueAsNewWorkflowStateMachine;
import io.temporal.internal.statemachines.EntityStateMachine;
import io.temporal.internal.statemachines.FailWorkflowStateMachine;
import io.temporal.internal.statemachines.LocalActivityStateMachine;
import io.temporal.internal.statemachines.MutableSideEffectStateMachine;
import io.temporal.internal.statemachines.SideEffectStateMachine;
import io.temporal.internal.statemachines.SignalExternalStateMachine;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StatesMachinesCallback;
import io.temporal.internal.statemachines.TimerStateMachine;
import io.temporal.internal.statemachines.UpsertSearchAttributesStateMachine;
import io.temporal.internal.statemachines.VersionStateMachine;
import io.temporal.internal.statemachines.WFTBuffer;
import io.temporal.internal.statemachines.WorkflowTaskStateMachine;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.workflow.ChildWorkflowCancellationType;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;

public final class WorkflowStateMachines {
    private final DataConverter dataConverter = DataConverter.getDefaultInstance();
    private long workflowTaskStartedEventId;
    private long previousStartedEventId;
    private final StatesMachinesCallback callbacks;
    private final Functions.Proc1<CancellableCommand> commandSink;
    private String currentRunId;
    private long idCounter;
    private long currentTimeMillis = -1L;
    private final Map<Long, EntityStateMachine> stateMachines = new HashMap<Long, EntityStateMachine>();
    private final Queue<CancellableCommand> commands = new ArrayDeque<CancellableCommand>();
    private final Queue<CancellableCommand> cancellableCommands = new ArrayDeque<CancellableCommand>();
    private long currentStartedEventId;
    private boolean replaying;
    private boolean eventLoopExecuting;
    private boolean preparing;
    private final Map<String, MutableSideEffectStateMachine> mutableSideEffects = new HashMap<String, MutableSideEffectStateMachine>();
    private final Map<String, VersionStateMachine> versions = new HashMap<String, VersionStateMachine>();
    private final Map<String, LocalActivityStateMachine> localActivityMap = new HashMap<String, LocalActivityStateMachine>();
    private List<ExecuteLocalActivityParameters> localActivityRequests = new ArrayList<ExecuteLocalActivityParameters>();
    private final Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink;
    private final Functions.Proc1<StateMachine> stateMachineSink;
    private final WFTBuffer wftBuffer = new WFTBuffer();

    public WorkflowStateMachines(StatesMachinesCallback callbacks) {
        this(callbacks, stateMachine -> {});
    }

    @VisibleForTesting
    public WorkflowStateMachines(StatesMachinesCallback callbacks, Functions.Proc1<StateMachine> stateMachineSink) {
        this.callbacks = Objects.requireNonNull(callbacks);
        this.commandSink = this.cancellableCommands::add;
        this.stateMachineSink = stateMachineSink;
        this.localActivityRequestSink = request -> this.localActivityRequests.add((ExecuteLocalActivityParameters)request);
    }

    public void setStartedIds(long previousStartedEventId, long workflowTaskStartedEventId) {
        this.previousStartedEventId = previousStartedEventId;
        this.workflowTaskStartedEventId = workflowTaskStartedEventId;
        this.replaying = previousStartedEventId > this.currentStartedEventId;
    }

    public void handleEvent(HistoryEvent event, boolean hasNextEvent) {
        boolean readyToPeek = this.wftBuffer.addEvent(event, hasNextEvent);
        if (readyToPeek) {
            this.handleEventsBatch(this.wftBuffer.fetch(), hasNextEvent);
        }
    }

    private void handleEventsBatch(List<HistoryEvent> events, boolean hasNextEvent) {
        for (HistoryEvent event : events) {
            try {
                this.preloadVersionMarker(event);
            }
            catch (RuntimeException e) {
                throw this.createEventProcessingException(e, event);
            }
        }
        Iterator<HistoryEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            HistoryEvent event;
            event = iterator.next();
            try {
                this.handleSingleEvent(event, iterator.hasNext() || hasNextEvent);
            }
            catch (RuntimeException e) {
                throw this.createEventProcessingException(e, event);
            }
        }
    }

    private InternalWorkflowTaskException createEventProcessingException(RuntimeException e, HistoryEvent event) {
        return new InternalWorkflowTaskException("Failure handling event " + event.getEventId() + " of '" + event.getEventType() + "' type. IsReplaying=" + this.isReplaying() + ", PreviousStartedEventId=" + this.getLastStartedEventId() + ", workflowTaskStartedEventId=" + this.workflowTaskStartedEventId + ", Currently Processing StartedEventId=" + this.currentStartedEventId, CheckedExceptionWrapper.unwrap((Throwable)e));
    }

    private void handleSingleEvent(HistoryEvent event, boolean hasNextEvent) {
        if (WorkflowExecutionUtils.isCommandEvent(event)) {
            this.handleCommandEvent(event);
            return;
        }
        Long initialCommandEventId = this.getInitialCommandEventId(event);
        EntityStateMachine c = this.stateMachines.get(initialCommandEventId);
        if (c != null) {
            c.handleEvent(event, hasNextEvent);
            if (c.isFinalState()) {
                this.stateMachines.remove(initialCommandEventId);
            }
        } else {
            this.handleNonStatefulEvent(event, hasNextEvent);
        }
        if (this.replaying && this.currentStartedEventId >= this.previousStartedEventId && event.getEventType() != EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED) {
            this.replaying = false;
        }
    }

    private void handleCommandEvent(HistoryEvent event) {
        if (this.handleLocalActivityMarker(event)) {
            return;
        }
        CancellableCommand matchingCommand = null;
        block4: while (matchingCommand == null) {
            CancellableCommand command = this.commands.peek();
            if (command == null) {
                if (this.handleNonMatchingVersionMarker(event)) {
                    return;
                }
                throw new IllegalStateException("No command scheduled that corresponds to " + event);
            }
            if (command.isCanceled()) {
                this.commands.poll();
                continue;
            }
            HandleEventStatus status = command.handleEvent(event, true);
            if (command.isCanceled()) {
                this.commands.poll();
                continue;
            }
            switch (status) {
                case OK: {
                    this.commands.poll();
                    matchingCommand = command;
                    continue block4;
                }
                case NON_MATCHING_EVENT: {
                    if (this.handleNonMatchingVersionMarker(event)) {
                        return;
                    }
                    throw new IllegalStateException("Event " + event.getEventId() + " of " + event.getEventType() + " does not match command " + command.getCommandType());
                }
            }
            throw new IllegalStateException("Got " + (Object)((Object)status) + " value from command.handleEvent which is not handled");
        }
        this.validateCommand(matchingCommand.getCommand(), event);
        EntityStateMachine stateMachine = matchingCommand.getStateMachine();
        if (!stateMachine.isFinalState()) {
            this.stateMachines.put(event.getEventId(), stateMachine);
        }
        if (event.getEventType() == EventType.EVENT_TYPE_MARKER_RECORDED) {
            this.prepareCommands();
        }
    }

    private void preloadVersionMarker(HistoryEvent event) {
        if (this.replaying && VersionMarkerUtils.hasVersionMarkerStructure(event)) {
            String changeId = VersionMarkerUtils.tryGetChangeIdFromVersionMarkerEvent(event);
            if (changeId == null) {
                return;
            }
            VersionStateMachine versionStateMachine = this.versions.computeIfAbsent(changeId, idKey -> VersionStateMachine.newInstance(changeId, this::isReplaying, this.commandSink, this.stateMachineSink));
            versionStateMachine.handleMarkersPreload(event);
        }
    }

    private boolean handleNonMatchingVersionMarker(HistoryEvent event) {
        String changeId = VersionMarkerUtils.tryGetChangeIdFromVersionMarkerEvent(event);
        if (changeId == null) {
            return false;
        }
        VersionStateMachine versionStateMachine = this.versions.get(changeId);
        Preconditions.checkNotNull((Object)versionStateMachine, (Object)"versionStateMachine is expected to be initialized already by execution or preloading");
        versionStateMachine.handleNonMatchingEvent(event);
        return true;
    }

    public List<Command> takeCommands() {
        ArrayList<Command> result = new ArrayList<Command>(this.commands.size());
        for (CancellableCommand command : this.commands) {
            if (command.isCanceled()) continue;
            result.add(command.getCommand());
        }
        return result;
    }

    private void prepareCommands() {
        if (this.preparing) {
            return;
        }
        this.preparing = true;
        try {
            this.prepareImpl();
        }
        finally {
            this.preparing = false;
        }
    }

    private void prepareImpl() {
        CancellableCommand command;
        while ((command = this.cancellableCommands.poll()) != null) {
            command.handleCommand(command.getCommandType());
            this.commands.add(command);
        }
    }

    private boolean handleLocalActivityMarker(HistoryEvent event) {
        if (!MarkerUtils.verifyMarkerName(event, "LocalActivity")) {
            return false;
        }
        Map detailsMap = event.getMarkerRecordedEventAttributes().getDetailsMap();
        Optional<Payloads> idPayloads = Optional.ofNullable((Payloads)detailsMap.get("activityId"));
        String id = this.dataConverter.fromPayloads(0, idPayloads, String.class, (Type)((Object)String.class));
        LocalActivityStateMachine stateMachine = this.localActivityMap.remove(id);
        if (stateMachine == null) {
            throw new IllegalStateException("Unexpected local activity id: " + id);
        }
        if (stateMachine.getState() == LocalActivityStateMachine.State.RESULT_NOTIFIED) {
            return false;
        }
        stateMachine.handleEvent(event, true);
        this.eventLoop();
        return true;
    }

    private void eventLoop() {
        if (this.eventLoopExecuting) {
            return;
        }
        this.eventLoopExecuting = true;
        try {
            this.callbacks.eventLoop();
        }
        finally {
            this.eventLoopExecuting = false;
        }
        this.prepareCommands();
    }

    private void handleNonStatefulEvent(HistoryEvent event, boolean hasNextEvent) {
        switch (event.getEventType()) {
            case EVENT_TYPE_WORKFLOW_EXECUTION_STARTED: {
                this.currentRunId = event.getWorkflowExecutionStartedEventAttributes().getOriginalExecutionRunId();
                this.callbacks.start(event);
                break;
            }
            case EVENT_TYPE_WORKFLOW_TASK_SCHEDULED: {
                WorkflowTaskStateMachine c = WorkflowTaskStateMachine.newInstance(this.workflowTaskStartedEventId, new WorkflowTaskCommandsListener());
                c.handleEvent(event, hasNextEvent);
                this.stateMachines.put(event.getEventId(), c);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED: {
                this.callbacks.signal(event);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCEL_REQUESTED: {
                this.callbacks.cancel(event);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT: 
            case UNRECOGNIZED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected event:" + event);
            }
        }
    }

    private long setCurrentTimeMillis(long currentTimeMillis) {
        if (this.currentTimeMillis < currentTimeMillis) {
            this.currentTimeMillis = currentTimeMillis;
        }
        return this.currentTimeMillis;
    }

    public long getLastStartedEventId() {
        return this.currentStartedEventId;
    }

    public Functions.Proc scheduleActivityTask(ExecuteActivityParameters attributes, Functions.Proc2<Optional<Payloads>, Failure> callback) {
        this.checkEventLoopExecuting();
        ActivityStateMachine activityStateMachine = ActivityStateMachine.newInstance(attributes, (p, f) -> {
            callback.apply((Optional<Payloads>)p, (Failure)f);
            if (f != null && f.hasCause() && f.getCause().hasCanceledFailureInfo()) {
                this.eventLoop();
            }
        }, this.commandSink, this.stateMachineSink);
        return activityStateMachine::cancel;
    }

    public Functions.Proc newTimer(StartTimerCommandAttributes attributes, Functions.Proc1<HistoryEvent> completionCallback) {
        this.checkEventLoopExecuting();
        TimerStateMachine timer = TimerStateMachine.newInstance(attributes, event -> {
            completionCallback.apply((HistoryEvent)event);
            if (event.getEventType() == EventType.EVENT_TYPE_TIMER_CANCELED) {
                this.eventLoop();
            }
        }, this.commandSink, this.stateMachineSink);
        return timer::cancel;
    }

    public Functions.Proc startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Functions.Proc1<WorkflowExecution> startedCallback, Functions.Proc2<Optional<Payloads>, Exception> completionCallback) {
        this.checkEventLoopExecuting();
        StartChildWorkflowExecutionCommandAttributes attributes = parameters.getRequest().build();
        ChildWorkflowCancellationType cancellationType = parameters.getCancellationType();
        ChildWorkflowStateMachine child = ChildWorkflowStateMachine.newInstance(attributes, startedCallback, completionCallback, this.commandSink, this.stateMachineSink);
        return () -> {
            if (cancellationType == ChildWorkflowCancellationType.ABANDON) {
                this.notifyChildCanceled(completionCallback);
                return;
            }
            if (child.isCancellable()) {
                child.cancel();
                return;
            }
            if (!child.isFinalState()) {
                this.requestCancelExternalWorkflowExecution(RequestCancelExternalWorkflowExecutionCommandAttributes.newBuilder().setWorkflowId(attributes.getWorkflowId()).setNamespace(attributes.getNamespace()).setChildWorkflowOnly(true).build(), (r, e) -> {
                    if (cancellationType == ChildWorkflowCancellationType.WAIT_CANCELLATION_REQUESTED) {
                        this.notifyChildCanceled(completionCallback);
                    }
                });
                if (cancellationType == ChildWorkflowCancellationType.TRY_CANCEL) {
                    this.notifyChildCanceled(completionCallback);
                }
            }
        };
    }

    private void notifyChildCanceled(Functions.Proc2<Optional<Payloads>, Exception> completionCallback) {
        CanceledFailure failure = new CanceledFailure("Child canceled", new EncodedValues(Optional.empty()), null);
        completionCallback.apply(Optional.empty(), failure);
        this.eventLoop();
    }

    public Functions.Proc signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes attributes, Functions.Proc2<Void, Failure> completionCallback) {
        this.checkEventLoopExecuting();
        return SignalExternalStateMachine.newInstance(attributes, completionCallback, this.commandSink, this.stateMachineSink);
    }

    public void requestCancelExternalWorkflowExecution(RequestCancelExternalWorkflowExecutionCommandAttributes attributes, Functions.Proc2<Void, RuntimeException> completionCallback) {
        this.checkEventLoopExecuting();
        CancelExternalStateMachine.newInstance(attributes, completionCallback, this.commandSink, this.stateMachineSink);
    }

    public void upsertSearchAttributes(SearchAttributes attributes) {
        this.checkEventLoopExecuting();
        UpsertSearchAttributesStateMachine.newInstance(attributes, this.commandSink, this.stateMachineSink);
    }

    public void completeWorkflow(Optional<Payloads> workflowOutput) {
        this.checkEventLoopExecuting();
        CompleteWorkflowStateMachine.newInstance(workflowOutput, this.commandSink, this.stateMachineSink);
    }

    public void failWorkflow(Failure failure) {
        this.checkEventLoopExecuting();
        FailWorkflowStateMachine.newInstance(failure, this.commandSink, this.stateMachineSink);
    }

    public void cancelWorkflow() {
        this.checkEventLoopExecuting();
        CancelWorkflowStateMachine.newInstance(CancelWorkflowExecutionCommandAttributes.getDefaultInstance(), this.commandSink, this.stateMachineSink);
    }

    public void continueAsNewWorkflow(ContinueAsNewWorkflowExecutionCommandAttributes attributes) {
        this.checkEventLoopExecuting();
        ContinueAsNewWorkflowStateMachine.newInstance(attributes, this.commandSink, this.stateMachineSink);
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public long currentTimeMillis() {
        return this.currentTimeMillis;
    }

    public UUID randomUUID() {
        this.checkEventLoopExecuting();
        String runId = this.currentRunId;
        if (runId == null) {
            throw new Error("null currentRunId");
        }
        String id = runId + ":" + this.idCounter++;
        byte[] bytes = id.getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(bytes);
    }

    public Random newRandom() {
        this.checkEventLoopExecuting();
        return new Random(this.randomUUID().getLeastSignificantBits());
    }

    public void sideEffect(Functions.Func<Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
        this.checkEventLoopExecuting();
        SideEffectStateMachine.newInstance(this::isReplaying, func, payloads -> {
            callback.apply((Optional<Payloads>)payloads);
            this.eventLoop();
        }, this.commandSink, this.stateMachineSink);
    }

    public void mutableSideEffect(String id, Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
        this.checkEventLoopExecuting();
        MutableSideEffectStateMachine stateMachine = this.mutableSideEffects.computeIfAbsent(id, idKey -> MutableSideEffectStateMachine.newInstance(idKey, this::isReplaying, this.commandSink, this.stateMachineSink));
        stateMachine.mutableSideEffect(func, (Optional<Payloads> r) -> {
            callback.apply((Optional<Payloads>)r);
            this.eventLoop();
        }, this.stateMachineSink);
    }

    public void getVersion(String changeId, int minSupported, int maxSupported, Functions.Proc2<Integer, RuntimeException> callback) {
        VersionStateMachine stateMachine = this.versions.computeIfAbsent(changeId, idKey -> VersionStateMachine.newInstance(changeId, this::isReplaying, this.commandSink, this.stateMachineSink));
        stateMachine.getVersion(minSupported, maxSupported, (v, e) -> {
            callback.apply((Integer)v, (RuntimeException)e);
            this.eventLoop();
        });
    }

    public List<ExecuteLocalActivityParameters> takeLocalActivityRequests() {
        List<ExecuteLocalActivityParameters> result = this.localActivityRequests;
        this.localActivityRequests = new ArrayList<ExecuteLocalActivityParameters>();
        for (ExecuteLocalActivityParameters parameters : result) {
            LocalActivityStateMachine stateMachine = this.localActivityMap.get(parameters.getActivityTask().getActivityId());
            stateMachine.markAsSent();
        }
        return result;
    }

    public void handleLocalActivityCompletion(ActivityTaskHandler.Result laCompletion) {
        LocalActivityStateMachine commands = this.localActivityMap.get(laCompletion.getActivityId());
        if (commands == null) {
            throw new IllegalStateException("Unknown local activity: " + laCompletion.getActivityId());
        }
        commands.handleCompletion(laCompletion);
        this.prepareCommands();
    }

    public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, Functions.Proc2<Optional<Payloads>, Failure> callback) {
        this.checkEventLoopExecuting();
        String activityId = parameters.getActivityTask().getActivityId();
        if (Strings.isNullOrEmpty((String)activityId)) {
            throw new IllegalArgumentException("Missing activityId: " + activityId);
        }
        if (this.localActivityMap.containsKey(activityId)) {
            throw new IllegalArgumentException("Duplicated local activity id: " + activityId);
        }
        LocalActivityStateMachine commands = LocalActivityStateMachine.newInstance(this::isReplaying, this::setCurrentTimeMillis, parameters, (r, e) -> {
            callback.apply((Optional<Payloads>)r, (Failure)e);
            this.eventLoop();
        }, this.localActivityRequestSink, this.commandSink, this.stateMachineSink);
        this.localActivityMap.put(activityId, commands);
        return commands::cancel;
    }

    private void validateCommand(Command command, HistoryEvent event) {
        this.assertMatch(command, event, "eventType", WorkflowExecutionUtils.getEventTypeForCommand(command.getCommandType()), event.getEventType());
        switch (command.getCommandType()) {
            case COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK: {
                ScheduleActivityTaskCommandAttributes commandAttributes = command.getScheduleActivityTaskCommandAttributes();
                ActivityTaskScheduledEventAttributes eventAttributes = event.getActivityTaskScheduledEventAttributes();
                this.assertMatch(command, event, "activityId", commandAttributes.getActivityId(), eventAttributes.getActivityId());
                this.assertMatch(command, event, "activityType", commandAttributes.getActivityType(), eventAttributes.getActivityType());
                break;
            }
            case COMMAND_TYPE_START_CHILD_WORKFLOW_EXECUTION: {
                StartChildWorkflowExecutionCommandAttributes commandAttributes = command.getStartChildWorkflowExecutionCommandAttributes();
                StartChildWorkflowExecutionInitiatedEventAttributes eventAttributes = event.getStartChildWorkflowExecutionInitiatedEventAttributes();
                this.assertMatch(command, event, "workflowId", commandAttributes.getWorkflowId(), eventAttributes.getWorkflowId());
                this.assertMatch(command, event, "workflowType", commandAttributes.getWorkflowType(), eventAttributes.getWorkflowType());
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK: 
            case COMMAND_TYPE_START_TIMER: {
                StartTimerCommandAttributes commandAttributes = command.getStartTimerCommandAttributes();
                TimerStartedEventAttributes eventAttributes = event.getTimerStartedEventAttributes();
                this.assertMatch(command, event, "timerId", commandAttributes.getTimerId(), eventAttributes.getTimerId());
                break;
            }
            case COMMAND_TYPE_CANCEL_TIMER: 
            case COMMAND_TYPE_CANCEL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_RECORD_MARKER: 
            case COMMAND_TYPE_CONTINUE_AS_NEW_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: 
            case COMMAND_TYPE_COMPLETE_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION: {
                break;
            }
            case UNRECOGNIZED: 
            case COMMAND_TYPE_UNSPECIFIED: {
                throw new IllegalArgumentException("Unexpected command type: " + command.getCommandType());
            }
        }
    }

    private void assertMatch(Command command, HistoryEvent event, String checkType, Object expected, Object actual) {
        Preconditions.checkState((boolean)expected.equals(actual), (String)"Command %s doesn't match event %s with EventId=%s on check %s with an expected value %s and an actual value %s", (Object[])new Object[]{command.getCommandType(), event.getEventType(), event.getEventId(), checkType, expected, actual});
    }

    private long getInitialCommandEventId(HistoryEvent event) {
        switch (event.getEventType()) {
            case EVENT_TYPE_ACTIVITY_TASK_STARTED: {
                return event.getActivityTaskStartedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_ACTIVITY_TASK_COMPLETED: {
                return event.getActivityTaskCompletedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_ACTIVITY_TASK_FAILED: {
                return event.getActivityTaskFailedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT: {
                return event.getActivityTaskTimedOutEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED: {
                return event.getActivityTaskCancelRequestedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_ACTIVITY_TASK_CANCELED: {
                return event.getActivityTaskCanceledEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_TIMER_FIRED: {
                return event.getTimerFiredEventAttributes().getStartedEventId();
            }
            case EVENT_TYPE_TIMER_CANCELED: {
                return event.getTimerCanceledEventAttributes().getStartedEventId();
            }
            case EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: {
                return event.getRequestCancelExternalWorkflowExecutionFailedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED: {
                return event.getExternalWorkflowExecutionCancelRequestedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_FAILED: {
                return event.getStartChildWorkflowExecutionFailedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_STARTED: {
                return event.getChildWorkflowExecutionStartedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_COMPLETED: {
                return event.getChildWorkflowExecutionCompletedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_FAILED: {
                return event.getChildWorkflowExecutionFailedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_CANCELED: {
                return event.getChildWorkflowExecutionCanceledEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TIMED_OUT: {
                return event.getChildWorkflowExecutionTimedOutEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TERMINATED: {
                return event.getChildWorkflowExecutionTerminatedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: {
                return event.getSignalExternalWorkflowExecutionFailedEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_SIGNALED: {
                return event.getExternalWorkflowExecutionSignaledEventAttributes().getInitiatedEventId();
            }
            case EVENT_TYPE_WORKFLOW_TASK_STARTED: {
                return event.getWorkflowTaskStartedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_WORKFLOW_TASK_COMPLETED: {
                return event.getWorkflowTaskCompletedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_WORKFLOW_TASK_TIMED_OUT: {
                return event.getWorkflowTaskTimedOutEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_WORKFLOW_TASK_FAILED: {
                return event.getWorkflowTaskFailedEventAttributes().getScheduledEventId();
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_STARTED: 
            case EVENT_TYPE_WORKFLOW_TASK_SCHEDULED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCEL_REQUESTED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT: 
            case EVENT_TYPE_ACTIVITY_TASK_SCHEDULED: 
            case EVENT_TYPE_TIMER_STARTED: 
            case EVENT_TYPE_MARKER_RECORDED: 
            case EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: 
            case EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_INITIATED: 
            case EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_TERMINATED: 
            case EVENT_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_COMPLETED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_FAILED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCELED: {
                return event.getEventId();
            }
            case UNRECOGNIZED: 
            case EVENT_TYPE_UNSPECIFIED: {
                throw new IllegalArgumentException("Unexpected event type: " + event.getEventType());
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private void checkEventLoopExecuting() {
        if (!this.eventLoopExecuting) {
            throw new IllegalStateException("Operation allowed only while eventLoop is running");
        }
    }

    private class WorkflowTaskCommandsListener
    implements WorkflowTaskStateMachine.Listener {
        private WorkflowTaskCommandsListener() {
        }

        @Override
        public void workflowTaskStarted(long startedEventId, long currentTimeMillis, boolean nonProcessedWorkflowTask) {
            WorkflowStateMachines.this.setCurrentTimeMillis(currentTimeMillis);
            for (CancellableCommand cancellableCommand : WorkflowStateMachines.this.commands) {
                cancellableCommand.handleWorkflowTaskStarted();
            }
            if (nonProcessedWorkflowTask) {
                for (LocalActivityStateMachine value : WorkflowStateMachines.this.localActivityMap.values()) {
                    value.nonReplayWorkflowTaskStarted();
                }
            }
            WorkflowStateMachines.this.currentStartedEventId = startedEventId;
            WorkflowStateMachines.this.eventLoop();
        }

        @Override
        public void updateRunId(String currentRunId) {
            WorkflowStateMachines.this.currentRunId = currentRunId;
        }
    }

    static enum HandleEventStatus {
        OK,
        NON_MATCHING_EVENT;

    }
}

