/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.ActivityCompletionException;
import io.temporal.internal.external.ManualActivityCompletionClientFactory;
import io.temporal.workflow.Functions;
import java.util.Optional;

class ActivityCompletionClientImpl
implements ActivityCompletionClient {
    private final ManualActivityCompletionClientFactory factory;
    private final Functions.Proc completionHandle;

    public ActivityCompletionClientImpl(ManualActivityCompletionClientFactory manualActivityCompletionClientFactory, Functions.Proc completionHandle) {
        this.factory = manualActivityCompletionClientFactory;
        this.completionHandle = completionHandle;
    }

    @Override
    public <R> void complete(byte[] taskToken, R result) {
        try {
            this.factory.getClient(taskToken).complete(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void complete(String workflowId, Optional<String> runId, String activityId, R result) {
        try {
            this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).complete(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public void completeExceptionally(byte[] taskToken, Exception result) {
        try {
            this.factory.getClient(taskToken).fail(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeExceptionally(String workflowId, Optional<String> runId, String activityId, Exception result) {
        try {
            this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).fail(result);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public <V> void reportCancellation(byte[] taskToken, V details) {
        try {
            this.factory.getClient(taskToken).reportCancellation(details);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> void reportCancellation(String workflowId, Optional<String> runId, String activityId, V details) {
        try {
            this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).reportCancellation(details);
        }
        finally {
            this.completionHandle.apply();
        }
    }

    @Override
    public <V> void heartbeat(byte[] taskToken, V details) throws ActivityCompletionException {
        this.factory.getClient(taskToken).recordHeartbeat(details);
    }

    @Override
    public <V> void heartbeat(String workflowId, Optional<String> runId, String activityId, V details) throws ActivityCompletionException {
        this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).recordHeartbeat(details);
    }

    private static WorkflowExecution toExecution(String workflowId, Optional<String> runId) {
        return WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
    }
}

