/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.activity.ActivityExecutionContext;
import io.temporal.activity.ActivityInfo;
import io.temporal.activity.ManualActivityCompletionClient;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.client.ActivityCanceledException;
import io.temporal.client.ActivityCompletionException;
import io.temporal.client.ActivityCompletionFailureException;
import io.temporal.client.ActivityNotExistsException;
import io.temporal.client.ActivityWorkerShutdownException;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.client.ActivityClientHelper;
import io.temporal.internal.external.ManualActivityCompletionClientFactory;
import io.temporal.internal.external.ManualActivityCompletionClientFactoryImpl;
import io.temporal.internal.sync.CompletionAwareManualCompletionClient;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActivityExecutionContextImpl
implements ActivityExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(ActivityExecutionContextImpl.class);
    private static final long HEARTBEAT_RETRY_WAIT_MILLIS = 1000L;
    private static final long MAX_HEARTBEAT_INTERVAL_MILLIS = 30000L;
    private final WorkflowServiceStubs service;
    private final Lock lock = new ReentrantLock();
    private final ManualActivityCompletionClientFactory manualCompletionClientFactory;
    private final Functions.Proc completionHandle;
    private final ScheduledExecutorService heartbeatExecutor;
    private final long heartbeatIntervalMillis;
    private final DataConverter dataConverter;
    private final String namespace;
    private final String identity;
    private final Scope metricsScope;
    private final ActivityInfo info;
    private boolean useLocalManualCompletion;
    private boolean doNotCompleteOnReturn;
    private boolean hasOutstandingHeartbeat;
    private ActivityCompletionException lastException;
    private Optional<Object> lastDetails;
    private ScheduledFuture future;

    ActivityExecutionContextImpl(WorkflowServiceStubs service, String namespace, ActivityInfo info, DataConverter dataConverter, ScheduledExecutorService heartbeatExecutor, Functions.Proc completionHandle, Scope metricsScope, String identity) {
        this.service = service;
        this.dataConverter = dataConverter;
        this.namespace = namespace;
        this.identity = identity;
        this.metricsScope = metricsScope;
        this.info = info;
        this.heartbeatExecutor = heartbeatExecutor;
        this.heartbeatIntervalMillis = Math.min((long)(0.8 * (double)info.getHeartbeatTimeout().toMillis()), 30000L);
        this.completionHandle = completionHandle;
        this.manualCompletionClientFactory = new ManualActivityCompletionClientFactoryImpl(service, namespace, identity, dataConverter, metricsScope);
    }

    @Override
    public <V> void heartbeat(V details) throws ActivityCompletionException {
        if (this.heartbeatExecutor.isShutdown()) {
            throw new ActivityWorkerShutdownException(this.info);
        }
        this.lock.lock();
        try {
            this.lastDetails = Optional.ofNullable(details);
            this.hasOutstandingHeartbeat = true;
            if (this.future == null) {
                this.doHeartBeat(details);
            }
            if (this.lastException != null) {
                throw this.lastException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <V> Optional<V> getHeartbeatDetails(Class<V> detailsClass) {
        return this.getHeartbeatDetails(detailsClass, detailsClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Optional<V> getHeartbeatDetails(Class<V> detailsClass, Type detailsType) {
        this.lock.lock();
        try {
            if (this.lastDetails != null) {
                Optional<Object> result;
                Optional<Object> optional = result = this.lastDetails;
                return optional;
            }
            Optional<Payloads> details = this.info.getHeartbeatDetails();
            Optional<V> optional = Optional.ofNullable(this.dataConverter.fromPayloads(0, details, detailsClass, detailsType));
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] getTaskToken() {
        return this.info.getTaskToken();
    }

    private void doHeartBeat(Object details) {
        long nextHeartbeatDelay;
        try {
            this.sendHeartbeatRequest(details);
            this.hasOutstandingHeartbeat = false;
            nextHeartbeatDelay = this.heartbeatIntervalMillis;
        }
        catch (StatusRuntimeException e) {
            log.warn("Heartbeat failed", (Throwable)e);
            nextHeartbeatDelay = 1000L;
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
            nextHeartbeatDelay = 1000L;
        }
        this.scheduleNextHeartbeat(nextHeartbeatDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextHeartbeat(long delay) {
        ScheduledFuture<?> f = this.heartbeatExecutor.schedule(() -> {
            this.lock.lock();
            try {
                if (this.hasOutstandingHeartbeat) {
                    Object details = this.lastDetails.orElse(null);
                    this.doHeartBeat(details);
                } else {
                    this.future = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }, delay, TimeUnit.MILLISECONDS);
        this.lock.lock();
        try {
            this.future = f;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void sendHeartbeatRequest(Object details) {
        try {
            RecordActivityTaskHeartbeatResponse status = ActivityClientHelper.sendHeartbeatRequest(this.service, this.namespace, this.identity, this.info.getTaskToken(), this.dataConverter, this.metricsScope, details);
            this.lastException = status.getCancelRequested() ? new ActivityCanceledException(this.info) : null;
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                this.lastException = new ActivityNotExistsException(this.info, (Throwable)e);
            }
            if (e.getStatus().getCode() == Status.Code.INVALID_ARGUMENT || e.getStatus().getCode() == Status.Code.FAILED_PRECONDITION) {
                this.lastException = new ActivityCompletionFailureException(this.info, (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void doNotCompleteOnReturn() {
        this.lock.lock();
        try {
            this.doNotCompleteOnReturn = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDoNotCompleteOnReturn() {
        this.lock.lock();
        try {
            boolean bl = this.doNotCompleteOnReturn;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isUseLocalManualCompletion() {
        this.lock.lock();
        try {
            boolean bl = this.useLocalManualCompletion;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ManualActivityCompletionClient useLocalManualCompletion() {
        this.lock.lock();
        try {
            this.doNotCompleteOnReturn();
            this.useLocalManualCompletion = true;
            CompletionAwareManualCompletionClient completionAwareManualCompletionClient = new CompletionAwareManualCompletionClient(this.manualCompletionClientFactory.getClient(this.info.getTaskToken()), this.completionHandle);
            return completionAwareManualCompletionClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    @Override
    public ActivityInfo getInfo() {
        return this.info;
    }
}

