/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.Header;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkflowExecuteRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecuteRunnable.class);
    private final SyncWorkflowContext context;
    private final SyncWorkflowDefinition workflow;
    private final WorkflowExecutionStartedEventAttributes attributes;
    private final WorkflowImplementationOptions implementationOptions;
    private Optional<Payloads> output = Optional.empty();
    private boolean done;

    public WorkflowExecuteRunnable(SyncWorkflowContext context, SyncWorkflowDefinition workflow, WorkflowExecutionStartedEventAttributes attributes, WorkflowImplementationOptions options) {
        this.implementationOptions = options;
        Objects.requireNonNull(context);
        Objects.requireNonNull(workflow);
        Objects.requireNonNull(attributes);
        this.context = context;
        this.workflow = workflow;
        this.attributes = attributes;
    }

    @Override
    public void run() {
        try {
            Optional<Payloads> input = this.attributes.hasInput() ? Optional.of(this.attributes.getInput()) : Optional.empty();
            this.output = this.workflow.execute(new Header(this.attributes.getHeader()), input);
        }
        catch (Throwable e) {
            if (e instanceof DestroyWorkflowThreadError) {
                throw (DestroyWorkflowThreadError)e;
            }
            Throwable exception = WorkflowInternal.unwrap(e);
            Class<? extends Throwable>[] failTypes = this.implementationOptions.getFailWorkflowExceptionTypes();
            if (exception instanceof TemporalFailure) {
                this.logWorkflowExecutionException(Workflow.getInfo(), exception);
                throw WorkflowExecuteRunnable.mapToWorkflowExecutionException(exception, this.context.getDataConverter());
            }
            for (Class<? extends Throwable> failType : failTypes) {
                boolean cancelRequested;
                if (!failType.isAssignableFrom(exception.getClass())) continue;
                if (!(!log.isErrorEnabled() || (cancelRequested = WorkflowInternal.getRootWorkflowContext().getContext().isCancelRequested()) && FailureConverter.isCanceledCause(exception))) {
                    this.logWorkflowExecutionException(Workflow.getInfo(), exception);
                }
                throw WorkflowExecuteRunnable.mapToWorkflowExecutionException(exception, this.context.getDataConverter());
            }
            throw CheckedExceptionWrapper.wrap((Throwable)exception);
        }
        finally {
            this.done = true;
        }
    }

    public void cancel(String reason) {
    }

    public boolean isDone() {
        return this.done;
    }

    public Optional<Payloads> getOutput() {
        return this.output;
    }

    public void close() {
    }

    public void handleSignal(String signalName, Optional<Payloads> input, long eventId) {
        this.context.handleSignal(signalName, input, eventId);
    }

    public Optional<Payloads> handleQuery(String type, Optional<Payloads> args) {
        return this.context.handleQuery(type, args);
    }

    private void logWorkflowExecutionException(WorkflowInfo info, Throwable exception) {
        log.error("Workflow execution failure WorkflowId=" + info.getWorkflowId() + ", RunId=" + info.getRunId() + ", WorkflowType=" + info.getWorkflowType(), exception);
    }

    static WorkflowExecutionException mapToWorkflowExecutionException(Throwable exception, DataConverter dataConverter) {
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (!(e instanceof TemporalFailure)) continue;
            ((TemporalFailure)e).setDataConverter(dataConverter);
        }
        Failure failure = FailureConverter.exceptionToFailure(exception);
        return new WorkflowExecutionException(failure);
    }
}

