/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.RetryOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.logging.ReplayAwareLogger;
import io.temporal.internal.sync.ActivityInvocationHandler;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.ActivityStubImpl;
import io.temporal.internal.sync.AllOfPromise;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.ChildWorkflowInvocationHandler;
import io.temporal.internal.sync.ChildWorkflowStubImpl;
import io.temporal.internal.sync.CompletablePromiseImpl;
import io.temporal.internal.sync.ContinueAsNewWorkflowInvocationHandler;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.ExternalWorkflowInvocationHandler;
import io.temporal.internal.sync.ExternalWorkflowStubImpl;
import io.temporal.internal.sync.LocalActivityInvocationHandler;
import io.temporal.internal.sync.LocalActivityStubImpl;
import io.temporal.internal.sync.StubMarker;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInfoImpl;
import io.temporal.internal.sync.WorkflowQueueDeprecatedImpl;
import io.temporal.internal.sync.WorkflowQueueImpl;
import io.temporal.internal.sync.WorkflowRetryerInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ChildWorkflowStub;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.DynamicQueryHandler;
import io.temporal.workflow.DynamicSignalHandler;
import io.temporal.workflow.ExternalWorkflowStub;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.WorkflowQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowInternal {
    public static final int DEFAULT_VERSION = -1;

    public static WorkflowThread newWorkflowMethodThread(Runnable runnable, String name) {
        return (WorkflowThread)DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext().getWorkflowInboundInterceptor().newWorkflowMethodThread(runnable, name);
    }

    public static Promise<Void> newTimer(Duration duration) {
        return WorkflowInternal.getWorkflowInterceptor().newTimer(duration);
    }

    @Deprecated
    public static <E> WorkflowQueue<E> newQueue(int capacity) {
        return new WorkflowQueueDeprecatedImpl(capacity);
    }

    public static <E> WorkflowQueue<E> newWorkflowQueue(int capacity) {
        return new WorkflowQueueImpl(capacity);
    }

    public static <E> CompletablePromise<E> newCompletablePromise() {
        return new CompletablePromiseImpl();
    }

    public static <E> Promise<E> newPromise(E value) {
        CompletablePromise result = Workflow.newPromise();
        result.complete(value);
        return result;
    }

    public static <E> Promise<E> newFailedPromise(Exception failure) {
        CompletablePromiseImpl result = new CompletablePromiseImpl();
        result.completeExceptionally(CheckedExceptionWrapper.wrap((Throwable)failure));
        return result;
    }

    public static void registerListener(Object implementation) {
        if (implementation instanceof DynamicSignalHandler) {
            WorkflowInternal.getWorkflowInterceptor().registerDynamicSignalHandler(new WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput((DynamicSignalHandler)implementation));
            return;
        }
        if (implementation instanceof DynamicQueryHandler) {
            WorkflowInternal.getWorkflowInterceptor().registerDynamicQueryHandler(new WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput((DynamicQueryHandler)implementation));
            return;
        }
        Class<?> cls = implementation.getClass();
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newListenerInstance(cls);
        for (POJOWorkflowMethodMetadata methodMetadata : workflowMetadata.getQueryMethods()) {
            Method method = methodMetadata.getWorkflowMethod();
            WorkflowInternal.getWorkflowInterceptor().registerQuery(new WorkflowOutboundCallsInterceptor.RegisterQueryInput(methodMetadata.getName(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    return method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
            }));
        }
        ArrayList<WorkflowOutboundCallsInterceptor.SignalRegistrationRequest> requests = new ArrayList<WorkflowOutboundCallsInterceptor.SignalRegistrationRequest>();
        for (POJOWorkflowMethodMetadata methodMetadata : workflowMetadata.getSignalMethods()) {
            Method method = methodMetadata.getWorkflowMethod();
            requests.add(new WorkflowOutboundCallsInterceptor.SignalRegistrationRequest(methodMetadata.getName(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
            }));
        }
        if (!requests.isEmpty()) {
            WorkflowInternal.getWorkflowInterceptor().registerSignalHandlers(new WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput(requests));
        }
    }

    public static long currentTimeMillis() {
        return WorkflowInternal.getWorkflowInterceptor().currentTimeMillis();
    }

    public static void setDefaultActivityOptions(ActivityOptions activityOptions) {
        WorkflowInternal.getRootWorkflowContext().setDefaultActivityOptions(activityOptions);
    }

    public static void setActivityOptions(Map<String, ActivityOptions> activityMethodOptions) {
        WorkflowInternal.getRootWorkflowContext().setActivityOptions(activityMethodOptions);
    }

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options, Map<String, ActivityOptions> activityMethodOptions) {
        SyncWorkflowContext context = WorkflowInternal.getRootWorkflowContext();
        options = options == null ? context.getDefaultActivityOptions() : options;
        HashMap<String, ActivityOptions> mergedActivityOptionsMap = new HashMap<String, ActivityOptions>();
        Map<String, ActivityOptions> activityOptions = context.getActivityOptions();
        if (activityOptions != null) {
            mergedActivityOptionsMap.putAll(activityOptions);
        }
        if (activityMethodOptions != null) {
            activityMethodOptions.forEach((key, value) -> mergedActivityOptionsMap.merge((String)key, (ActivityOptions)value, (o1, o2) -> o1.toBuilder().mergeActivityOptions((ActivityOptions)o2).build()));
        }
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, options, mergedActivityOptionsMap, context.getWorkflowOutboundInterceptor());
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options, Map<String, LocalActivityOptions> activityMethodOptions) {
        InvocationHandler invocationHandler = LocalActivityInvocationHandler.newInstance(activityInterface, options, activityMethodOptions, WorkflowInternal.getWorkflowInterceptor());
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static ActivityStub newUntypedActivityStub(ActivityOptions options) {
        return ActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static ActivityStub newUntypedLocalActivityStub(LocalActivityOptions options) {
        return LocalActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface, ChildWorkflowOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ChildWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static <T> T newExternalWorkflowStub(Class<T> workflowInterface, WorkflowExecution execution) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ExternalWorkflowInvocationHandler(workflowInterface, execution, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static Promise<WorkflowExecution> getWorkflowExecution(Object workflowStub) {
        if (workflowStub instanceof StubMarker) {
            Object stub = ((StubMarker)workflowStub).__getUntypedStub();
            return ((ChildWorkflowStub)stub).getExecution();
        }
        throw new IllegalArgumentException("Not a workflow stub created through Workflow.newChildWorkflowStub: " + workflowStub);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType, ChildWorkflowOptions options) {
        return new ChildWorkflowStubImpl(workflowType, options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(WorkflowExecution execution) {
        return new ExternalWorkflowStubImpl(execution, WorkflowInternal.getWorkflowInterceptor());
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface, ContinueAsNewOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface}, (InvocationHandler)new ContinueAsNewWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static <R> R executeActivity(String name, ActivityOptions options, Class<R> resultClass, Type resultType, Object ... args) {
        Promise<R> result = WorkflowInternal.getWorkflowInterceptor().executeActivity(new WorkflowOutboundCallsInterceptor.ActivityInput<R>(name, resultClass, resultType, args, options, Header.empty())).getResult();
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return null;
        }
        return result.get();
    }

    private static WorkflowOutboundCallsInterceptor getWorkflowInterceptor() {
        return DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext().getWorkflowOutboundInterceptor();
    }

    static SyncWorkflowContext getRootWorkflowContext() {
        return DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext();
    }

    public static void await(String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        WorkflowInternal.getWorkflowInterceptor().await(reason, unblockCondition);
    }

    public static boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        return WorkflowInternal.getWorkflowInterceptor().await(timeout, reason, unblockCondition);
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        return WorkflowInternal.getWorkflowInterceptor().sideEffect(resultClass, resultType, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.getWorkflowInterceptor().mutableSideEffect(id, resultClass, resultType, updated, func);
    }

    public static int getVersion(String changeId, int minSupported, int maxSupported) {
        return WorkflowInternal.getWorkflowInterceptor().getVersion(changeId, minSupported, maxSupported);
    }

    public static <V> Promise<Void> promiseAllOf(Iterable<Promise<V>> promises) {
        return new AllOfPromise(promises);
    }

    public static Promise<Void> promiseAllOf(Promise<?> ... promises) {
        return new AllOfPromise(promises);
    }

    public static <V> Promise<V> promiseAnyOf(Iterable<Promise<V>> promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static Promise<Object> promiseAnyOf(Promise<?> ... promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static CancellationScope newCancellationScope(boolean detached, Runnable runnable) {
        return new CancellationScopeImpl(detached, runnable);
    }

    public static CancellationScope newCancellationScope(boolean detached, Functions.Proc1<CancellationScope> proc) {
        return new CancellationScopeImpl(detached, proc);
    }

    public static CancellationScopeImpl currentCancellationScope() {
        return CancellationScopeImpl.current();
    }

    public static RuntimeException wrap(Throwable e) {
        return CheckedExceptionWrapper.wrap((Throwable)e);
    }

    public static Throwable unwrap(Throwable e) {
        return CheckedExceptionWrapper.unwrap((Throwable)e);
    }

    private WorkflowInternal() {
    }

    public static boolean isReplaying() {
        Optional<WorkflowThread> thread = DeterministicRunnerImpl.currentThreadInternalIfPresent();
        return thread.isPresent() && WorkflowInternal.getRootWorkflowContext().isReplaying();
    }

    public static WorkflowInfo getWorkflowInfo() {
        return new WorkflowInfoImpl(WorkflowInternal.getRootWorkflowContext().getContext());
    }

    public static <T> T getMemo(String key, Class<T> valueClass, Type valueType) {
        Payload memo = WorkflowInternal.getRootWorkflowContext().getContext().getMemo(key);
        if (memo == null) {
            return null;
        }
        return WorkflowInternal.getDataConverter().fromPayload(memo, valueClass, valueType);
    }

    public static <R> R retry(RetryOptions options, Optional<Duration> expiration, Functions.Func<R> fn) {
        return WorkflowRetryerInternal.validateOptionsAndRetry(options, expiration, fn);
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
        WorkflowInternal.getWorkflowInterceptor().continueAsNew(new WorkflowOutboundCallsInterceptor.ContinueAsNewInput(workflowType, options, args, Header.empty()));
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args, WorkflowOutboundCallsInterceptor outboundCallsInterceptor) {
        outboundCallsInterceptor.continueAsNew(new WorkflowOutboundCallsInterceptor.ContinueAsNewInput(workflowType, options, args, Header.empty()));
    }

    public static Promise<Void> cancelWorkflow(WorkflowExecution execution) {
        return WorkflowInternal.getWorkflowInterceptor().cancelWorkflow(new WorkflowOutboundCallsInterceptor.CancelWorkflowInput(execution)).getResult();
    }

    public static void sleep(Duration duration) {
        WorkflowInternal.getWorkflowInterceptor().sleep(duration);
    }

    public static Scope getMetricsScope() {
        return WorkflowInternal.getRootWorkflowContext().getMetricsScope();
    }

    private static boolean isLoggingEnabledInReplay() {
        return WorkflowInternal.getRootWorkflowContext().isLoggingEnabledInReplay();
    }

    public static UUID randomUUID() {
        return WorkflowInternal.getRootWorkflowContext().randomUUID();
    }

    public static Random newRandom() {
        return WorkflowInternal.getRootWorkflowContext().newRandom();
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return WorkflowInternal.getRootWorkflowContext().getLastCompletionResult(resultClass, resultType);
    }

    public static void upsertSearchAttributes(Map<String, Object> searchAttributes) {
        WorkflowInternal.getWorkflowInterceptor().upsertSearchAttributes(searchAttributes);
    }

    public static DataConverter getDataConverter() {
        return WorkflowInternal.getRootWorkflowContext().getDataConverter();
    }

    public static String getWorkflowType(Class<?> workflowInterfaceClass) {
        POJOWorkflowInterfaceMetadata metadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterfaceClass);
        return metadata.getWorkflowType().get();
    }

    public static Optional<Exception> getPreviousRunFailure() {
        return WorkflowInternal.getRootWorkflowContext().getPreviousRunFailure().map(f -> FailureConverter.failureToException(f, DataConverter.getDefaultInstance()));
    }
}

