/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import java.time.Duration;
import java.util.Map;

public final class ContinueAsNewOptions {
    private static final ContinueAsNewOptions DEFAULT_INSTANCE = ContinueAsNewOptions.newBuilder().build();
    private final Duration workflowRunTimeout;
    private final String taskQueue;
    private final Duration workflowTaskTimeout;
    private final Map<String, Object> memo;
    private final Map<String, Object> searchAttributes;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ContinueAsNewOptions options) {
        return new Builder(options);
    }

    public static ContinueAsNewOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ContinueAsNewOptions(Duration workflowRunTimeout, String taskQueue, Duration workflowTaskTimeout, Map<String, Object> memo, Map<String, Object> searchAttributes) {
        this.workflowRunTimeout = workflowRunTimeout;
        this.taskQueue = taskQueue;
        this.workflowTaskTimeout = workflowTaskTimeout;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
    }

    public Duration getWorkflowRunTimeout() {
        return this.workflowRunTimeout;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public Duration getWorkflowTaskTimeout() {
        return this.workflowTaskTimeout;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    public static final class Builder {
        private Duration workflowRunTimeout;
        private String taskQueue;
        private Duration workflowTaskTimeout;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;

        private Builder() {
        }

        private Builder(ContinueAsNewOptions options) {
            if (options == null) {
                return;
            }
            this.workflowRunTimeout = options.workflowRunTimeout;
            this.taskQueue = options.taskQueue;
            this.workflowTaskTimeout = options.workflowTaskTimeout;
        }

        public Builder setWorkflowRunTimeout(Duration workflowRunTimeout) {
            this.workflowRunTimeout = workflowRunTimeout;
            return this;
        }

        public Builder setTaskQueue(String taskQueue) {
            this.taskQueue = taskQueue;
            return this;
        }

        public Builder setWorkflowTaskTimeout(Duration workflowTaskTimeout) {
            this.workflowTaskTimeout = workflowTaskTimeout;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            this.searchAttributes = searchAttributes;
            return this;
        }

        public ContinueAsNewOptions build() {
            return new ContinueAsNewOptions(this.workflowRunTimeout, this.taskQueue, this.workflowTaskTimeout, this.memo, this.searchAttributes);
        }
    }
}

