/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.GrpcDeadlineInterceptor;
import io.temporal.serviceclient.GrpcMetricsInterceptor;
import io.temporal.serviceclient.GrpcTracingInterceptor;
import io.temporal.serviceclient.Version;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowServiceStubsImpl
implements WorkflowServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceStubsImpl.class);
    private static final int MAX_INBOUND_MESSAGE_SIZE = 25000000;
    private static final Metadata.Key<String> LIBRARY_VERSION_HEADER_KEY = Metadata.Key.of((String)"client-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SUPPORTED_SERVER_VERSIONS_HEADER_KEY = Metadata.Key.of((String)"supported-server-versions", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CLIENT_NAME_HEADER_KEY = Metadata.Key.of((String)"client-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String CLIENT_NAME_HEADER_VALUE = "temporal-java";
    private final WorkflowServiceStubsOptions options;
    private final ManagedChannel channel;
    private final boolean channelNeedsShutdown;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub;
    private final WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub;
    private final Server inProcessServer;
    private final ScheduledExecutorService scheduledBackoffResetter;

    public WorkflowServiceStubsImpl(WorkflowServiceGrpc.WorkflowServiceImplBase serviceImpl, WorkflowServiceStubsOptions options) {
        if (serviceImpl != null) {
            if (options.getChannel() != null) {
                throw new IllegalArgumentException("both channel and serviceImpl present");
            }
            String serverName = InProcessServerBuilder.generateName();
            try {
                this.inProcessServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)serviceImpl)).build().start();
            }
            catch (IOException unexpected) {
                throw new RuntimeException(unexpected);
            }
            options = WorkflowServiceStubsOptions.newBuilder(options).setChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build()).build();
        } else {
            this.inProcessServer = null;
        }
        this.options = options = WorkflowServiceStubsOptions.newBuilder(options).validateAndBuildWithDefaults();
        ScheduledExecutorService backoffResetter = null;
        if (options.getChannel() != null) {
            this.channel = options.getChannel();
            this.channelNeedsShutdown = serviceImpl != null;
        } else {
            NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)options.getTarget()).defaultLoadBalancingPolicy("round_robin")).maxInboundMessageSize(25000000);
            if (options.getSslContext() == null && !options.getEnableHttps()) {
                builder.usePlaintext();
            } else if (options.getSslContext() != null) {
                builder.sslContext(options.getSslContext());
            } else {
                builder.useTransportSecurity();
            }
            this.channel = builder.build();
            if (options.getConnectionBackoffResetFrequency() != null) {
                backoffResetter = this.startConnectionBackoffResetter(options.getConnectionBackoffResetFrequency());
            }
            this.channelNeedsShutdown = true;
        }
        this.scheduledBackoffResetter = backoffResetter;
        GrpcMetricsInterceptor metricsInterceptor = new GrpcMetricsInterceptor(options.getMetricsScope());
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options);
        GrpcTracingInterceptor tracingInterceptor = new GrpcTracingInterceptor();
        Metadata headers = new Metadata();
        headers.put(LIBRARY_VERSION_HEADER_KEY, (Object)Version.LIBRARY_VERSION);
        headers.put(SUPPORTED_SERVER_VERSIONS_HEADER_KEY, (Object)">=0.31.0 <2.0.0");
        headers.put(CLIENT_NAME_HEADER_KEY, (Object)CLIENT_NAME_HEADER_VALUE);
        Channel interceptedChannel = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{metricsInterceptor, deadlineInterceptor, MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)});
        if (tracingInterceptor.isEnabled()) {
            interceptedChannel = ClientInterceptors.intercept((Channel)interceptedChannel, (ClientInterceptor[])new ClientInterceptor[]{tracingInterceptor});
        }
        WorkflowServiceGrpc.WorkflowServiceBlockingStub bs = WorkflowServiceGrpc.newBlockingStub(interceptedChannel);
        if (options.getBlockingStubInterceptor().isPresent()) {
            bs = options.getBlockingStubInterceptor().get().apply(bs);
        }
        this.blockingStub = bs;
        WorkflowServiceGrpc.WorkflowServiceFutureStub fs = WorkflowServiceGrpc.newFutureStub(interceptedChannel);
        if (options.getFutureStubInterceptor().isPresent()) {
            fs = options.getFutureStubInterceptor().get().apply(fs);
        }
        this.futureStub = fs;
        log.info(String.format("Created GRPC client for channel: %s", this.channel));
    }

    private ScheduledExecutorService startConnectionBackoffResetter(Duration backoffResetFrequency) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleWithFixedDelay(() -> {
            try {
                log.debug("Resetting gRPC connection backoff.");
                this.channel.resetConnectBackoff();
            }
            catch (Exception e) {
                log.warn("Unable to reset gRPC connection backoff.", (Throwable)e);
            }
        }, backoffResetFrequency.getSeconds(), backoffResetFrequency.getSeconds(), TimeUnit.SECONDS);
        return executor;
    }

    @Override
    public WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    public WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    public void shutdown() {
        log.info("shutdown");
        this.shutdownRequested.set(true);
        if (this.channelNeedsShutdown) {
            this.channel.shutdown();
        }
        if (this.inProcessServer != null) {
            this.inProcessServer.shutdown();
        }
        if (this.scheduledBackoffResetter != null) {
            this.scheduledBackoffResetter.shutdown();
        }
    }

    @Override
    public void shutdownNow() {
        log.info("shutdownNow");
        this.shutdownRequested.set(true);
        if (this.channelNeedsShutdown) {
            this.channel.shutdownNow();
        }
        if (this.inProcessServer != null) {
            this.inProcessServer.shutdownNow();
        }
        if (this.scheduledBackoffResetter != null) {
            this.scheduledBackoffResetter.shutdownNow();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.currentTimeMillis();
        if (this.channelNeedsShutdown) {
            return this.channel.awaitTermination(timeout, unit);
        }
        long left = System.currentTimeMillis() - unit.toMillis(start);
        if (this.inProcessServer != null) {
            this.inProcessServer.awaitTermination(left, TimeUnit.MILLISECONDS);
        }
        left = System.currentTimeMillis() - unit.toMillis(start);
        if (this.scheduledBackoffResetter != null) {
            this.scheduledBackoffResetter.awaitTermination(left, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    @Override
    public WorkflowServiceStubsOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean isShutdown() {
        boolean result = this.channelNeedsShutdown ? this.channel.isShutdown() : this.shutdownRequested.get();
        if (this.inProcessServer != null) {
            boolean bl = result = result && this.inProcessServer.isShutdown();
        }
        if (this.scheduledBackoffResetter != null) {
            result = result && this.scheduledBackoffResetter.isShutdown();
        }
        return result;
    }

    @Override
    public boolean isTerminated() {
        boolean result = this.channelNeedsShutdown ? this.channel.isTerminated() : this.shutdownRequested.get();
        if (this.inProcessServer != null) {
            boolean bl = result = result && this.inProcessServer.isTerminated();
        }
        if (this.scheduledBackoffResetter != null) {
            result = result && this.scheduledBackoffResetter.isTerminated();
        }
        return result;
    }
}

