/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.collect.ImmutableMap;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class WorkflowServiceStubsOptions {
    private static final String LOCAL_DOCKER_TARGET = "127.0.0.1:7233";
    private static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_POLL_RPC_TIMEOUT = Duration.ofSeconds(121L);
    private static final Duration DEFAULT_QUERY_RPC_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY = Duration.ofSeconds(10L);
    private static final WorkflowServiceStubsOptions DEFAULT_INSTANCE = WorkflowServiceStubsOptions.newBuilder().build();
    private final ManagedChannel channel;
    private final String target;
    private final SslContext sslContext;
    private final boolean enableHttps;
    private final Duration rpcTimeout;
    private final Duration rpcLongPollTimeout;
    private final Duration rpcQueryTimeout;
    private final Duration connectionBackoffResetFrequency;
    private final Map<String, String> headers;
    private final Scope metricsScope;
    private final Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub> blockingStubInterceptor;
    private final Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> futureStubInterceptor;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowServiceStubsOptions options) {
        return new Builder(options);
    }

    public static WorkflowServiceStubsOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkflowServiceStubsOptions(Builder builder) {
        this.target = builder.target;
        this.sslContext = builder.sslContext;
        this.enableHttps = builder.enableHttps;
        this.channel = builder.channel;
        this.rpcLongPollTimeout = builder.rpcLongPollTimeout;
        this.rpcQueryTimeout = builder.rpcQueryTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.connectionBackoffResetFrequency = builder.connectionBackoffResetFrequency;
        this.blockingStubInterceptor = builder.blockingStubInterceptor;
        this.futureStubInterceptor = builder.futureStubInterceptor;
        this.headers = builder.headers;
        this.metricsScope = builder.metricsScope;
    }

    private WorkflowServiceStubsOptions(Builder builder, boolean ignore) {
        if (builder.target != null && builder.channel != null) {
            throw new IllegalStateException("Only one of the target and channel options can be set at a time");
        }
        if (builder.sslContext != null && builder.channel != null) {
            throw new IllegalStateException("Only one of the sslContext and channel options can be set at a time");
        }
        if (builder.enableHttps && builder.channel != null) {
            throw new IllegalStateException("Only one of the enableHttps and channel options can be set at a time");
        }
        this.target = builder.target == null && builder.channel == null ? LOCAL_DOCKER_TARGET : builder.target;
        this.sslContext = builder.sslContext;
        this.enableHttps = builder.enableHttps;
        this.channel = builder.channel;
        this.rpcLongPollTimeout = builder.rpcLongPollTimeout;
        this.rpcQueryTimeout = builder.rpcQueryTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.connectionBackoffResetFrequency = builder.connectionBackoffResetFrequency;
        this.blockingStubInterceptor = builder.blockingStubInterceptor;
        this.futureStubInterceptor = builder.futureStubInterceptor;
        this.headers = builder.headers == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)builder.headers);
        this.metricsScope = builder.metricsScope == null ? new NoopScope() : builder.metricsScope;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String getTarget() {
        return this.target;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean getEnableHttps() {
        return this.enableHttps;
    }

    public Duration getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Duration getRpcLongPollTimeout() {
        return this.rpcLongPollTimeout;
    }

    public Duration getRpcQueryTimeout() {
        return this.rpcQueryTimeout;
    }

    public Duration getConnectionBackoffResetFrequency() {
        return this.connectionBackoffResetFrequency;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub>> getBlockingStubInterceptor() {
        return Optional.ofNullable(this.blockingStubInterceptor);
    }

    public Optional<Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub>> getFutureStubInterceptor() {
        return Optional.ofNullable(this.futureStubInterceptor);
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    static /* synthetic */ Duration access$1400() {
        return DEFAULT_RPC_TIMEOUT;
    }

    static /* synthetic */ Duration access$1500() {
        return DEFAULT_POLL_RPC_TIMEOUT;
    }

    static /* synthetic */ Duration access$1600() {
        return DEFAULT_QUERY_RPC_TIMEOUT;
    }

    static /* synthetic */ Duration access$1700() {
        return DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY;
    }

    public static class Builder {
        private ManagedChannel channel;
        private SslContext sslContext;
        private boolean enableHttps;
        private String target;
        private Duration rpcTimeout = WorkflowServiceStubsOptions.access$1400();
        private Duration rpcLongPollTimeout = WorkflowServiceStubsOptions.access$1500();
        private Duration rpcQueryTimeout = WorkflowServiceStubsOptions.access$1600();
        private Duration connectionBackoffResetFrequency = WorkflowServiceStubsOptions.access$1700();
        private Map<String, String> headers;
        private Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub> blockingStubInterceptor;
        private Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> futureStubInterceptor;
        private Scope metricsScope;

        private Builder() {
        }

        private Builder(WorkflowServiceStubsOptions options) {
            this.target = options.target;
            this.channel = options.channel;
            this.enableHttps = options.enableHttps;
            this.sslContext = options.sslContext;
            this.rpcLongPollTimeout = options.rpcLongPollTimeout;
            this.rpcQueryTimeout = options.rpcQueryTimeout;
            this.rpcTimeout = options.rpcTimeout;
            this.connectionBackoffResetFrequency = options.connectionBackoffResetFrequency;
            this.blockingStubInterceptor = options.blockingStubInterceptor;
            this.futureStubInterceptor = options.futureStubInterceptor;
            this.headers = options.headers;
            this.metricsScope = options.metricsScope;
        }

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setEnableHttps(boolean enableHttps) {
            this.enableHttps = enableHttps;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setRpcTimeout(Duration timeout) {
            this.rpcTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setRpcLongPollTimeout(Duration timeout) {
            this.rpcLongPollTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setConnectionBackoffResetFrequency(Duration connectionBackoffResetFrequency) {
            this.connectionBackoffResetFrequency = connectionBackoffResetFrequency;
            return this;
        }

        public Builder setQueryRpcTimeout(Duration timeout) {
            this.rpcQueryTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setBlockingStubInterceptor(Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub> blockingStubInterceptor) {
            this.blockingStubInterceptor = blockingStubInterceptor;
            return this;
        }

        public Builder setFutureStubInterceptor(Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> futureStubInterceptor) {
            this.futureStubInterceptor = futureStubInterceptor;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public WorkflowServiceStubsOptions build() {
            return new WorkflowServiceStubsOptions(this);
        }

        public WorkflowServiceStubsOptions validateAndBuildWithDefaults() {
            return new WorkflowServiceStubsOptions(this, true);
        }
    }
}

