/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.LongPollUtil;
import io.temporal.serviceclient.MetricsTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class GrpcMetricsInterceptor
implements ClientInterceptor {
    private final Scope defaultScope;
    private final Map<MethodDescriptor<?, ?>, Map<String, String>> methodTags = new HashMap();

    GrpcMetricsInterceptor(Scope scope) {
        this.defaultScope = scope.tagged(MetricsTag.defaultTags("none"));
        ServiceDescriptor descriptor = WorkflowServiceGrpc.getServiceDescriptor();
        String serviceName = descriptor.getName();
        Collection methods = descriptor.getMethods();
        for (MethodDescriptor method : methods) {
            int beginIndex = serviceName.length() + 1;
            String name = method.getFullMethodName().substring(beginIndex);
            ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"Operation", (Object)name).build();
            this.methodTags.put(method, (Map<String, String>)tags);
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Scope scope = (Scope)callOptions.getOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY);
        if (scope == null) {
            scope = this.defaultScope;
        }
        Map<String, String> tags = this.methodTags.get(method);
        scope = scope.tagged(tags);
        return new MetricsClientCall<ReqT, RespT>(next, method, callOptions, scope);
    }

    private static class MetricsClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Scope metricsScope;
        private final Stopwatch sw;
        private final boolean longPoll;

        public MetricsClientCall(Channel next, MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Scope metricsScope) {
            super(next.newCall(method, callOptions));
            this.metricsScope = metricsScope;
            this.longPoll = LongPollUtil.isLongPoll(method, callOptions);
            if (this.longPoll) {
                metricsScope.counter("temporal_long_request").inc(1L);
                this.sw = metricsScope.timer("temporal_long_request_latency").start();
            } else {
                metricsScope.counter("temporal_request").inc(1L);
                this.sw = metricsScope.timer("temporal_request_latency").start();
            }
        }

        public void sendMessage(ReqT message) {
            super.sendMessage(message);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            ForwardingClientCallListener.SimpleForwardingClientCallListener listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                public void onClose(Status status, Metadata trailers) {
                    if (!status.isOk()) {
                        Status.Code code = status.getCode();
                        Scope scope = metricsScope.tagged((Map)new ImmutableMap.Builder(1).put((Object)"StatusCode", (Object)String.valueOf(code)).build());
                        if (longPoll) {
                            scope.counter("temporal_long_request_failure").inc(1L);
                        } else {
                            scope.counter("temporal_request_failure").inc(1L);
                        }
                    }
                    super.onClose(status, trailers);
                    sw.stop();
                }
            };
            super.start((ClientCall.Listener)listener, headers);
        }
    }
}

