/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.GrpcDeadlineInterceptor;
import io.temporal.serviceclient.GrpcMetricsInterceptor;
import io.temporal.serviceclient.GrpcRetryer;
import io.temporal.serviceclient.GrpcTracingInterceptor;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.Version;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowServiceStubsImpl
implements WorkflowServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceStubsImpl.class);
    private static final int MAX_INBOUND_MESSAGE_SIZE = 25000000;
    private static final Metadata.Key<String> LIBRARY_VERSION_HEADER_KEY = Metadata.Key.of((String)"client-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SUPPORTED_SERVER_VERSIONS_HEADER_KEY = Metadata.Key.of((String)"supported-server-versions", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CLIENT_NAME_HEADER_KEY = Metadata.Key.of((String)"client-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String CLIENT_NAME_HEADER_VALUE = "temporal-java";
    private static final String HEALTH_CHECK_SERVICE_NAME = "temporal.api.workflowservice.v1.WorkflowService";
    private final WorkflowServiceStubsOptions options;
    private final ManagedChannel channel;
    private final boolean channelNeedsShutdown;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub;
    private final WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub;
    private final HealthGrpc.HealthBlockingStub healthBlockingStub;
    private final Server inProcessServer;
    private final ScheduledExecutorService grpcConnectionManager;

    public WorkflowServiceStubsImpl(WorkflowServiceGrpc.WorkflowServiceImplBase serviceImpl, WorkflowServiceStubsOptions options) {
        if (serviceImpl != null) {
            if (options.getChannel() != null) {
                throw new IllegalArgumentException("both channel and serviceImpl present");
            }
            String serverName = InProcessServerBuilder.generateName();
            try {
                this.inProcessServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)serviceImpl)).build().start();
            }
            catch (IOException unexpected) {
                throw new RuntimeException(unexpected);
            }
            options = WorkflowServiceStubsOptions.newBuilder(options).setChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build()).build();
        } else {
            this.inProcessServer = null;
        }
        this.options = options = WorkflowServiceStubsOptions.newBuilder(options).validateAndBuildWithDefaults();
        this.grpcConnectionManager = this.grpcConnectionManager();
        if (options.getChannel() != null) {
            this.channel = options.getChannel();
            this.channelNeedsShutdown = serviceImpl != null;
        } else {
            NettyChannelBuilder builder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)options.getTarget()).defaultLoadBalancingPolicy("round_robin")).maxInboundMessageSize(25000000);
            if (options.getEnableKeepAlive()) {
                builder.keepAliveTime(options.getKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(options.getKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(options.getKeepAlivePermitWithoutStream());
            }
            if (options.getSslContext() == null && !options.getEnableHttps()) {
                builder.usePlaintext();
            } else if (options.getSslContext() != null) {
                builder.sslContext(options.getSslContext());
            } else {
                builder.useTransportSecurity();
            }
            this.channel = builder.build();
            if (options.getConnectionBackoffResetFrequency() != null) {
                this.grpcConnectionManager.scheduleWithFixedDelay(this.resetGrpcConnectionBackoffTask(), options.getConnectionBackoffResetFrequency().getSeconds(), options.getConnectionBackoffResetFrequency().getSeconds(), TimeUnit.SECONDS);
            }
            if (options.getGrpcReconnectFrequency() != null) {
                this.grpcConnectionManager.scheduleWithFixedDelay(this.enterGrpcIdleChannelStateTask(), options.getGrpcReconnectFrequency().getSeconds(), options.getGrpcReconnectFrequency().getSeconds(), TimeUnit.SECONDS);
            }
            this.channelNeedsShutdown = true;
        }
        this.healthBlockingStub = HealthGrpc.newBlockingStub((Channel)this.channel);
        this.checkHealth();
        GrpcMetricsInterceptor metricsInterceptor = new GrpcMetricsInterceptor(options.getMetricsScope());
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options);
        GrpcTracingInterceptor tracingInterceptor = new GrpcTracingInterceptor();
        Metadata headers = new Metadata();
        headers.merge(options.getHeaders());
        headers.put(LIBRARY_VERSION_HEADER_KEY, (Object)Version.LIBRARY_VERSION);
        headers.put(SUPPORTED_SERVER_VERSIONS_HEADER_KEY, (Object)">=0.31.0 <2.0.0");
        headers.put(CLIENT_NAME_HEADER_KEY, (Object)CLIENT_NAME_HEADER_VALUE);
        Channel interceptedChannel = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{metricsInterceptor, deadlineInterceptor, MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)});
        if (tracingInterceptor.isEnabled()) {
            interceptedChannel = ClientInterceptors.intercept((Channel)interceptedChannel, (ClientInterceptor[])new ClientInterceptor[]{tracingInterceptor});
        }
        WorkflowServiceGrpc.WorkflowServiceBlockingStub bs = WorkflowServiceGrpc.newBlockingStub(interceptedChannel);
        if (options.getBlockingStubInterceptor().isPresent()) {
            bs = options.getBlockingStubInterceptor().get().apply(bs);
        }
        this.blockingStub = bs;
        WorkflowServiceGrpc.WorkflowServiceFutureStub fs = WorkflowServiceGrpc.newFutureStub(interceptedChannel);
        if (options.getFutureStubInterceptor().isPresent()) {
            fs = options.getFutureStubInterceptor().get().apply(fs);
        }
        this.futureStub = fs;
        log.info(String.format("Created GRPC client for channel: %s", this.channel));
    }

    private Runnable enterGrpcIdleChannelStateTask() {
        return () -> {
            try {
                log.debug("Entering IDLE state on the gRPC channel.");
                this.channel.enterIdle();
            }
            catch (Exception e) {
                log.warn("Unable to enter IDLE state on the gRPC channel.", (Throwable)e);
            }
        };
    }

    private Runnable resetGrpcConnectionBackoffTask() {
        return () -> {
            try {
                log.debug("Resetting gRPC connection backoff.");
                this.channel.resetConnectBackoff();
            }
            catch (Exception e) {
                log.warn("Unable to reset gRPC connection backoff.", (Throwable)e);
            }
        };
    }

    private ScheduledExecutorService grpcConnectionManager() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("grpc-connection-manager-thread-%d").build());
    }

    private void checkHealth() {
        this.checkHealth(HEALTH_CHECK_SERVICE_NAME);
    }

    @VisibleForTesting
    void checkHealth(String serviceName) {
        RpcRetryOptions retryOptions;
        HealthCheckResponse response;
        if (!this.options.getDisableHealthCheck() && !HealthCheckResponse.ServingStatus.SERVING.equals((Object)(response = GrpcRetryer.retryWithResult(retryOptions = RpcRetryOptions.newBuilder().setExpiration(this.getOptions().getHealthCheckTimeout()).validateBuildWithDefaults(), () -> ((HealthGrpc.HealthBlockingStub)this.healthBlockingStub.withDeadline(Deadline.after((long)this.options.getHealthCheckAttemptTimeout().getSeconds(), (TimeUnit)TimeUnit.SECONDS))).check(HealthCheckRequest.newBuilder().setService(serviceName).build()))).getStatus())) {
            throw new RuntimeException("Health check returned unhealthy status: " + response.getStatus());
        }
    }

    @Override
    public WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    public WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    public void shutdown() {
        log.info("shutdown");
        this.shutdownRequested.set(true);
        if (this.channelNeedsShutdown) {
            this.channel.shutdown();
        }
        if (this.inProcessServer != null) {
            this.inProcessServer.shutdown();
        }
        if (this.grpcConnectionManager != null) {
            this.grpcConnectionManager.shutdown();
        }
    }

    @Override
    public void shutdownNow() {
        log.info("shutdownNow");
        this.shutdownRequested.set(true);
        if (this.channelNeedsShutdown) {
            this.channel.shutdownNow();
        }
        if (this.inProcessServer != null) {
            this.inProcessServer.shutdownNow();
        }
        if (this.grpcConnectionManager != null) {
            this.grpcConnectionManager.shutdownNow();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        try {
            long start = System.currentTimeMillis();
            if (this.channelNeedsShutdown) {
                return this.channel.awaitTermination(timeout, unit);
            }
            long left = System.currentTimeMillis() - unit.toMillis(start);
            if (this.inProcessServer != null) {
                this.inProcessServer.awaitTermination(left, TimeUnit.MILLISECONDS);
            }
            left = System.currentTimeMillis() - unit.toMillis(start);
            if (this.grpcConnectionManager != null) {
                this.grpcConnectionManager.awaitTermination(left, TimeUnit.MILLISECONDS);
            }
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public WorkflowServiceStubsOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean isShutdown() {
        boolean result = this.channelNeedsShutdown ? this.channel.isShutdown() : this.shutdownRequested.get();
        if (this.inProcessServer != null) {
            boolean bl = result = result && this.inProcessServer.isShutdown();
        }
        if (this.grpcConnectionManager != null) {
            result = result && this.grpcConnectionManager.isShutdown();
        }
        return result;
    }

    @Override
    public boolean isTerminated() {
        boolean result = this.channelNeedsShutdown ? this.channel.isTerminated() : this.shutdownRequested.get();
        if (this.inProcessServer != null) {
            boolean bl = result = result && this.inProcessServer.isTerminated();
        }
        if (this.grpcConnectionManager != null) {
            result = result && this.grpcConnectionManager.isTerminated();
        }
        return result;
    }
}

