/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.RpcRetryOptions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class WorkflowServiceStubsOptions {
    private static final String LOCAL_DOCKER_TARGET = "127.0.0.1:7233";
    private static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_POLL_RPC_TIMEOUT = Duration.ofSeconds(70L);
    private static final Duration DEFAULT_QUERY_RPC_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_GRPC_RECONNECT_FREQUENCY = Duration.ofMinutes(1L);
    private static final WorkflowServiceStubsOptions DEFAULT_INSTANCE = WorkflowServiceStubsOptions.newBuilder().build();
    private final ManagedChannel channel;
    private final String target;
    private final SslContext sslContext;
    private final boolean enableHttps;
    private final boolean disableHealthCheck;
    private final Duration healthCheckAttemptTimeout;
    private final Duration healthCheckTimeout;
    private final boolean enableKeepAlive;
    private final Duration keepAliveTime;
    private final Duration keepAliveTimeout;
    private final boolean keepAlivePermitWithoutStream;
    private final Duration rpcTimeout;
    private final Duration rpcLongPollTimeout;
    private final Duration rpcQueryTimeout;
    private RpcRetryOptions rpcRetryOptions;
    private final Duration connectionBackoffResetFrequency;
    private final Duration grpcReconnectFrequency;
    private final Metadata headers;
    private final Scope metricsScope;
    private final Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub> blockingStubInterceptor;
    private final Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> futureStubInterceptor;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowServiceStubsOptions options) {
        return new Builder(options);
    }

    public static WorkflowServiceStubsOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkflowServiceStubsOptions(Builder builder) {
        this.target = builder.target;
        this.sslContext = builder.sslContext;
        this.enableHttps = builder.enableHttps;
        this.channel = builder.channel;
        this.rpcLongPollTimeout = builder.rpcLongPollTimeout;
        this.rpcQueryTimeout = builder.rpcQueryTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.rpcRetryOptions = builder.rpcRetryOptions;
        this.connectionBackoffResetFrequency = builder.connectionBackoffResetFrequency;
        this.grpcReconnectFrequency = builder.grpcReconnectFrequency;
        this.blockingStubInterceptor = builder.blockingStubInterceptor;
        this.futureStubInterceptor = builder.futureStubInterceptor;
        this.headers = builder.headers;
        this.metricsScope = builder.metricsScope;
        this.disableHealthCheck = builder.disableHealthCheck;
        this.healthCheckAttemptTimeout = builder.healthCheckAttemptTimeout;
        this.healthCheckTimeout = builder.healthCheckTimeout;
        this.enableKeepAlive = builder.enableKeepAlive;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAlivePermitWithoutStream = builder.keepAlivePermitWithoutStream;
    }

    private WorkflowServiceStubsOptions(Builder builder, boolean ignore) {
        if (builder.target != null && builder.channel != null) {
            throw new IllegalStateException("Only one of the target and channel options can be set at a time");
        }
        if (builder.sslContext != null && builder.channel != null) {
            throw new IllegalStateException("Only one of the sslContext and channel options can be set at a time");
        }
        if (builder.enableHttps && builder.channel != null) {
            throw new IllegalStateException("Only one of the enableHttps and channel options can be set at a time");
        }
        this.target = builder.target == null && builder.channel == null ? LOCAL_DOCKER_TARGET : builder.target;
        this.sslContext = builder.sslContext;
        this.enableHttps = builder.enableHttps;
        this.channel = builder.channel;
        this.rpcLongPollTimeout = builder.rpcLongPollTimeout;
        this.rpcQueryTimeout = builder.rpcQueryTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.connectionBackoffResetFrequency = builder.connectionBackoffResetFrequency;
        this.grpcReconnectFrequency = builder.grpcReconnectFrequency;
        this.blockingStubInterceptor = builder.blockingStubInterceptor;
        this.futureStubInterceptor = builder.futureStubInterceptor;
        this.headers = builder.headers != null ? builder.headers : new Metadata();
        this.metricsScope = builder.metricsScope == null ? new NoopScope() : builder.metricsScope;
        this.disableHealthCheck = builder.disableHealthCheck;
        this.healthCheckAttemptTimeout = builder.healthCheckAttemptTimeout == null ? Duration.ofSeconds(5L) : builder.healthCheckAttemptTimeout;
        this.healthCheckTimeout = builder.healthCheckTimeout == null ? Duration.ofSeconds(10L) : builder.healthCheckTimeout;
        this.enableKeepAlive = builder.enableKeepAlive;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAlivePermitWithoutStream = builder.keepAlivePermitWithoutStream;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String getTarget() {
        return this.target;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean getEnableHttps() {
        return this.enableHttps;
    }

    public boolean getDisableHealthCheck() {
        return this.disableHealthCheck;
    }

    public Duration getHealthCheckAttemptTimeout() {
        return this.healthCheckAttemptTimeout;
    }

    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public boolean getEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getKeepAlivePermitWithoutStream() {
        return this.keepAlivePermitWithoutStream;
    }

    public Duration getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Duration getRpcLongPollTimeout() {
        return this.rpcLongPollTimeout;
    }

    public Duration getRpcQueryTimeout() {
        return this.rpcQueryTimeout;
    }

    public RpcRetryOptions getRpcRetryOptions() {
        return this.rpcRetryOptions;
    }

    public Duration getConnectionBackoffResetFrequency() {
        return this.connectionBackoffResetFrequency;
    }

    public Duration getGrpcReconnectFrequency() {
        return this.grpcReconnectFrequency;
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public Optional<Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub>> getBlockingStubInterceptor() {
        return Optional.ofNullable(this.blockingStubInterceptor);
    }

    public Optional<Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub>> getFutureStubInterceptor() {
        return Optional.ofNullable(this.futureStubInterceptor);
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    static /* synthetic */ Duration access$2300() {
        return DEFAULT_RPC_TIMEOUT;
    }

    static /* synthetic */ Duration access$2400() {
        return DEFAULT_POLL_RPC_TIMEOUT;
    }

    static /* synthetic */ Duration access$2500() {
        return DEFAULT_QUERY_RPC_TIMEOUT;
    }

    static /* synthetic */ Duration access$2600() {
        return DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY;
    }

    static /* synthetic */ Duration access$2700() {
        return DEFAULT_GRPC_RECONNECT_FREQUENCY;
    }

    public static class Builder {
        private ManagedChannel channel;
        private SslContext sslContext;
        private boolean enableHttps;
        private String target;
        private boolean disableHealthCheck;
        private Duration healthCheckAttemptTimeout;
        private Duration healthCheckTimeout;
        private boolean enableKeepAlive;
        private Duration keepAliveTime;
        private Duration keepAliveTimeout;
        private boolean keepAlivePermitWithoutStream;
        private Duration rpcTimeout = WorkflowServiceStubsOptions.access$2300();
        private Duration rpcLongPollTimeout = WorkflowServiceStubsOptions.access$2400();
        private Duration rpcQueryTimeout = WorkflowServiceStubsOptions.access$2500();
        private RpcRetryOptions rpcRetryOptions = RpcRetryOptions.DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS;
        private Duration connectionBackoffResetFrequency = WorkflowServiceStubsOptions.access$2600();
        private Duration grpcReconnectFrequency = WorkflowServiceStubsOptions.access$2700();
        private Metadata headers;
        private Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub> blockingStubInterceptor;
        private Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> futureStubInterceptor;
        private Scope metricsScope;

        private Builder() {
        }

        private Builder(WorkflowServiceStubsOptions options) {
            this.target = options.target;
            this.channel = options.channel;
            this.enableHttps = options.enableHttps;
            this.sslContext = options.sslContext;
            this.rpcLongPollTimeout = options.rpcLongPollTimeout;
            this.rpcQueryTimeout = options.rpcQueryTimeout;
            this.rpcTimeout = options.rpcTimeout;
            this.rpcRetryOptions = options.rpcRetryOptions;
            this.connectionBackoffResetFrequency = options.connectionBackoffResetFrequency;
            this.grpcReconnectFrequency = options.grpcReconnectFrequency;
            this.blockingStubInterceptor = options.blockingStubInterceptor;
            this.futureStubInterceptor = options.futureStubInterceptor;
            this.headers = options.headers;
            this.metricsScope = options.metricsScope;
            this.disableHealthCheck = options.disableHealthCheck;
            this.healthCheckAttemptTimeout = options.healthCheckAttemptTimeout;
            this.healthCheckTimeout = options.healthCheckTimeout;
            this.enableKeepAlive = options.enableKeepAlive;
            this.keepAliveTime = options.keepAliveTime;
            this.keepAliveTimeout = options.keepAliveTimeout;
            this.keepAlivePermitWithoutStream = options.keepAlivePermitWithoutStream;
        }

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setEnableHttps(boolean enableHttps) {
            this.enableHttps = enableHttps;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setRpcTimeout(Duration timeout) {
            this.rpcTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setRpcLongPollTimeout(Duration timeout) {
            this.rpcLongPollTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setRpcQueryTimeout(Duration rpcQueryTimeout) {
            this.rpcQueryTimeout = rpcQueryTimeout;
            return this;
        }

        public Builder setRpcRetryOptions(RpcRetryOptions rpcRetryOptions) {
            this.rpcRetryOptions = rpcRetryOptions;
            return this;
        }

        public Builder setConnectionBackoffResetFrequency(Duration connectionBackoffResetFrequency) {
            this.connectionBackoffResetFrequency = connectionBackoffResetFrequency;
            return this;
        }

        public Builder setGrpcReconnectFrequency(Duration grpcReconnectFrequency) {
            this.grpcReconnectFrequency = grpcReconnectFrequency;
            return this;
        }

        public Builder setQueryRpcTimeout(Duration timeout) {
            this.rpcQueryTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setHeaders(Metadata headers) {
            this.headers = headers;
            return this;
        }

        public Builder setBlockingStubInterceptor(Function<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceBlockingStub> blockingStubInterceptor) {
            this.blockingStubInterceptor = blockingStubInterceptor;
            return this;
        }

        public Builder setFutureStubInterceptor(Function<WorkflowServiceGrpc.WorkflowServiceFutureStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> futureStubInterceptor) {
            this.futureStubInterceptor = futureStubInterceptor;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setDisableHealthCheck(boolean disableHealthCheck) {
            this.disableHealthCheck = disableHealthCheck;
            return this;
        }

        public Builder setHealthCheckAttemptTimeout(Duration healthCheckAttemptTimeout) {
            this.healthCheckAttemptTimeout = healthCheckAttemptTimeout;
            return this;
        }

        public Builder setHealthCheckTimeout(Duration healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public Builder setEnableKeepAlive(boolean enableKeepAlive) {
            this.enableKeepAlive = enableKeepAlive;
            return this;
        }

        public Builder setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public Builder setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
            return this;
        }

        public Builder setKeepAlivePermitWithoutStream(boolean keepAlivePermitWithoutStream) {
            this.keepAlivePermitWithoutStream = keepAlivePermitWithoutStream;
            return this;
        }

        public WorkflowServiceStubsOptions build() {
            return new WorkflowServiceStubsOptions(this);
        }

        public WorkflowServiceStubsOptions validateAndBuildWithDefaults() {
            return new WorkflowServiceStubsOptions(this, true);
        }
    }
}

