/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.AsyncBackoffThrottler;
import io.temporal.internal.retryer.GrpcRetryerUtils;
import io.temporal.serviceclient.RpcRetryOptions;
import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcAsyncRetryer {
    private static final Logger log = LoggerFactory.getLogger(GrpcAsyncRetryer.class);
    private final Clock clock;

    public GrpcAsyncRetryer(Clock clock) {
        this.clock = clock;
    }

    public <R> CompletableFuture<R> retry(RpcRetryOptions options, Supplier<CompletableFuture<R>> function) {
        long startTime = this.clock.millis();
        AsyncBackoffThrottler throttler = new AsyncBackoffThrottler(options.getInitialInterval(), options.getMaximumInterval(), options.getBackoffCoefficient());
        options.validate();
        CompletableFuture resultCF = new CompletableFuture();
        this.retry(options, function, 1, startTime, throttler, null, resultCF);
        return resultCF;
    }

    private <R> void retry(RpcRetryOptions options, Supplier<CompletableFuture<R>> function, int attempt, long startTime, AsyncBackoffThrottler throttler, StatusRuntimeException previousException, CompletableFuture<R> resultCF) {
        throttler.throttle().thenAccept(ignore -> {
            CompletableFuture result;
            try {
                result = (CompletableFuture)function.get();
            }
            catch (Throwable e) {
                throttler.failure();
                this.failOrRetry(options, function, attempt, startTime, throttler, previousException, e, resultCF);
                return;
            }
            if (result == null) {
                resultCF.complete(null);
                return;
            }
            result.whenComplete((arg_0, arg_1) -> this.lambda$retry$0(throttler, resultCF, options, (Supplier)function, attempt, startTime, previousException, arg_0, arg_1));
        });
    }

    private <R> void failOrRetry(RpcRetryOptions options, Supplier<CompletableFuture<R>> function, int attempt, long startTime, AsyncBackoffThrottler throttler, StatusRuntimeException previousException, Throwable currentException, CompletableFuture<R> resultCF) {
        if (!((currentException = GrpcAsyncRetryer.unwrapCompletionException(currentException)) instanceof StatusRuntimeException)) {
            resultCF.completeExceptionally(currentException);
            return;
        }
        StatusRuntimeException statusRuntimeException = (StatusRuntimeException)currentException;
        Deadline grpcContextDeadline = Context.current().getDeadline();
        RuntimeException finalException = GrpcRetryerUtils.createFinalExceptionIfNotRetryable(statusRuntimeException, previousException, options, grpcContextDeadline);
        if (finalException != null) {
            log.warn("Non retryable failure", (Throwable)finalException);
            resultCF.completeExceptionally(finalException);
            return;
        }
        StatusRuntimeException lastMeaningfulException = GrpcRetryerUtils.lastMeaningfulException(statusRuntimeException, previousException);
        if (GrpcRetryerUtils.ranOutOfRetries(options, startTime, this.clock.millis(), attempt, grpcContextDeadline)) {
            log.warn("Failure, out of retries", (Throwable)lastMeaningfulException);
            resultCF.completeExceptionally(lastMeaningfulException);
        } else {
            log.info("Retrying after failure", currentException);
            this.retry(options, function, attempt + 1, startTime, throttler, lastMeaningfulException, resultCF);
        }
    }

    private static Throwable unwrapCompletionException(Throwable e) {
        return e instanceof CompletionException ? e.getCause() : e;
    }

    private /* synthetic */ void lambda$retry$0(AsyncBackoffThrottler throttler, CompletableFuture resultCF, RpcRetryOptions options, Supplier function, int attempt, long startTime, StatusRuntimeException previousException, Object r, Throwable e) {
        if (e == null) {
            throttler.success();
            resultCF.complete(r);
        } else {
            throttler.failure();
            this.failOrRetry(options, function, attempt, startTime, throttler, previousException, e, resultCF);
        }
    }
}

