/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.temporal.internal.retryer.GrpcAsyncRetryer;
import io.temporal.internal.retryer.GrpcSyncRetryer;
import io.temporal.serviceclient.RpcRetryOptions;
import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public final class GrpcRetryer {
    private static final GrpcSyncRetryer SYNC = new GrpcSyncRetryer(Clock.systemUTC());
    private static final GrpcAsyncRetryer ASYNC = new GrpcAsyncRetryer(Clock.systemUTC());

    public static <T extends Throwable> void retry(RpcRetryOptions options, RetryableProc<T> r) throws T {
        GrpcRetryer.retryWithResult(options, () -> {
            r.apply();
            return null;
        });
    }

    public static <R, T extends Throwable> R retryWithResult(RpcRetryOptions options, RetryableFunc<R, T> r) throws T {
        return SYNC.retry(options, r);
    }

    public static <R> CompletableFuture<R> retryWithResultAsync(RpcRetryOptions options, Supplier<CompletableFuture<R>> function) {
        return ASYNC.retry(options, function);
    }

    private GrpcRetryer() {
    }

    public static interface RetryableFunc<R, E extends Throwable> {
        public R apply() throws E;
    }

    public static interface RetryableProc<E extends Throwable> {
        public void apply() throws E;
    }
}

