/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.StatusUtils;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GrpcRetryerUtils {
    GrpcRetryerUtils() {
    }

    @Nullable
    static RuntimeException createFinalExceptionIfNotRetryable(@Nonnull StatusRuntimeException currentException, @Nullable StatusRuntimeException previousException, @Nonnull RpcRetryOptions options, @Nullable Deadline grpcContextDeadline) {
        Status.Code code = currentException.getStatus().getCode();
        switch (code) {
            case CANCELLED: {
                return new CancellationException("The gRPC request was cancelled");
            }
            case DEADLINE_EXCEEDED: {
                if (grpcContextDeadline == null || !grpcContextDeadline.isExpired()) break;
                return GrpcRetryerUtils.lastMeaningfulException(currentException, previousException);
            }
            default: {
                for (RpcRetryOptions.DoNotRetryItem pair : options.getDoNotRetry()) {
                    if (pair.getCode() != code || pair.getDetailsClass() != null && !StatusUtils.hasFailure(currentException, pair.getDetailsClass())) continue;
                    return currentException;
                }
            }
        }
        return null;
    }

    static StatusRuntimeException lastMeaningfulException(@Nonnull StatusRuntimeException currentException, @Nullable StatusRuntimeException previousException) {
        if (currentException.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
            if (previousException != null && previousException.getStatus().getCode() != Status.Code.DEADLINE_EXCEEDED) {
                return previousException;
            }
            return currentException;
        }
        return currentException;
    }

    static boolean ranOutOfRetries(RpcRetryOptions options, long startTimeMs, long currentTimeMillis, int attempt, @Nullable Deadline grpcContextDeadline) {
        int maxAttempts = options.getMaximumAttempts();
        Duration expirationDuration = options.getExpiration();
        long expirationInterval = expirationDuration != null ? expirationDuration.toMillis() : 0L;
        return maxAttempts > 0 && attempt >= maxAttempts || expirationDuration != null && currentTimeMillis - startTimeMs >= expirationInterval || grpcContextDeadline != null && grpcContextDeadline.isExpired();
    }
}

