/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.ManagedChannel;
import io.grpc.health.v1.HealthCheckResponse;
import io.temporal.api.operatorservice.v1.OperatorServiceGrpc;
import io.temporal.serviceclient.ChannelManager;
import io.temporal.serviceclient.GrpcDeadlineInterceptor;
import io.temporal.serviceclient.OperatorServiceStubs;
import io.temporal.serviceclient.OperatorServiceStubsOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OperatorServiceStubsImpl
implements OperatorServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(OperatorServiceStubsImpl.class);
    private final ChannelManager channelManager;
    private final OperatorServiceGrpc.OperatorServiceBlockingStub blockingStub;
    private final OperatorServiceGrpc.OperatorServiceFutureStub futureStub;

    OperatorServiceStubsImpl(OperatorServiceStubsOptions options) {
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options.getRpcTimeout(), null, null);
        this.channelManager = new ChannelManager(options, Collections.singletonList(deadlineInterceptor));
        log.info("Created OperatorServiceStubs for channel: {}", (Object)this.channelManager.getRawChannel());
        this.blockingStub = OperatorServiceGrpc.newBlockingStub(this.channelManager.getInterceptedChannel());
        this.futureStub = OperatorServiceGrpc.newFutureStub(this.channelManager.getInterceptedChannel());
    }

    @Override
    public ManagedChannel getRawChannel() {
        return this.channelManager.getRawChannel();
    }

    @Override
    public OperatorServiceGrpc.OperatorServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    public OperatorServiceGrpc.OperatorServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    public void shutdown() {
        log.info("shutdown");
        this.channelManager.shutdown();
    }

    @Override
    public void shutdownNow() {
        log.info("shutdownNow");
        this.channelManager.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.channelManager.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.channelManager.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return this.channelManager.awaitTermination(timeout, unit);
    }

    @Override
    public void connect(@Nullable Duration timeout) {
        this.channelManager.connect("temporal.api.operatorservice.v1.OperatorService", timeout);
    }

    @Override
    public HealthCheckResponse healthCheck() {
        return this.channelManager.healthCheck("temporal.api.operatorservice.v1.OperatorService", null);
    }
}

