/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.serviceclient.rpcretry.DefaultStubServiceOperationRpcRetryOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RpcRetryOptions {
    private static final RpcRetryOptions DEFAULT_INSTANCE = RpcRetryOptions.newBuilder().build();
    private final Duration initialInterval;
    private final double backoffCoefficient;
    private final Duration expiration;
    private final int maximumAttempts;
    private final Duration maximumInterval;
    private final List<DoNotRetryItem> doNotRetry;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(RpcRetryOptions options) {
        return new Builder(options);
    }

    public static RpcRetryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private RpcRetryOptions(Duration initialInterval, double backoffCoefficient, Duration expiration, int maximumAttempts, Duration maximumInterval, List<DoNotRetryItem> doNotRetry) {
        this.initialInterval = initialInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.expiration = expiration;
        this.maximumAttempts = maximumAttempts;
        this.maximumInterval = maximumInterval;
        this.doNotRetry = doNotRetry != null ? Collections.unmodifiableList(doNotRetry) : null;
    }

    public Duration getInitialInterval() {
        return this.initialInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Duration getMaximumInterval() {
        return this.maximumInterval;
    }

    public void validate() {
        if (this.initialInterval == null) {
            throw new IllegalStateException("required property initialInterval not set");
        }
        if (this.expiration == null && this.maximumAttempts <= 0) {
            throw new IllegalArgumentException("both MaximumAttempts and Expiration on retry policy are not set, at least one of them must be set");
        }
        if (this.maximumInterval != null && this.maximumInterval.compareTo(this.initialInterval) < 0) {
            throw new IllegalStateException("maximumInterval(" + this.maximumInterval + ") cannot be smaller than initialInterval(" + this.initialInterval);
        }
        if (this.backoffCoefficient != 0.0 && this.backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("coefficient less than 1");
        }
        if (this.maximumAttempts != 0 && this.maximumAttempts < 0) {
            throw new IllegalArgumentException("negative maximum attempts");
        }
    }

    public List<DoNotRetryItem> getDoNotRetry() {
        return this.doNotRetry;
    }

    public String toString() {
        return "RetryOptions{initialInterval=" + this.initialInterval + ", backoffCoefficient=" + this.backoffCoefficient + ", expiration=" + this.expiration + ", maximumAttempts=" + this.maximumAttempts + ", maximumInterval=" + this.maximumInterval + ", doNotRetry=" + this.doNotRetry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcRetryOptions that = (RpcRetryOptions)o;
        return Double.compare(that.backoffCoefficient, this.backoffCoefficient) == 0 && this.maximumAttempts == that.maximumAttempts && Objects.equals(this.initialInterval, that.initialInterval) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.maximumInterval, that.maximumInterval) && Objects.equals(this.doNotRetry, that.doNotRetry);
    }

    public int hashCode() {
        return Objects.hash(this.initialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
    }

    public static final class Builder {
        private Duration initialInterval;
        private Duration expiration;
        private double backoffCoefficient;
        private int maximumAttempts;
        private Duration maximumInterval;
        private List<DoNotRetryItem> doNotRetry = new ArrayList<DoNotRetryItem>();

        private Builder() {
        }

        private Builder(RpcRetryOptions options) {
            if (options == null) {
                return;
            }
            this.backoffCoefficient = options.getBackoffCoefficient();
            this.maximumAttempts = options.getMaximumAttempts();
            this.expiration = options.getExpiration();
            this.initialInterval = options.getInitialInterval();
            this.maximumInterval = options.getMaximumInterval();
            this.doNotRetry = options.getDoNotRetry();
        }

        public Builder setInitialInterval(Duration initialInterval) {
            Objects.requireNonNull(initialInterval);
            if (initialInterval.isNegative() || initialInterval.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + initialInterval);
            }
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder setExpiration(Duration expiration) {
            Objects.requireNonNull(expiration);
            if (expiration.isNegative() || expiration.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + expiration);
            }
            this.expiration = expiration;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (backoffCoefficient < 1.0) {
                throw new IllegalArgumentException("coefficient less than 1.0: " + backoffCoefficient);
            }
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setMaximumAttempts(int maximumAttempts) {
            if (maximumAttempts < 0) {
                throw new IllegalArgumentException("Invalid maximumAttempts: " + maximumAttempts);
            }
            this.maximumAttempts = maximumAttempts;
            return this;
        }

        public Builder setMaximumInterval(Duration maximumInterval) {
            if (maximumInterval != null && (maximumInterval.isNegative() || maximumInterval.isZero())) {
                throw new IllegalArgumentException("Invalid interval: " + maximumInterval);
            }
            this.maximumInterval = maximumInterval;
            return this;
        }

        public Builder addDoNotRetry(Status.Code code, Class<? extends GeneratedMessageV3> detailsClass) {
            this.doNotRetry.add(new DoNotRetryItem(code, detailsClass));
            return this;
        }

        public Builder addDoNotRetry(DoNotRetryItem doNotRetryItem) {
            this.doNotRetry.add(doNotRetryItem);
            return this;
        }

        Builder setDoNotRetry(List<DoNotRetryItem> pairs) {
            this.doNotRetry = pairs;
            return this;
        }

        public Builder setRetryOptions(RpcRetryOptions o) {
            if (o == null) {
                return this;
            }
            this.setInitialInterval(OptionsUtils.merge(this.initialInterval, o.getInitialInterval(), Duration.class));
            this.setExpiration(OptionsUtils.merge(this.expiration, o.getExpiration(), Duration.class));
            this.setMaximumInterval(OptionsUtils.merge(this.maximumInterval, o.getMaximumInterval(), Duration.class));
            this.setBackoffCoefficient(OptionsUtils.merge(this.backoffCoefficient, o.getBackoffCoefficient(), Double.TYPE));
            this.setMaximumAttempts(OptionsUtils.merge(this.maximumAttempts, o.getMaximumAttempts(), Integer.TYPE));
            this.setDoNotRetry(this.merge(this.doNotRetry, o.getDoNotRetry()));
            this.validateBuildWithDefaults();
            return this;
        }

        private List<DoNotRetryItem> merge(List<DoNotRetryItem> o1, List<DoNotRetryItem> o2) {
            if (o2 != null) {
                return new ArrayList<DoNotRetryItem>(o2);
            }
            if (o1.size() > 0) {
                return new ArrayList<DoNotRetryItem>(o1);
            }
            return null;
        }

        public RpcRetryOptions build() {
            return new RpcRetryOptions(this.initialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
        }

        public RpcRetryOptions buildWithDefaultsFrom(RpcRetryOptions rpcRetryOptions) {
            return RpcRetryOptions.newBuilder().setRetryOptions(rpcRetryOptions).validateBuildWithDefaults();
        }

        public RpcRetryOptions validateBuildWithDefaults() {
            double backoff = this.backoffCoefficient;
            if (backoff == 0.0) {
                backoff = 2.0;
            }
            if (this.initialInterval == null || this.initialInterval.isZero() || this.initialInterval.isNegative()) {
                this.initialInterval = DefaultStubServiceOperationRpcRetryOptions.INITIAL_INTERVAL;
            }
            if (this.expiration == null || this.expiration.isZero() || this.expiration.isNegative()) {
                this.expiration = DefaultStubServiceOperationRpcRetryOptions.EXPIRATION_INTERVAL;
            }
            if (this.maximumInterval == null || this.maximumInterval.isZero() || this.maximumInterval.isNegative()) {
                this.maximumInterval = DefaultStubServiceOperationRpcRetryOptions.MAXIMUM_INTERVAL;
            }
            if (this.doNotRetry == null || this.doNotRetry.size() == 0) {
                this.doNotRetry = DefaultStubServiceOperationRpcRetryOptions.INSTANCE.doNotRetry;
            }
            RpcRetryOptions result = new RpcRetryOptions(this.initialInterval, backoff, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
            result.validate();
            return result;
        }
    }

    public static class DoNotRetryItem {
        private final Status.Code code;
        private final Class<? extends GeneratedMessageV3> detailsClass;

        public DoNotRetryItem(@Nonnull Status.Code code, @Nullable Class<? extends GeneratedMessageV3> detailsClass) {
            if (code == null) {
                throw new NullPointerException("code");
            }
            this.code = code;
            this.detailsClass = detailsClass;
        }

        public Status.Code getCode() {
            return this.code;
        }

        public Class<? extends GeneratedMessageV3> getDetailsClass() {
            return this.detailsClass;
        }
    }
}

