/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Preconditions;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.ServiceStubsOptions;
import io.temporal.serviceclient.rpcretry.DefaultStubServiceOperationRpcRetryOptions;
import java.time.Duration;
import java.util.Objects;

public final class WorkflowServiceStubsOptions
extends ServiceStubsOptions {
    public static final Duration DEFAULT_SERVER_LONG_POLL_RPC_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_POLL_RPC_TIMEOUT = DEFAULT_SERVER_LONG_POLL_RPC_TIMEOUT.plus(Duration.ofSeconds(10L));
    public static final Duration DEFAULT_QUERY_RPC_TIMEOUT = Duration.ofSeconds(10L);
    private static final WorkflowServiceStubsOptions DEFAULT_INSTANCE = WorkflowServiceStubsOptions.newBuilder().validateAndBuildWithDefaults();
    private final boolean disableHealthCheck;
    private final Duration rpcLongPollTimeout;
    private final Duration rpcQueryTimeout;
    private final RpcRetryOptions rpcRetryOptions;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ServiceStubsOptions options) {
        return new Builder(options);
    }

    public static WorkflowServiceStubsOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkflowServiceStubsOptions(ServiceStubsOptions serviceStubsOptions, boolean disableHealthCheck, Duration rpcLongPollTimeout, Duration rpcQueryTimeout, RpcRetryOptions rpcRetryOptions) {
        super(serviceStubsOptions);
        this.disableHealthCheck = disableHealthCheck;
        this.rpcLongPollTimeout = rpcLongPollTimeout;
        this.rpcQueryTimeout = rpcQueryTimeout;
        this.rpcRetryOptions = rpcRetryOptions;
    }

    @Deprecated
    public boolean getDisableHealthCheck() {
        return this.disableHealthCheck;
    }

    public Duration getRpcLongPollTimeout() {
        return this.rpcLongPollTimeout;
    }

    public Duration getRpcQueryTimeout() {
        return this.rpcQueryTimeout;
    }

    public RpcRetryOptions getRpcRetryOptions() {
        return this.rpcRetryOptions;
    }

    public static class Builder
    extends ServiceStubsOptions.Builder<Builder> {
        private boolean disableHealthCheck = true;
        private Duration rpcLongPollTimeout = DEFAULT_POLL_RPC_TIMEOUT;
        private Duration rpcQueryTimeout = DEFAULT_QUERY_RPC_TIMEOUT;
        private RpcRetryOptions rpcRetryOptions = DefaultStubServiceOperationRpcRetryOptions.INSTANCE;

        private Builder() {
        }

        private Builder(ServiceStubsOptions options) {
            super(options);
            if (options instanceof WorkflowServiceStubsOptions) {
                WorkflowServiceStubsOptions castedOptions = (WorkflowServiceStubsOptions)options;
                this.rpcLongPollTimeout = castedOptions.rpcLongPollTimeout;
                this.rpcQueryTimeout = castedOptions.rpcQueryTimeout;
                this.rpcRetryOptions = castedOptions.rpcRetryOptions;
            }
        }

        @Deprecated
        public Builder setDisableHealthCheck(boolean disableHealthCheck) {
            this.disableHealthCheck = disableHealthCheck;
            return this;
        }

        @Override
        public Builder setRpcTimeout(Duration timeout) {
            return (Builder)super.setRpcTimeout(timeout);
        }

        @Deprecated
        public Builder setRpcLongPollTimeout(Duration timeout) {
            Preconditions.checkArgument((timeout.toMillis() > 70000L ? 1 : 0) != 0, (Object)"rpcLongPollTimeout has to be longer 70s");
            this.rpcLongPollTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setRpcQueryTimeout(Duration rpcQueryTimeout) {
            this.rpcQueryTimeout = rpcQueryTimeout;
            return this;
        }

        public Builder setRpcRetryOptions(RpcRetryOptions rpcRetryOptions) {
            this.rpcRetryOptions = rpcRetryOptions;
            return this;
        }

        public Builder setQueryRpcTimeout(Duration timeout) {
            this.rpcQueryTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        @Override
        public WorkflowServiceStubsOptions build() {
            return new WorkflowServiceStubsOptions(super.build(), this.disableHealthCheck, this.rpcLongPollTimeout, this.rpcQueryTimeout, this.rpcRetryOptions);
        }

        @Override
        public WorkflowServiceStubsOptions validateAndBuildWithDefaults() {
            ServiceStubsOptions serviceStubsOptions = super.validateAndBuildWithDefaults();
            return new WorkflowServiceStubsOptions(serviceStubsOptions, this.disableHealthCheck, this.rpcLongPollTimeout, this.rpcQueryTimeout, this.rpcRetryOptions);
        }
    }
}

