/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.AsyncBackoffThrottler;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.retryer.GrpcRetryerUtils;
import io.temporal.serviceclient.RpcRetryOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcAsyncRetryer {
    private static final Logger log = LoggerFactory.getLogger(GrpcRetryer.class);

    GrpcAsyncRetryer() {
    }

    public <R> CompletableFuture<R> retry(Supplier<CompletableFuture<R>> function, GrpcRetryer.GrpcRetryerOptions options) {
        options.validate();
        RpcRetryOptions rpcOptions = options.getOptions();
        Deadline deadline = options.getDeadline();
        Deadline retriesExpirationDeadline = GrpcRetryerUtils.mergeDurationWithAnAbsoluteDeadline(rpcOptions.getExpiration(), deadline);
        AsyncBackoffThrottler throttler = new AsyncBackoffThrottler(rpcOptions.getInitialInterval(), rpcOptions.getMaximumInterval(), rpcOptions.getBackoffCoefficient());
        int attempt = 1;
        CompletableFuture resultCF = new CompletableFuture();
        this.retry(rpcOptions, function, attempt, retriesExpirationDeadline, throttler, null, resultCF);
        return resultCF;
    }

    private <R> void retry(RpcRetryOptions options, Supplier<CompletableFuture<R>> function, int attempt, @Nullable Deadline retriesExpirationDeadline, AsyncBackoffThrottler throttler, StatusRuntimeException previousException, CompletableFuture<R> resultCF) {
        throttler.throttle().thenAccept(ignore -> {
            CompletableFuture result;
            if (previousException != null) {
                log.debug("Retrying after failure", (Throwable)previousException);
            }
            try {
                result = (CompletableFuture)function.get();
            }
            catch (Throwable e) {
                throttler.failure();
                this.failOrRetry(options, function, attempt, retriesExpirationDeadline, throttler, previousException, e, resultCF);
                return;
            }
            if (result == null) {
                resultCF.complete(null);
                return;
            }
            result.whenComplete((arg_0, arg_1) -> this.lambda$retry$0(throttler, resultCF, options, (Supplier)function, attempt, retriesExpirationDeadline, previousException, arg_0, arg_1));
        });
    }

    private <R> void failOrRetry(RpcRetryOptions options, Supplier<CompletableFuture<R>> function, int attempt, @Nullable Deadline retriesExpirationDeadline, AsyncBackoffThrottler throttler, StatusRuntimeException previousException, Throwable currentException, CompletableFuture<R> resultCF) {
        if (!((currentException = GrpcAsyncRetryer.unwrapCompletionException(currentException)) instanceof StatusRuntimeException)) {
            resultCF.completeExceptionally(currentException);
            return;
        }
        StatusRuntimeException statusRuntimeException = (StatusRuntimeException)currentException;
        RuntimeException finalException = GrpcRetryerUtils.createFinalExceptionIfNotRetryable(statusRuntimeException, options);
        if (finalException != null) {
            log.debug("Final exception, throwing", (Throwable)finalException);
            resultCF.completeExceptionally(finalException);
            return;
        }
        StatusRuntimeException lastMeaningfulException = GrpcRetryerUtils.lastMeaningfulException(statusRuntimeException, previousException);
        if (GrpcRetryerUtils.ranOutOfRetries(options, attempt, retriesExpirationDeadline, Context.current().getDeadline())) {
            log.debug("Out of retries, throwing", (Throwable)lastMeaningfulException);
            resultCF.completeExceptionally((Throwable)lastMeaningfulException);
        } else {
            this.retry(options, function, attempt + 1, retriesExpirationDeadline, throttler, lastMeaningfulException, resultCF);
        }
    }

    private static Throwable unwrapCompletionException(Throwable e) {
        return e instanceof CompletionException ? e.getCause() : e;
    }

    private /* synthetic */ void lambda$retry$0(AsyncBackoffThrottler throttler, CompletableFuture resultCF, RpcRetryOptions options, Supplier function, int attempt, Deadline retriesExpirationDeadline, StatusRuntimeException previousException, Object r, Throwable e) {
        if (e == null) {
            throttler.success();
            resultCF.complete(r);
        } else {
            throttler.failure();
            this.failOrRetry(options, function, attempt, retriesExpirationDeadline, throttler, previousException, e, resultCF);
        }
    }
}

