/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ConnectivityState;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.serviceclient.GrpcMetadataProvider;
import io.temporal.serviceclient.GrpcMetadataProviderInterceptor;
import io.temporal.serviceclient.GrpcMetricsInterceptor;
import io.temporal.serviceclient.GrpcTracingInterceptor;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.ServiceStubsOptions;
import io.temporal.serviceclient.Version;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChannelManager {
    private static final Logger log = LoggerFactory.getLogger(ChannelManager.class);
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x8000000;
    private static final Metadata.Key<String> LIBRARY_VERSION_HEADER_KEY = Metadata.Key.of((String)"client-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SUPPORTED_SERVER_VERSIONS_HEADER_KEY = Metadata.Key.of((String)"supported-server-versions", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CLIENT_NAME_HEADER_KEY = Metadata.Key.of((String)"client-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String CLIENT_NAME_HEADER_VALUE = "temporal-java";
    private final ServiceStubsOptions options;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final boolean channelNeedsShutdown;
    private final ScheduledExecutorService grpcConnectionManager;
    private final ManagedChannel rawChannel;
    private final Channel interceptedChannel;
    private final HealthGrpc.HealthBlockingStub healthBlockingStub;

    public ChannelManager(ServiceStubsOptions options, List<ClientInterceptor> additionalHeadInterceptors) {
        this.channelNeedsShutdown = options.getChannel() == null;
        this.options = options;
        if (options.getChannel() != null) {
            this.rawChannel = options.getChannel();
            this.grpcConnectionManager = null;
        } else {
            this.rawChannel = this.prepareChannel();
            this.grpcConnectionManager = this.grpcConnectionManager();
            this.initConnectionManagement();
        }
        ManagedChannel interceptedChannel = this.rawChannel;
        interceptedChannel = this.applyTailStandardInterceptors((Channel)interceptedChannel);
        interceptedChannel = this.applyCustomInterceptors((Channel)interceptedChannel);
        interceptedChannel = this.applyHeadStandardInterceptors((Channel)interceptedChannel);
        interceptedChannel = ClientInterceptors.intercept((Channel)interceptedChannel, additionalHeadInterceptors);
        this.interceptedChannel = interceptedChannel;
        this.healthBlockingStub = HealthGrpc.newBlockingStub((Channel)interceptedChannel);
    }

    public ManagedChannel getRawChannel() {
        return this.rawChannel;
    }

    public Channel getInterceptedChannel() {
        return this.interceptedChannel;
    }

    private Channel applyTailStandardInterceptors(Channel channel) {
        GrpcMetricsInterceptor metricsInterceptor = new GrpcMetricsInterceptor(this.options.getMetricsScope());
        channel = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{metricsInterceptor});
        if (GrpcTracingInterceptor.isEnabled()) {
            GrpcTracingInterceptor tracingInterceptor = new GrpcTracingInterceptor();
            channel = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{tracingInterceptor});
        }
        return channel;
    }

    private Channel applyHeadStandardInterceptors(Channel channel) {
        Metadata headers = new Metadata();
        headers.merge(this.options.getHeaders());
        headers.put(LIBRARY_VERSION_HEADER_KEY, (Object)Version.LIBRARY_VERSION);
        headers.put(SUPPORTED_SERVER_VERSIONS_HEADER_KEY, (Object)">=0.31.0 <2.0.0");
        headers.put(CLIENT_NAME_HEADER_KEY, (Object)CLIENT_NAME_HEADER_VALUE);
        return ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)});
    }

    private Channel applyCustomInterceptors(Channel channel) {
        Collection<GrpcMetadataProvider> grpcMetadataProviders;
        Collection<ClientInterceptor> grpcClientInterceptors = this.options.getGrpcClientInterceptors();
        if (grpcClientInterceptors != null) {
            for (ClientInterceptor interceptor : grpcClientInterceptors) {
                channel = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
            }
        }
        if ((grpcMetadataProviders = this.options.getGrpcMetadataProviders()) != null && !grpcMetadataProviders.isEmpty()) {
            GrpcMetadataProviderInterceptor grpcMetadataProviderInterceptor = new GrpcMetadataProviderInterceptor(grpcMetadataProviders);
            channel = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{grpcMetadataProviderInterceptor});
        }
        return channel;
    }

    private ManagedChannel prepareChannel() {
        NettyChannelBuilder builder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)this.options.getTarget()).defaultLoadBalancingPolicy("round_robin")).maxInboundMessageSize(0x8000000);
        if (this.options.getEnableKeepAlive()) {
            builder.keepAliveTime(this.options.getKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.options.getKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(this.options.getKeepAlivePermitWithoutStream());
        }
        if (this.options.getSslContext() == null && !this.options.getEnableHttps()) {
            builder.usePlaintext();
        } else if (this.options.getSslContext() != null) {
            builder.sslContext(this.options.getSslContext());
        } else {
            builder.useTransportSecurity();
        }
        builder.idleTimeout(31L, TimeUnit.DAYS);
        if (this.options.getChannelInitializer() != null) {
            this.options.getChannelInitializer().accept((ManagedChannelBuilder<?>)builder);
        }
        return builder.build();
    }

    private void initConnectionManagement() {
        if (this.options.getConnectionBackoffResetFrequency() != null) {
            this.grpcConnectionManager.scheduleWithFixedDelay(this.resetGrpcConnectionBackoffTask(), this.options.getConnectionBackoffResetFrequency().toMillis(), this.options.getConnectionBackoffResetFrequency().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.options.getGrpcReconnectFrequency() != null) {
            this.grpcConnectionManager.scheduleWithFixedDelay(this.enterGrpcIdleChannelStateTask(), this.options.getGrpcReconnectFrequency().toMillis(), this.options.getGrpcReconnectFrequency().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private Runnable enterGrpcIdleChannelStateTask() {
        return () -> {
            try {
                log.debug("Entering IDLE state on the gRPC channel {}", (Object)this.rawChannel);
                this.rawChannel.enterIdle();
            }
            catch (Exception e) {
                log.warn("Unable to enter IDLE state on the gRPC channel.", (Throwable)e);
            }
        };
    }

    private Runnable resetGrpcConnectionBackoffTask() {
        return () -> {
            try {
                log.debug("Resetting gRPC connection backoff on the gRPC channel {}", (Object)this.rawChannel);
                this.rawChannel.resetConnectBackoff();
            }
            catch (Exception e) {
                log.warn("Unable to reset gRPC connection backoff.", (Throwable)e);
            }
        };
    }

    private ScheduledExecutorService grpcConnectionManager() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("grpc-connection-manager-thread-%d").build());
    }

    public void connect(String healthCheckServiceName, @Nullable Duration timeout) {
        ConnectivityState currentState = this.rawChannel.getState(false);
        if (ConnectivityState.READY.equals((Object)currentState)) {
            return;
        }
        if (ConnectivityState.SHUTDOWN.equals((Object)currentState)) {
            throw new IllegalStateException("Can't connect stubs in SHUTDOWN state");
        }
        if (timeout == null) {
            timeout = this.options.getRpcTimeout();
        }
        RpcRetryOptions retryOptions = RpcRetryOptions.newBuilder().setExpiration(timeout).validateBuildWithDefaults();
        GrpcRetryer.retryWithResult(() -> this.healthCheck(healthCheckServiceName, null), retryOptions);
    }

    public HealthCheckResponse healthCheck(String healthCheckServiceName, @Nullable Duration timeout) {
        HealthGrpc.HealthBlockingStub stub = timeout != null ? (HealthGrpc.HealthBlockingStub)this.healthBlockingStub.withDeadline(Deadline.after((long)this.options.getHealthCheckAttemptTimeout().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS)) : this.healthBlockingStub;
        return stub.check(HealthCheckRequest.newBuilder().setService(healthCheckServiceName).build());
    }

    public void shutdown() {
        this.shutdownRequested.set(true);
        if (this.grpcConnectionManager != null) {
            this.grpcConnectionManager.shutdown();
        }
        if (this.channelNeedsShutdown) {
            this.rawChannel.shutdown();
        }
    }

    public void shutdownNow() {
        this.shutdownRequested.set(true);
        if (this.grpcConnectionManager != null) {
            this.grpcConnectionManager.shutdownNow();
        }
        if (this.channelNeedsShutdown) {
            this.rawChannel.shutdownNow();
        }
    }

    public boolean isShutdown() {
        boolean result = this.channelNeedsShutdown ? this.rawChannel.isShutdown() : this.shutdownRequested.get();
        if (this.grpcConnectionManager != null) {
            result = result && this.grpcConnectionManager.isShutdown();
        }
        return result;
    }

    public boolean isTerminated() {
        boolean result = this.channelNeedsShutdown ? this.rawChannel.isTerminated() : this.shutdownRequested.get();
        if (this.grpcConnectionManager != null) {
            result = result && this.grpcConnectionManager.isTerminated();
        }
        return result;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        try {
            long start = System.currentTimeMillis();
            long left = unit.toMillis(timeout);
            long deadline = start + left;
            if (this.grpcConnectionManager != null && !this.grpcConnectionManager.awaitTermination(left, TimeUnit.MILLISECONDS)) {
                return false;
            }
            left = deadline - System.currentTimeMillis();
            if (this.channelNeedsShutdown) {
                return this.rawChannel.awaitTermination(left, unit);
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

