/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient.rpcretry;

import io.grpc.Status;
import io.temporal.serviceclient.RpcRetryOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class DefaultStubServiceOperationRpcRetryOptions {
    public static final Duration INITIAL_INTERVAL = Duration.ofMillis(50L);
    public static final Duration EXPIRATION_INTERVAL = Duration.ofMinutes(1L);
    public static final Duration MAXIMUM_INTERVAL;
    public static final double BACKOFF = 2.0;
    public static final List<RpcRetryOptions.DoNotRetryItem> TEMPORAL_SERVER_DEFAULT_NON_RETRY;
    public static final RpcRetryOptions INSTANCE;

    public static RpcRetryOptions.Builder getBuilder() {
        RpcRetryOptions.Builder roBuilder = RpcRetryOptions.newBuilder().setInitialInterval(INITIAL_INTERVAL).setExpiration(EXPIRATION_INTERVAL).setBackoffCoefficient(2.0).setMaximumInterval(MAXIMUM_INTERVAL);
        TEMPORAL_SERVER_DEFAULT_NON_RETRY.forEach(roBuilder::addDoNotRetry);
        return roBuilder;
    }

    static {
        TEMPORAL_SERVER_DEFAULT_NON_RETRY = new ArrayList<RpcRetryOptions.DoNotRetryItem>(){
            {
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.INVALID_ARGUMENT, null));
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.NOT_FOUND, null));
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.ALREADY_EXISTS, null));
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.FAILED_PRECONDITION, null));
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.PERMISSION_DENIED, null));
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.UNAUTHENTICATED, null));
                this.add(new RpcRetryOptions.DoNotRetryItem(Status.Code.UNIMPLEMENTED, null));
            }
        };
        Duration maxInterval = EXPIRATION_INTERVAL.dividedBy(10L);
        if (maxInterval.compareTo(INITIAL_INTERVAL) < 0) {
            maxInterval = INITIAL_INTERVAL;
        }
        MAXIMUM_INTERVAL = maxInterval;
        INSTANCE = DefaultStubServiceOperationRpcRetryOptions.getBuilder().validateBuildWithDefaults();
    }
}

