/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.Defaults;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.Objects;

public final class OptionsUtils {
    public static final Duration DEFAULT_TASK_START_TO_CLOSE_TIMEOUT = Duration.ofSeconds(10L);
    public static final float SECOND = 1000.0f;
    public static final byte[] EMPTY_BLOB = new byte[0];

    public static ByteString toByteString(byte[] value) {
        if (value == null) {
            return ByteString.EMPTY;
        }
        return ByteString.copyFrom((byte[])value);
    }

    public static byte[] safeGet(byte[] value) {
        if (value == null) {
            return EMPTY_BLOB;
        }
        return value;
    }

    public static String safeGet(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static <G> G merge(G value, G overrideValueIfNotDefault, Class<G> type) {
        Object defaultValue = Defaults.defaultValue(type);
        if (!Objects.equals(defaultValue, overrideValueIfNotDefault)) {
            return overrideValueIfNotDefault;
        }
        if (type.equals(String.class)) {
            return ((String)value).isEmpty() ? null : (G)value;
        }
        return value;
    }

    public static Duration merge(long aSeconds, Duration o) {
        if (o != null) {
            return o;
        }
        return aSeconds == 0L ? null : Duration.ofSeconds(aSeconds);
    }

    public static String[] merge(String[] fromAnnotation, String[] fromOptions) {
        if (fromOptions != null) {
            return fromOptions;
        }
        return fromAnnotation;
    }

    public static int roundUpToSeconds(Duration duration, Duration defaultValue) {
        if (duration == null) {
            return OptionsUtils.roundUpToSeconds(defaultValue);
        }
        return OptionsUtils.roundUpToSeconds(duration);
    }

    public static int roundUpToSeconds(Duration duration) {
        if (duration == null) {
            return 0;
        }
        return (int)Math.ceil((float)duration.toMillis() / 1000.0f);
    }

    private OptionsUtils() {
    }
}

