/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.StatusRuntimeException;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.internal.BackoffThrottler;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.retryer.GrpcRetryerUtils;
import io.temporal.serviceclient.RpcRetryOptions;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcSyncRetryer {
    private static final Logger log = LoggerFactory.getLogger(GrpcRetryer.class);

    GrpcSyncRetryer() {
    }

    public <R, T extends Throwable> R retry(GrpcRetryer.RetryableFunc<R, T> r, GrpcRetryer.GrpcRetryerOptions options, GetSystemInfoResponse.Capabilities serverCapabilities) throws T {
        options.validate();
        RpcRetryOptions rpcOptions = options.getOptions();
        Deadline deadline = options.getDeadline();
        Deadline retriesExpirationDeadline = GrpcRetryerUtils.mergeDurationWithAnAbsoluteDeadline(rpcOptions.getExpiration(), deadline);
        BackoffThrottler throttler = new BackoffThrottler(rpcOptions.getInitialInterval(), rpcOptions.getMaximumInterval(), rpcOptions.getBackoffCoefficient());
        int attempt = 0;
        StatusRuntimeException lastMeaningfulException = null;
        while (true) {
            ++attempt;
            try {
                throttler.throttle();
                if (lastMeaningfulException != null) {
                    log.debug("Retrying after failure", lastMeaningfulException);
                }
                R result = r.apply();
                throttler.success();
                return result;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CancellationException();
            }
            catch (StatusRuntimeException e) {
                RuntimeException finalException = GrpcRetryerUtils.createFinalExceptionIfNotRetryable(e, rpcOptions, serverCapabilities);
                if (finalException != null) {
                    log.debug("Final exception, throwing", (Throwable)finalException);
                    throw finalException;
                }
                lastMeaningfulException = GrpcRetryerUtils.lastMeaningfulException(e, lastMeaningfulException);
                throttler.failure();
                if (!GrpcRetryerUtils.ranOutOfRetries(rpcOptions, attempt, retriesExpirationDeadline, Context.current().getDeadline())) continue;
                log.debug("Out of retries, throwing", (Throwable)lastMeaningfulException);
                GrpcSyncRetryer.rethrow((Exception)((Object)lastMeaningfulException));
                throw new IllegalStateException("unreachable");
            }
            break;
        }
    }

    private static <T extends Throwable> void rethrow(Exception e) throws T {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Exception toRethrow = e;
        throw toRethrow;
    }
}

