/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.serviceclient.ServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsImpl;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.time.Duration;
import javax.annotation.Nullable;

public interface WorkflowServiceStubs
extends ServiceStubs<WorkflowServiceGrpc.WorkflowServiceBlockingStub, WorkflowServiceGrpc.WorkflowServiceFutureStub> {
    public static final String HEALTH_CHECK_SERVICE_NAME = "temporal.api.workflowservice.v1.WorkflowService";

    public static WorkflowServiceStubs newLocalServiceStubs() {
        return WorkflowServiceStubs.newServiceStubs(WorkflowServiceStubsOptions.getDefaultInstance());
    }

    public static WorkflowServiceStubs newServiceStubs(WorkflowServiceStubsOptions options) {
        WorkflowThreadMarker.enforceNonWorkflowThread();
        return WorkflowThreadMarker.protectFromWorkflowThread(new WorkflowServiceStubsImpl(null, options), WorkflowServiceStubs.class);
    }

    public static WorkflowServiceStubs newConnectedServiceStubs(WorkflowServiceStubsOptions options, @Nullable Duration timeout) {
        WorkflowServiceStubs workflowServiceStubs = WorkflowServiceStubs.newServiceStubs(options);
        workflowServiceStubs.connect(timeout);
        return workflowServiceStubs;
    }

    @Deprecated
    public static WorkflowServiceStubs newInstance() {
        return WorkflowServiceStubs.newInstance(WorkflowServiceStubsOptions.getDefaultInstance());
    }

    @Deprecated
    public static WorkflowServiceStubs newInstance(WorkflowServiceStubsOptions options) {
        if (options.getDisableHealthCheck()) {
            return WorkflowServiceStubs.newServiceStubs(options);
        }
        return WorkflowServiceStubs.newConnectedServiceStubs(options, options.getHealthCheckTimeout());
    }

    @Deprecated
    public static WorkflowServiceStubs newInstance(WorkflowServiceGrpc.WorkflowServiceImplBase service, WorkflowServiceStubsOptions options) {
        WorkflowThreadMarker.enforceNonWorkflowThread();
        return WorkflowThreadMarker.protectFromWorkflowThread(new WorkflowServiceStubsImpl(service, options), WorkflowServiceStubs.class);
    }

    public WorkflowServiceStubsOptions getOptions();
}

