/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.LongPollUtil;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcDeadlineInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GrpcDeadlineInterceptor.class);
    @Nonnull
    private final Duration rpcTimeout;
    @Nullable
    private final Duration rpcLongPollTimeout;
    @Nullable
    private final Duration rpcQueryTimeout;

    public GrpcDeadlineInterceptor(@Nonnull Duration rpcTimeout, @Nullable Duration rpcLongPollTimeout, @Nullable Duration rpcQueryTimeout) {
        this.rpcTimeout = rpcTimeout;
        this.rpcLongPollTimeout = rpcLongPollTimeout;
        this.rpcQueryTimeout = rpcQueryTimeout;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        long duration = this.rpcLongPollTimeout != null && LongPollUtil.isLongPoll(method, callOptions) ? this.rpcLongPollTimeout.toMillis() : (this.rpcQueryTimeout != null && method == WorkflowServiceGrpc.getQueryWorkflowMethod() ? this.rpcQueryTimeout.toMillis() : this.rpcTimeout.toMillis());
        Deadline deadline = callOptions.getDeadline();
        if (deadline != null) {
            duration = Math.min(duration, deadline.timeRemaining(TimeUnit.MILLISECONDS));
        }
        if (log.isTraceEnabled()) {
            String name = method.getFullMethodName();
            log.trace("method=" + name + ", timeoutMs=" + duration);
        }
        return next.newCall(method, callOptions.withDeadlineAfter(duration, TimeUnit.MILLISECONDS));
    }
}

