/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.ManagedChannel;
import io.temporal.serviceclient.ServiceStubsOptions;
import java.util.Objects;

public final class CloudServiceStubsOptions
extends ServiceStubsOptions {
    public static final String DEFAULT_CLOUD_TARGET = "saas-api.tmprl.cloud:443";
    private static final CloudServiceStubsOptions DEFAULT_INSTANCE = CloudServiceStubsOptions.newBuilder().validateAndBuildWithDefaults();
    private final String version;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(CloudServiceStubsOptions options) {
        return new Builder(options);
    }

    public static CloudServiceStubsOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private CloudServiceStubsOptions(ServiceStubsOptions serviceStubsOptions, String version) {
        super(serviceStubsOptions);
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudServiceStubsOptions that = (CloudServiceStubsOptions)o;
        return Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version);
    }

    public static class Builder
    extends ServiceStubsOptions.Builder<Builder> {
        private String version;

        private Builder() {
            this.setTarget(CloudServiceStubsOptions.DEFAULT_CLOUD_TARGET);
            this.setEnableHttps(true);
        }

        private Builder(CloudServiceStubsOptions options) {
            super(options);
            this.version = options.version;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder setTarget(String target) {
            return (Builder)super.setTarget(target);
        }

        @Override
        public Builder setChannel(ManagedChannel channel) {
            this.setEnableHttps(false);
            this.setTarget(null);
            return (Builder)super.setChannel(channel);
        }

        @Override
        public CloudServiceStubsOptions build() {
            return new CloudServiceStubsOptions(super.build(), this.version);
        }

        @Override
        public CloudServiceStubsOptions validateAndBuildWithDefaults() {
            ServiceStubsOptions serviceStubsOptions = super.validateAndBuildWithDefaults();
            return new CloudServiceStubsOptions(serviceStubsOptions, this.version);
        }
    }
}

