package io.temporal.api.operatorservice.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
 * to perform administrative functions like registering a search attribute or a namespace.
 * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
 * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.34.1)",
    comments = "Source: temporal/api/operatorservice/v1/service.proto")
public final class OperatorServiceGrpc {

  private OperatorServiceGrpc() {}

  public static final String SERVICE_NAME = "temporal.api.operatorservice.v1.OperatorService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AddSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.AddSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.AddSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest, io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod;
    if ((getAddSearchAttributesMethod = OperatorServiceGrpc.getAddSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getAddSearchAttributesMethod = OperatorServiceGrpc.getAddSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getAddSearchAttributesMethod = getAddSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest, io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AddSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("AddSearchAttributes"))
              .build();
        }
      }
    }
    return getAddSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest, io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod;
    if ((getRemoveSearchAttributesMethod = OperatorServiceGrpc.getRemoveSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getRemoveSearchAttributesMethod = OperatorServiceGrpc.getRemoveSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getRemoveSearchAttributesMethod = getRemoveSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest, io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("RemoveSearchAttributes"))
              .build();
        }
      }
    }
    return getRemoveSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.ListSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest, io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod;
    if ((getListSearchAttributesMethod = OperatorServiceGrpc.getListSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListSearchAttributesMethod = OperatorServiceGrpc.getListSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getListSearchAttributesMethod = getListSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest, io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListSearchAttributes"))
              .build();
        }
      }
    }
    return getListSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
      io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteNamespace",
      requestType = io.temporal.api.operatorservice.v1.DeleteNamespaceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteNamespaceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
      io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest, io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod;
    if ((getDeleteNamespaceMethod = OperatorServiceGrpc.getDeleteNamespaceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteNamespaceMethod = OperatorServiceGrpc.getDeleteNamespaceMethod) == null) {
          OperatorServiceGrpc.getDeleteNamespaceMethod = getDeleteNamespaceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest, io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteNamespace"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNamespaceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNamespaceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteNamespace"))
              .build();
        }
      }
    }
    return getDeleteNamespaceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> getAddOrUpdateRemoteClusterMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AddOrUpdateRemoteCluster",
      requestType = io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest.class,
      responseType = io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> getAddOrUpdateRemoteClusterMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest, io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> getAddOrUpdateRemoteClusterMethod;
    if ((getAddOrUpdateRemoteClusterMethod = OperatorServiceGrpc.getAddOrUpdateRemoteClusterMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getAddOrUpdateRemoteClusterMethod = OperatorServiceGrpc.getAddOrUpdateRemoteClusterMethod) == null) {
          OperatorServiceGrpc.getAddOrUpdateRemoteClusterMethod = getAddOrUpdateRemoteClusterMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest, io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AddOrUpdateRemoteCluster"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("AddOrUpdateRemoteCluster"))
              .build();
        }
      }
    }
    return getAddOrUpdateRemoteClusterMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> getRemoveRemoteClusterMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveRemoteCluster",
      requestType = io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest.class,
      responseType = io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> getRemoveRemoteClusterMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest, io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> getRemoveRemoteClusterMethod;
    if ((getRemoveRemoteClusterMethod = OperatorServiceGrpc.getRemoveRemoteClusterMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getRemoveRemoteClusterMethod = OperatorServiceGrpc.getRemoveRemoteClusterMethod) == null) {
          OperatorServiceGrpc.getRemoveRemoteClusterMethod = getRemoveRemoteClusterMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest, io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveRemoteCluster"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("RemoveRemoteCluster"))
              .build();
        }
      }
    }
    return getRemoveRemoteClusterMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListClustersRequest,
      io.temporal.api.operatorservice.v1.ListClustersResponse> getListClustersMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListClusters",
      requestType = io.temporal.api.operatorservice.v1.ListClustersRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListClustersResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListClustersRequest,
      io.temporal.api.operatorservice.v1.ListClustersResponse> getListClustersMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListClustersRequest, io.temporal.api.operatorservice.v1.ListClustersResponse> getListClustersMethod;
    if ((getListClustersMethod = OperatorServiceGrpc.getListClustersMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListClustersMethod = OperatorServiceGrpc.getListClustersMethod) == null) {
          OperatorServiceGrpc.getListClustersMethod = getListClustersMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListClustersRequest, io.temporal.api.operatorservice.v1.ListClustersResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListClusters"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListClustersRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListClustersResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListClusters"))
              .build();
        }
      }
    }
    return getListClustersMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.GetNexusEndpointResponse> getGetNexusEndpointMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetNexusEndpoint",
      requestType = io.temporal.api.operatorservice.v1.GetNexusEndpointRequest.class,
      responseType = io.temporal.api.operatorservice.v1.GetNexusEndpointResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.GetNexusEndpointResponse> getGetNexusEndpointMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusEndpointRequest, io.temporal.api.operatorservice.v1.GetNexusEndpointResponse> getGetNexusEndpointMethod;
    if ((getGetNexusEndpointMethod = OperatorServiceGrpc.getGetNexusEndpointMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getGetNexusEndpointMethod = OperatorServiceGrpc.getGetNexusEndpointMethod) == null) {
          OperatorServiceGrpc.getGetNexusEndpointMethod = getGetNexusEndpointMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.GetNexusEndpointRequest, io.temporal.api.operatorservice.v1.GetNexusEndpointResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetNexusEndpoint"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.GetNexusEndpointRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.GetNexusEndpointResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("GetNexusEndpoint"))
              .build();
        }
      }
    }
    return getGetNexusEndpointMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse> getCreateNexusEndpointMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateNexusEndpoint",
      requestType = io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest.class,
      responseType = io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse> getCreateNexusEndpointMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest, io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse> getCreateNexusEndpointMethod;
    if ((getCreateNexusEndpointMethod = OperatorServiceGrpc.getCreateNexusEndpointMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getCreateNexusEndpointMethod = OperatorServiceGrpc.getCreateNexusEndpointMethod) == null) {
          OperatorServiceGrpc.getCreateNexusEndpointMethod = getCreateNexusEndpointMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest, io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateNexusEndpoint"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("CreateNexusEndpoint"))
              .build();
        }
      }
    }
    return getCreateNexusEndpointMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse> getUpdateNexusEndpointMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateNexusEndpoint",
      requestType = io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest.class,
      responseType = io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse> getUpdateNexusEndpointMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest, io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse> getUpdateNexusEndpointMethod;
    if ((getUpdateNexusEndpointMethod = OperatorServiceGrpc.getUpdateNexusEndpointMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getUpdateNexusEndpointMethod = OperatorServiceGrpc.getUpdateNexusEndpointMethod) == null) {
          OperatorServiceGrpc.getUpdateNexusEndpointMethod = getUpdateNexusEndpointMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest, io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdateNexusEndpoint"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("UpdateNexusEndpoint"))
              .build();
        }
      }
    }
    return getUpdateNexusEndpointMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse> getDeleteNexusEndpointMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteNexusEndpoint",
      requestType = io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest,
      io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse> getDeleteNexusEndpointMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest, io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse> getDeleteNexusEndpointMethod;
    if ((getDeleteNexusEndpointMethod = OperatorServiceGrpc.getDeleteNexusEndpointMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteNexusEndpointMethod = OperatorServiceGrpc.getDeleteNexusEndpointMethod) == null) {
          OperatorServiceGrpc.getDeleteNexusEndpointMethod = getDeleteNexusEndpointMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest, io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteNexusEndpoint"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteNexusEndpoint"))
              .build();
        }
      }
    }
    return getDeleteNexusEndpointMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest,
      io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse> getListNexusEndpointsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListNexusEndpoints",
      requestType = io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest,
      io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse> getListNexusEndpointsMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest, io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse> getListNexusEndpointsMethod;
    if ((getListNexusEndpointsMethod = OperatorServiceGrpc.getListNexusEndpointsMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListNexusEndpointsMethod = OperatorServiceGrpc.getListNexusEndpointsMethod) == null) {
          OperatorServiceGrpc.getListNexusEndpointsMethod = getListNexusEndpointsMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest, io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListNexusEndpoints"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListNexusEndpoints"))
              .build();
        }
      }
    }
    return getListNexusEndpointsMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static OperatorServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceStub>() {
        @java.lang.Override
        public OperatorServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceStub(channel, callOptions);
        }
      };
    return OperatorServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static OperatorServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceBlockingStub>() {
        @java.lang.Override
        public OperatorServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceBlockingStub(channel, callOptions);
        }
      };
    return OperatorServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static OperatorServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceFutureStub>() {
        @java.lang.Override
        public OperatorServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceFutureStub(channel, callOptions);
        }
      };
    return OperatorServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static abstract class OperatorServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public void addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAddSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public void removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRemoveSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public void listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public void deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteNamespaceMethod(), responseObserver);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public void addOrUpdateRemoteCluster(io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAddOrUpdateRemoteClusterMethod(), responseObserver);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public void removeRemoteCluster(io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRemoveRemoteClusterMethod(), responseObserver);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public void listClusters(io.temporal.api.operatorservice.v1.ListClustersRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListClustersResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListClustersMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get a registered Nexus endpoint by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public void getNexusEndpoint(io.temporal.api.operatorservice.v1.GetNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusEndpointResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetNexusEndpointMethod(), responseObserver);
    }

    /**
     * <pre>
     * Create a Nexus endpoint. This will fail if an endpoint with the same name is already registered with a status of
     * ALREADY_EXISTS.
     * Returns the created endpoint with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public void createNexusEndpoint(io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateNexusEndpointMethod(), responseObserver);
    }

    /**
     * <pre>
     * Optimistically update a Nexus endpoint based on provided version as obtained via the `GetNexusEndpoint` or
     * `ListNexusEndpointResponse` APIs. This will fail with a status of FAILED_PRECONDITION if the version does not
     * match.
     * Returns the updated endpoint with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public void updateNexusEndpoint(io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUpdateNexusEndpointMethod(), responseObserver);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public void deleteNexusEndpoint(io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteNexusEndpointMethod(), responseObserver);
    }

    /**
     * <pre>
     * List all Nexus endpoints for the cluster, sorted by ID in ascending order. Set page_token in the request to the
     * next_page_token field of the previous response to get the next page of results. An empty next_page_token
     * indicates that there are no more results. During pagination, a newly added service with an ID lexicographically
     * earlier than the previous page's last endpoint's ID may be missed.
     * </pre>
     */
    public void listNexusEndpoints(io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListNexusEndpointsMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getAddSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>(
                  this, METHODID_ADD_SEARCH_ATTRIBUTES)))
          .addMethod(
            getRemoveSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>(
                  this, METHODID_REMOVE_SEARCH_ATTRIBUTES)))
          .addMethod(
            getListSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>(
                  this, METHODID_LIST_SEARCH_ATTRIBUTES)))
          .addMethod(
            getDeleteNamespaceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
                io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>(
                  this, METHODID_DELETE_NAMESPACE)))
          .addMethod(
            getAddOrUpdateRemoteClusterMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest,
                io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse>(
                  this, METHODID_ADD_OR_UPDATE_REMOTE_CLUSTER)))
          .addMethod(
            getRemoveRemoteClusterMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest,
                io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse>(
                  this, METHODID_REMOVE_REMOTE_CLUSTER)))
          .addMethod(
            getListClustersMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListClustersRequest,
                io.temporal.api.operatorservice.v1.ListClustersResponse>(
                  this, METHODID_LIST_CLUSTERS)))
          .addMethod(
            getGetNexusEndpointMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.GetNexusEndpointRequest,
                io.temporal.api.operatorservice.v1.GetNexusEndpointResponse>(
                  this, METHODID_GET_NEXUS_ENDPOINT)))
          .addMethod(
            getCreateNexusEndpointMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest,
                io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse>(
                  this, METHODID_CREATE_NEXUS_ENDPOINT)))
          .addMethod(
            getUpdateNexusEndpointMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest,
                io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse>(
                  this, METHODID_UPDATE_NEXUS_ENDPOINT)))
          .addMethod(
            getDeleteNexusEndpointMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest,
                io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse>(
                  this, METHODID_DELETE_NEXUS_ENDPOINT)))
          .addMethod(
            getListNexusEndpointsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest,
                io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse>(
                  this, METHODID_LIST_NEXUS_ENDPOINTS)))
          .build();
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceStub extends io.grpc.stub.AbstractAsyncStub<OperatorServiceStub> {
    private OperatorServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public void addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAddSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public void removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRemoveSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public void listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public void deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteNamespaceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public void addOrUpdateRemoteCluster(io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAddOrUpdateRemoteClusterMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public void removeRemoteCluster(io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRemoveRemoteClusterMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public void listClusters(io.temporal.api.operatorservice.v1.ListClustersRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListClustersResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListClustersMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get a registered Nexus endpoint by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public void getNexusEndpoint(io.temporal.api.operatorservice.v1.GetNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusEndpointResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetNexusEndpointMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Create a Nexus endpoint. This will fail if an endpoint with the same name is already registered with a status of
     * ALREADY_EXISTS.
     * Returns the created endpoint with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public void createNexusEndpoint(io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateNexusEndpointMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Optimistically update a Nexus endpoint based on provided version as obtained via the `GetNexusEndpoint` or
     * `ListNexusEndpointResponse` APIs. This will fail with a status of FAILED_PRECONDITION if the version does not
     * match.
     * Returns the updated endpoint with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public void updateNexusEndpoint(io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUpdateNexusEndpointMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public void deleteNexusEndpoint(io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteNexusEndpointMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List all Nexus endpoints for the cluster, sorted by ID in ascending order. Set page_token in the request to the
     * next_page_token field of the previous response to get the next page of results. An empty next_page_token
     * indicates that there are no more results. During pagination, a newly added service with an ID lexicographically
     * earlier than the previous page's last endpoint's ID may be missed.
     * </pre>
     */
    public void listNexusEndpoints(io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListNexusEndpointsMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<OperatorServiceBlockingStub> {
    private OperatorServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.AddSearchAttributesResponse addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getAddSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getRemoveSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListSearchAttributesResponse listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteNamespaceResponse deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteNamespaceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse addOrUpdateRemoteCluster(io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request) {
      return blockingUnaryCall(
          getChannel(), getAddOrUpdateRemoteClusterMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse removeRemoteCluster(io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request) {
      return blockingUnaryCall(
          getChannel(), getRemoveRemoteClusterMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListClustersResponse listClusters(io.temporal.api.operatorservice.v1.ListClustersRequest request) {
      return blockingUnaryCall(
          getChannel(), getListClustersMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get a registered Nexus endpoint by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.GetNexusEndpointResponse getNexusEndpoint(io.temporal.api.operatorservice.v1.GetNexusEndpointRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetNexusEndpointMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Create a Nexus endpoint. This will fail if an endpoint with the same name is already registered with a status of
     * ALREADY_EXISTS.
     * Returns the created endpoint with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse createNexusEndpoint(io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest request) {
      return blockingUnaryCall(
          getChannel(), getCreateNexusEndpointMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Optimistically update a Nexus endpoint based on provided version as obtained via the `GetNexusEndpoint` or
     * `ListNexusEndpointResponse` APIs. This will fail with a status of FAILED_PRECONDITION if the version does not
     * match.
     * Returns the updated endpoint with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse updateNexusEndpoint(io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest request) {
      return blockingUnaryCall(
          getChannel(), getUpdateNexusEndpointMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse deleteNexusEndpoint(io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteNexusEndpointMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List all Nexus endpoints for the cluster, sorted by ID in ascending order. Set page_token in the request to the
     * next_page_token field of the previous response to get the next page of results. An empty next_page_token
     * indicates that there are no more results. During pagination, a newly added service with an ID lexicographically
     * earlier than the previous page's last endpoint's ID may be missed.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse listNexusEndpoints(io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest request) {
      return blockingUnaryCall(
          getChannel(), getListNexusEndpointsMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceFutureStub extends io.grpc.stub.AbstractFutureStub<OperatorServiceFutureStub> {
    private OperatorServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> addSearchAttributes(
        io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAddSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> removeSearchAttributes(
        io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRemoveSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> listSearchAttributes(
        io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> deleteNamespace(
        io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteNamespaceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> addOrUpdateRemoteCluster(
        io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAddOrUpdateRemoteClusterMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> removeRemoteCluster(
        io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRemoveRemoteClusterMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListClustersResponse> listClusters(
        io.temporal.api.operatorservice.v1.ListClustersRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListClustersMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get a registered Nexus endpoint by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.GetNexusEndpointResponse> getNexusEndpoint(
        io.temporal.api.operatorservice.v1.GetNexusEndpointRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetNexusEndpointMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Create a Nexus endpoint. This will fail if an endpoint with the same name is already registered with a status of
     * ALREADY_EXISTS.
     * Returns the created endpoint with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse> createNexusEndpoint(
        io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateNexusEndpointMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Optimistically update a Nexus endpoint based on provided version as obtained via the `GetNexusEndpoint` or
     * `ListNexusEndpointResponse` APIs. This will fail with a status of FAILED_PRECONDITION if the version does not
     * match.
     * Returns the updated endpoint with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse> updateNexusEndpoint(
        io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUpdateNexusEndpointMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse> deleteNexusEndpoint(
        io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteNexusEndpointMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List all Nexus endpoints for the cluster, sorted by ID in ascending order. Set page_token in the request to the
     * next_page_token field of the previous response to get the next page of results. An empty next_page_token
     * indicates that there are no more results. During pagination, a newly added service with an ID lexicographically
     * earlier than the previous page's last endpoint's ID may be missed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse> listNexusEndpoints(
        io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListNexusEndpointsMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ADD_SEARCH_ATTRIBUTES = 0;
  private static final int METHODID_REMOVE_SEARCH_ATTRIBUTES = 1;
  private static final int METHODID_LIST_SEARCH_ATTRIBUTES = 2;
  private static final int METHODID_DELETE_NAMESPACE = 3;
  private static final int METHODID_ADD_OR_UPDATE_REMOTE_CLUSTER = 4;
  private static final int METHODID_REMOVE_REMOTE_CLUSTER = 5;
  private static final int METHODID_LIST_CLUSTERS = 6;
  private static final int METHODID_GET_NEXUS_ENDPOINT = 7;
  private static final int METHODID_CREATE_NEXUS_ENDPOINT = 8;
  private static final int METHODID_UPDATE_NEXUS_ENDPOINT = 9;
  private static final int METHODID_DELETE_NEXUS_ENDPOINT = 10;
  private static final int METHODID_LIST_NEXUS_ENDPOINTS = 11;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final OperatorServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(OperatorServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ADD_SEARCH_ATTRIBUTES:
          serviceImpl.addSearchAttributes((io.temporal.api.operatorservice.v1.AddSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_REMOVE_SEARCH_ATTRIBUTES:
          serviceImpl.removeSearchAttributes((io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_LIST_SEARCH_ATTRIBUTES:
          serviceImpl.listSearchAttributes((io.temporal.api.operatorservice.v1.ListSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_DELETE_NAMESPACE:
          serviceImpl.deleteNamespace((io.temporal.api.operatorservice.v1.DeleteNamespaceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>) responseObserver);
          break;
        case METHODID_ADD_OR_UPDATE_REMOTE_CLUSTER:
          serviceImpl.addOrUpdateRemoteCluster((io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse>) responseObserver);
          break;
        case METHODID_REMOVE_REMOTE_CLUSTER:
          serviceImpl.removeRemoteCluster((io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse>) responseObserver);
          break;
        case METHODID_LIST_CLUSTERS:
          serviceImpl.listClusters((io.temporal.api.operatorservice.v1.ListClustersRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListClustersResponse>) responseObserver);
          break;
        case METHODID_GET_NEXUS_ENDPOINT:
          serviceImpl.getNexusEndpoint((io.temporal.api.operatorservice.v1.GetNexusEndpointRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusEndpointResponse>) responseObserver);
          break;
        case METHODID_CREATE_NEXUS_ENDPOINT:
          serviceImpl.createNexusEndpoint((io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse>) responseObserver);
          break;
        case METHODID_UPDATE_NEXUS_ENDPOINT:
          serviceImpl.updateNexusEndpoint((io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse>) responseObserver);
          break;
        case METHODID_DELETE_NEXUS_ENDPOINT:
          serviceImpl.deleteNexusEndpoint((io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse>) responseObserver);
          break;
        case METHODID_LIST_NEXUS_ENDPOINTS:
          serviceImpl.listNexusEndpoints((io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class OperatorServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    OperatorServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.temporal.api.operatorservice.v1.ServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("OperatorService");
    }
  }

  private static final class OperatorServiceFileDescriptorSupplier
      extends OperatorServiceBaseDescriptorSupplier {
    OperatorServiceFileDescriptorSupplier() {}
  }

  private static final class OperatorServiceMethodDescriptorSupplier
      extends OperatorServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    OperatorServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (OperatorServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new OperatorServiceFileDescriptorSupplier())
              .addMethod(getAddSearchAttributesMethod())
              .addMethod(getRemoveSearchAttributesMethod())
              .addMethod(getListSearchAttributesMethod())
              .addMethod(getDeleteNamespaceMethod())
              .addMethod(getAddOrUpdateRemoteClusterMethod())
              .addMethod(getRemoveRemoteClusterMethod())
              .addMethod(getListClustersMethod())
              .addMethod(getGetNexusEndpointMethod())
              .addMethod(getCreateNexusEndpointMethod())
              .addMethod(getUpdateNexusEndpointMethod())
              .addMethod(getDeleteNexusEndpointMethod())
              .addMethod(getListNexusEndpointsMethod())
              .build();
        }
      }
    }
    return result;
  }
}
