/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.internal.retryer.GrpcMessageTooLargeException;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.StatusUtils;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GrpcRetryerUtils {
    GrpcRetryerUtils() {
    }

    @Nullable
    static RuntimeException createFinalExceptionIfNotRetryable(@Nonnull StatusRuntimeException currentException, @Nonnull RpcRetryOptions options, GetSystemInfoResponse.Capabilities serverCapabilities) {
        Status.Code code = currentException.getStatus().getCode();
        switch (code) {
            case CANCELLED: {
                return new CancellationException("The gRPC request was cancelled");
            }
            case INVALID_ARGUMENT: 
            case NOT_FOUND: 
            case ALREADY_EXISTS: 
            case FAILED_PRECONDITION: 
            case PERMISSION_DENIED: 
            case UNAUTHENTICATED: 
            case UNIMPLEMENTED: {
                return currentException;
            }
            case INTERNAL: {
                if (!serverCapabilities.getInternalErrorDifferentiation()) break;
                return currentException;
            }
            case DEADLINE_EXCEEDED: {
                break;
            }
            case RESOURCE_EXHAUSTED: {
                GrpcMessageTooLargeException e = GrpcMessageTooLargeException.tryWrap(currentException);
                if (e == null) break;
                return e;
            }
            default: {
                for (RpcRetryOptions.DoNotRetryItem pair : options.getDoNotRetry()) {
                    if (pair.getCode() != code || pair.getDetailsClass() != null && !StatusUtils.hasFailure(currentException, pair.getDetailsClass())) continue;
                    return currentException;
                }
            }
        }
        return null;
    }

    static StatusRuntimeException lastMeaningfulException(@Nonnull StatusRuntimeException currentException, @Nullable StatusRuntimeException previousException) {
        if (previousException != null && currentException.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED && previousException.getStatus().getCode() != Status.Code.DEADLINE_EXCEEDED) {
            return previousException;
        }
        return currentException;
    }

    static boolean ranOutOfRetries(RpcRetryOptions options, int attempt, @Nullable Deadline retriesExpirationDeadline, @Nullable Deadline grpcContextDeadline) {
        int maxAttempts = options.getMaximumAttempts();
        return maxAttempts > 0 && attempt >= maxAttempts || retriesExpirationDeadline != null && retriesExpirationDeadline.isExpired() || grpcContextDeadline != null && grpcContextDeadline.isExpired();
    }

    @Nullable
    static Deadline mergeDurationWithAnAbsoluteDeadline(@Nullable Duration duration, @Nullable Deadline deadline) {
        Deadline durationDeadline = null;
        if (duration != null) {
            long ms = duration.toMillis();
            if (ms > 0L) {
                durationDeadline = Deadline.after((long)ms, (TimeUnit)TimeUnit.MILLISECONDS);
            } else {
                long ns = duration.toNanos();
                durationDeadline = Deadline.after((long)ns, (TimeUnit)TimeUnit.NANOSECONDS);
            }
        }
        if (deadline != null) {
            return durationDeadline != null ? deadline.minimum(durationDeadline) : deadline;
        }
        return durationDeadline;
    }
}

