/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.serviceclient.rpcretry.DefaultStubServiceOperationRpcRetryOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RpcRetryOptions {
    private static final RpcRetryOptions DEFAULT_INSTANCE = RpcRetryOptions.newBuilder().build();
    private final Duration initialInterval;
    private final Duration congestionInitialInterval;
    private final double backoffCoefficient;
    private final Duration expiration;
    private final int maximumAttempts;
    private final Duration maximumInterval;
    private final double maximumJitterCoefficient;
    @Nonnull
    private final List<DoNotRetryItem> doNotRetry;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(RpcRetryOptions options) {
        return new Builder(options);
    }

    public static RpcRetryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private RpcRetryOptions(Duration initialInterval, Duration congestionInitialInterval, double backoffCoefficient, Duration expiration, int maximumAttempts, Duration maximumInterval, double maximumJitterCoefficient, @Nonnull List<DoNotRetryItem> doNotRetry) {
        this.initialInterval = initialInterval;
        this.congestionInitialInterval = congestionInitialInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.expiration = expiration;
        this.maximumAttempts = maximumAttempts;
        this.maximumInterval = maximumInterval;
        this.maximumJitterCoefficient = maximumJitterCoefficient;
        this.doNotRetry = Collections.unmodifiableList(doNotRetry);
    }

    public Duration getInitialInterval() {
        return this.initialInterval;
    }

    public Duration getCongestionInitialInterval() {
        return this.congestionInitialInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Duration getMaximumInterval() {
        return this.maximumInterval;
    }

    public double getMaximumJitterCoefficient() {
        return this.maximumJitterCoefficient;
    }

    public void validate() {
        this.validate(true);
    }

    public void validate(boolean hasToBeFinite) {
        if (this.initialInterval == null) {
            throw new IllegalStateException("required property initialInterval not set");
        }
        if (this.congestionInitialInterval == null) {
            throw new IllegalStateException("required property congestionInitialInterval not set");
        }
        if (this.maximumAttempts < 0) {
            throw new IllegalArgumentException("negative maximum attempts");
        }
        if (hasToBeFinite && this.expiration == null && this.maximumAttempts == 0) {
            throw new IllegalArgumentException("both MaximumAttempts and Expiration on retry policy are not set, at least one of them must be set");
        }
        if (this.maximumInterval != null && this.maximumInterval.compareTo(this.initialInterval) < 0) {
            throw new IllegalStateException("maximumInterval(" + this.maximumInterval + ") cannot be smaller than initialInterval(" + this.initialInterval);
        }
        if (this.backoffCoefficient != 0.0 && this.backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("backoffCoefficient less than 1");
        }
        if (!Double.isFinite(this.maximumJitterCoefficient) || this.maximumJitterCoefficient < 0.0 || this.maximumJitterCoefficient >= 1.0) {
            throw new IllegalArgumentException("maximumJitterCoefficient has to be >= 0 and < 1.0: " + this.maximumJitterCoefficient);
        }
    }

    @Nonnull
    public List<DoNotRetryItem> getDoNotRetry() {
        return this.doNotRetry;
    }

    public String toString() {
        return "RetryOptions{initialInterval=" + this.initialInterval + "congestionInitialInterval=" + this.congestionInitialInterval + ", backoffCoefficient=" + this.backoffCoefficient + ", expiration=" + this.expiration + ", maximumAttempts=" + this.maximumAttempts + ", maximumInterval=" + this.maximumInterval + ", maximumJitterCoefficient=" + this.maximumJitterCoefficient + ", doNotRetry=" + this.doNotRetry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcRetryOptions that = (RpcRetryOptions)o;
        return Double.compare(that.backoffCoefficient, this.backoffCoefficient) == 0 && this.maximumAttempts == that.maximumAttempts && Objects.equals(this.initialInterval, that.initialInterval) && Objects.equals(this.congestionInitialInterval, that.congestionInitialInterval) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.maximumInterval, that.maximumInterval) && Objects.equals(this.maximumJitterCoefficient, that.maximumJitterCoefficient) && Objects.equals(this.doNotRetry, that.doNotRetry);
    }

    public int hashCode() {
        return Objects.hash(this.initialInterval, this.congestionInitialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.maximumJitterCoefficient, this.doNotRetry);
    }

    public static final class Builder {
        private Duration initialInterval;
        private Duration congestionInitialInterval;
        private Duration expiration;
        private double backoffCoefficient;
        private int maximumAttempts;
        private Duration maximumInterval;
        private double maximumJitterCoefficient = -1.0;
        private List<DoNotRetryItem> doNotRetry = new ArrayList<DoNotRetryItem>();

        private Builder() {
        }

        private Builder(RpcRetryOptions options) {
            if (options == null) {
                return;
            }
            this.backoffCoefficient = options.getBackoffCoefficient();
            this.maximumAttempts = options.getMaximumAttempts();
            this.expiration = options.getExpiration();
            this.initialInterval = options.getInitialInterval();
            this.congestionInitialInterval = options.getCongestionInitialInterval();
            this.maximumInterval = options.getMaximumInterval();
            this.maximumJitterCoefficient = options.getMaximumJitterCoefficient();
            this.doNotRetry = options.getDoNotRetry();
        }

        public Builder setInitialInterval(Duration initialInterval) {
            if (Builder.isInvalidDuration(initialInterval)) {
                throw new IllegalArgumentException("invalid initialInterval: " + initialInterval);
            }
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder setCongestionInitialInterval(Duration congestionInitialInterval) {
            if (Builder.isInvalidDuration(congestionInitialInterval)) {
                throw new IllegalArgumentException("invalid congestionInitialInterval: " + congestionInitialInterval);
            }
            this.congestionInitialInterval = congestionInitialInterval;
            return this;
        }

        public Builder setExpiration(Duration expiration) {
            if (Builder.isInvalidDuration(expiration)) {
                throw new IllegalArgumentException("invalid expiration : " + expiration);
            }
            this.expiration = expiration;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (Builder.isInvalidBackoffCoefficient(backoffCoefficient)) {
                throw new IllegalArgumentException("backoffCoefficient must be >= 1.0 and finite: " + backoffCoefficient);
            }
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setMaximumAttempts(int maximumAttempts) {
            if (Builder.isInvalidMaxAttempts(maximumAttempts)) {
                throw new IllegalArgumentException("Invalid maximumAttempts: " + maximumAttempts);
            }
            this.maximumAttempts = maximumAttempts;
            return this;
        }

        public Builder setMaximumInterval(Duration maximumInterval) {
            if (Builder.isInvalidDuration(maximumInterval)) {
                throw new IllegalArgumentException("invalid maximumInterval: " + maximumInterval);
            }
            this.maximumInterval = maximumInterval;
            return this;
        }

        public Builder setMaximumJitterCoefficient(double maximumJitterCoefficient) {
            if (Builder.isInvalidJitterCoefficient(maximumJitterCoefficient)) {
                throw new IllegalArgumentException("maximumJitterCoefficient must be >= 0 and < 1.0: " + maximumJitterCoefficient);
            }
            this.maximumJitterCoefficient = maximumJitterCoefficient;
            return this;
        }

        public Builder addDoNotRetry(Status.Code code, @Nullable Class<? extends Message> detailsClass) {
            this.doNotRetry.add(new DoNotRetryItem(code, detailsClass));
            return this;
        }

        public Builder addDoNotRetry(DoNotRetryItem doNotRetryItem) {
            this.doNotRetry.add(doNotRetryItem);
            return this;
        }

        public Builder setRetryOptions(RpcRetryOptions o) {
            if (o == null) {
                return this;
            }
            this.setInitialInterval(OptionsUtils.merge(this.initialInterval, o.getInitialInterval(), Duration.class));
            this.setCongestionInitialInterval(OptionsUtils.merge(this.congestionInitialInterval, o.getInitialInterval(), Duration.class));
            this.setExpiration(OptionsUtils.merge(this.expiration, o.getExpiration(), Duration.class));
            this.setMaximumInterval(OptionsUtils.merge(this.maximumInterval, o.getMaximumInterval(), Duration.class));
            this.setBackoffCoefficient(OptionsUtils.merge(this.backoffCoefficient, o.getBackoffCoefficient(), Double.TYPE));
            this.setMaximumAttempts(OptionsUtils.merge(this.maximumAttempts, o.getMaximumAttempts(), Integer.TYPE));
            if (o.getMaximumJitterCoefficient() != -1.0) {
                this.setMaximumJitterCoefficient(o.getMaximumJitterCoefficient());
            }
            this.doNotRetry = this.merge(this.doNotRetry, o.getDoNotRetry());
            this.validateBuildWithDefaults();
            return this;
        }

        private List<DoNotRetryItem> merge(List<DoNotRetryItem> o1, List<DoNotRetryItem> o2) {
            if (o2 != null) {
                return new ArrayList<DoNotRetryItem>(o2);
            }
            if (o1 != null && !o1.isEmpty()) {
                return new ArrayList<DoNotRetryItem>(o1);
            }
            return null;
        }

        public RpcRetryOptions build() {
            return new RpcRetryOptions(this.initialInterval, this.congestionInitialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.maximumJitterCoefficient, this.doNotRetry);
        }

        public RpcRetryOptions buildWithDefaultsFrom(RpcRetryOptions rpcRetryOptions) {
            return RpcRetryOptions.newBuilder().setRetryOptions(rpcRetryOptions).validateBuildWithDefaults();
        }

        public RpcRetryOptions validateBuildWithDefaults() {
            double maximumJitterCoefficient;
            Duration maximumInterval;
            Duration expiration;
            Duration congestionInitialInterval;
            Duration initialInterval;
            double backoffCoefficient = this.backoffCoefficient;
            if (backoffCoefficient < 1.0) {
                backoffCoefficient = 1.7;
            }
            if ((initialInterval = this.initialInterval) == null) {
                initialInterval = DefaultStubServiceOperationRpcRetryOptions.INITIAL_INTERVAL;
            }
            if ((congestionInitialInterval = this.congestionInitialInterval) == null) {
                congestionInitialInterval = DefaultStubServiceOperationRpcRetryOptions.CONGESTION_INITIAL_INTERVAL;
            }
            if ((expiration = this.expiration) == null) {
                expiration = DefaultStubServiceOperationRpcRetryOptions.EXPIRATION_INTERVAL;
            }
            if ((maximumInterval = this.maximumInterval) == null && this.maximumAttempts == 0) {
                maximumInterval = initialInterval.multipliedBy(50L);
            }
            if ((maximumJitterCoefficient = this.maximumJitterCoefficient) < 0.0) {
                maximumJitterCoefficient = 0.2;
            }
            RpcRetryOptions result = new RpcRetryOptions(initialInterval, congestionInitialInterval, backoffCoefficient, expiration, this.maximumAttempts, maximumInterval, maximumJitterCoefficient, (List)MoreObjects.firstNonNull(this.doNotRetry, Collections.emptyList()));
            result.validate();
            return result;
        }

        private static boolean isInvalidDuration(Duration d) {
            if (d == null) {
                return false;
            }
            return d.isNegative() || d.isZero();
        }

        private static boolean isInvalidMaxAttempts(int i) {
            return i < 0;
        }

        private static boolean isInvalidBackoffCoefficient(double v) {
            return !Double.isFinite(v) || v != 0.0 && v < 1.0;
        }

        private static boolean isInvalidJitterCoefficient(double v) {
            return !Double.isFinite(v) || v != -1.0 && (v < 0.0 || v >= 1.0);
        }
    }

    public static class DoNotRetryItem {
        private final Status.Code code;
        private final Class<? extends Message> detailsClass;

        public DoNotRetryItem(@Nonnull Status.Code code, @Nullable Class<? extends Message> detailsClass) {
            this.code = (Status.Code)Preconditions.checkNotNull((Object)code, (Object)"code");
            this.detailsClass = detailsClass;
        }

        public Status.Code getCode() {
            return this.code;
        }

        public Class<? extends Message> getDetailsClass() {
            return this.detailsClass;
        }
    }
}

