/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.BackoffThrottler;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.retryer.GrpcRetryerUtils;
import io.temporal.serviceclient.RpcRetryOptions;
import java.time.Clock;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcSyncRetryer {
    private static final Logger log = LoggerFactory.getLogger(GrpcSyncRetryer.class);
    private final Clock clock;

    public GrpcSyncRetryer(Clock clock) {
        this.clock = clock;
    }

    public <R, T extends Throwable> R retry(RpcRetryOptions options, GrpcRetryer.RetryableFunc<R, T> r) throws T {
        int attempt = 0;
        long startTime = this.clock.millis();
        BackoffThrottler throttler = new BackoffThrottler(options.getInitialInterval(), options.getMaximumInterval(), options.getBackoffCoefficient());
        Deadline grpcContextDeadline = Context.current().getDeadline();
        StatusRuntimeException lastException = null;
        while (true) {
            ++attempt;
            if (lastException != null) {
                log.warn("Retrying after failure", lastException);
            }
            try {
                throttler.throttle();
                R result = r.apply();
                throttler.success();
                return result;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CancellationException();
            }
            catch (StatusRuntimeException e) {
                RuntimeException finalException = GrpcRetryerUtils.createFinalExceptionIfNotRetryable(e, lastException, options, grpcContextDeadline);
                if (finalException != null) {
                    throw finalException;
                }
                lastException = e;
                throttler.failure();
                if (!GrpcRetryerUtils.ranOutOfRetries(options, startTime, this.clock.millis(), attempt, grpcContextDeadline)) continue;
                GrpcSyncRetryer.rethrow((Exception)((Object)lastException));
                throw new IllegalStateException("unreachable");
            }
            break;
        }
    }

    private static <T extends Throwable> void rethrow(Exception e) throws T {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Exception toRethrow = e;
        throw toRethrow;
    }
}

