/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Preconditions;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.temporal.serviceclient.GrpcMetadataProvider;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.rpcretry.DefaultStubServiceOperationRpcRetryOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class WorkflowServiceStubsOptions {
    public static final String DEFAULT_LOCAL_DOCKER_TARGET = "127.0.0.1:7233";
    public static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_SERVER_LONG_POLL_RPC_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_POLL_RPC_TIMEOUT = DEFAULT_SERVER_LONG_POLL_RPC_TIMEOUT.plus(Duration.ofSeconds(10L));
    public static final Duration DEFAULT_QUERY_RPC_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_GRPC_RECONNECT_FREQUENCY = Duration.ofMinutes(1L);
    private static final WorkflowServiceStubsOptions DEFAULT_INSTANCE = WorkflowServiceStubsOptions.newBuilder().build();
    private final ManagedChannel channel;
    private final String target;
    private final SslContext sslContext;
    private final boolean enableHttps;
    private final boolean disableHealthCheck;
    private final Duration healthCheckAttemptTimeout;
    private final Duration healthCheckTimeout;
    private final boolean enableKeepAlive;
    private final Duration keepAliveTime;
    private final Duration keepAliveTimeout;
    private final boolean keepAlivePermitWithoutStream;
    private final Duration rpcTimeout;
    private final Duration rpcLongPollTimeout;
    private final Duration rpcQueryTimeout;
    private RpcRetryOptions rpcRetryOptions;
    private final Duration connectionBackoffResetFrequency;
    private final Duration grpcReconnectFrequency;
    private final Metadata headers;
    private final Collection<GrpcMetadataProvider> grpcMetadataProviders;
    private final Collection<ClientInterceptor> grpcClientInterceptors;
    private final Scope metricsScope;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowServiceStubsOptions options) {
        return new Builder(options);
    }

    public static WorkflowServiceStubsOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkflowServiceStubsOptions(Builder builder) {
        this.target = builder.target;
        this.sslContext = builder.sslContext;
        this.enableHttps = builder.enableHttps;
        this.channel = builder.channel;
        this.rpcLongPollTimeout = builder.rpcLongPollTimeout;
        this.rpcQueryTimeout = builder.rpcQueryTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.rpcRetryOptions = builder.rpcRetryOptions;
        this.connectionBackoffResetFrequency = builder.connectionBackoffResetFrequency;
        this.grpcReconnectFrequency = builder.grpcReconnectFrequency;
        this.headers = builder.headers;
        this.grpcMetadataProviders = builder.grpcMetadataProviders;
        this.grpcClientInterceptors = builder.grpcClientInterceptors;
        this.metricsScope = builder.metricsScope;
        this.disableHealthCheck = builder.disableHealthCheck;
        this.healthCheckAttemptTimeout = builder.healthCheckAttemptTimeout;
        this.healthCheckTimeout = builder.healthCheckTimeout;
        this.enableKeepAlive = builder.enableKeepAlive;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAlivePermitWithoutStream = builder.keepAlivePermitWithoutStream;
    }

    private WorkflowServiceStubsOptions(Builder builder, boolean ignore) {
        if (builder.target != null && builder.channel != null) {
            throw new IllegalStateException("Only one of the target and channel options can be set at a time");
        }
        if (builder.sslContext != null && builder.channel != null) {
            throw new IllegalStateException("Only one of the sslContext and channel options can be set at a time");
        }
        if (builder.enableHttps && builder.channel != null) {
            throw new IllegalStateException("Only one of the enableHttps and channel options can be set at a time");
        }
        this.target = builder.target == null && builder.channel == null ? DEFAULT_LOCAL_DOCKER_TARGET : builder.target;
        this.sslContext = builder.sslContext;
        this.enableHttps = builder.enableHttps;
        this.channel = builder.channel;
        this.rpcLongPollTimeout = builder.rpcLongPollTimeout;
        this.rpcQueryTimeout = builder.rpcQueryTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.connectionBackoffResetFrequency = builder.connectionBackoffResetFrequency;
        this.grpcReconnectFrequency = builder.grpcReconnectFrequency;
        this.headers = builder.headers != null ? builder.headers : new Metadata();
        this.grpcMetadataProviders = builder.grpcMetadataProviders != null ? builder.grpcMetadataProviders : Collections.emptyList();
        this.grpcClientInterceptors = builder.grpcClientInterceptors != null ? builder.grpcClientInterceptors : Collections.emptyList();
        this.metricsScope = builder.metricsScope == null ? new NoopScope() : builder.metricsScope;
        this.disableHealthCheck = builder.disableHealthCheck;
        this.healthCheckAttemptTimeout = builder.healthCheckAttemptTimeout == null ? Duration.ofSeconds(5L) : builder.healthCheckAttemptTimeout;
        this.healthCheckTimeout = builder.healthCheckTimeout == null ? Duration.ofSeconds(10L) : builder.healthCheckTimeout;
        this.enableKeepAlive = builder.enableKeepAlive;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAlivePermitWithoutStream = builder.keepAlivePermitWithoutStream;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String getTarget() {
        return this.target;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean getEnableHttps() {
        return this.enableHttps;
    }

    public boolean getDisableHealthCheck() {
        return this.disableHealthCheck;
    }

    public Duration getHealthCheckAttemptTimeout() {
        return this.healthCheckAttemptTimeout;
    }

    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public boolean getEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getKeepAlivePermitWithoutStream() {
        return this.keepAlivePermitWithoutStream;
    }

    public Duration getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Duration getRpcLongPollTimeout() {
        return this.rpcLongPollTimeout;
    }

    public Duration getRpcQueryTimeout() {
        return this.rpcQueryTimeout;
    }

    public RpcRetryOptions getRpcRetryOptions() {
        return this.rpcRetryOptions;
    }

    public Duration getConnectionBackoffResetFrequency() {
        return this.connectionBackoffResetFrequency;
    }

    public Duration getGrpcReconnectFrequency() {
        return this.grpcReconnectFrequency;
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public Collection<GrpcMetadataProvider> getGrpcMetadataProviders() {
        return this.grpcMetadataProviders;
    }

    public Collection<ClientInterceptor> getGrpcClientInterceptors() {
        return this.grpcClientInterceptors;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public static class Builder {
        private ManagedChannel channel;
        private SslContext sslContext;
        private boolean enableHttps;
        private String target;
        private boolean disableHealthCheck;
        private Duration healthCheckAttemptTimeout;
        private Duration healthCheckTimeout;
        private boolean enableKeepAlive;
        private Duration keepAliveTime;
        private Duration keepAliveTimeout;
        private boolean keepAlivePermitWithoutStream;
        private Duration rpcTimeout = DEFAULT_RPC_TIMEOUT;
        private Duration rpcLongPollTimeout = DEFAULT_POLL_RPC_TIMEOUT;
        private Duration rpcQueryTimeout = DEFAULT_QUERY_RPC_TIMEOUT;
        private RpcRetryOptions rpcRetryOptions = DefaultStubServiceOperationRpcRetryOptions.INSTANCE;
        private Duration connectionBackoffResetFrequency = DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY;
        private Duration grpcReconnectFrequency = DEFAULT_GRPC_RECONNECT_FREQUENCY;
        private Metadata headers;
        private Collection<GrpcMetadataProvider> grpcMetadataProviders = new ArrayList<GrpcMetadataProvider>(0);
        private Collection<ClientInterceptor> grpcClientInterceptors = new ArrayList<ClientInterceptor>(0);
        private Scope metricsScope;

        private Builder() {
        }

        private Builder(WorkflowServiceStubsOptions options) {
            this.target = options.target;
            this.channel = options.channel;
            this.enableHttps = options.enableHttps;
            this.sslContext = options.sslContext;
            this.rpcLongPollTimeout = options.rpcLongPollTimeout;
            this.rpcQueryTimeout = options.rpcQueryTimeout;
            this.rpcTimeout = options.rpcTimeout;
            this.rpcRetryOptions = options.rpcRetryOptions;
            this.connectionBackoffResetFrequency = options.connectionBackoffResetFrequency;
            this.grpcReconnectFrequency = options.grpcReconnectFrequency;
            this.headers = options.headers;
            this.grpcMetadataProviders = new ArrayList<GrpcMetadataProvider>(options.grpcMetadataProviders);
            this.grpcClientInterceptors = new ArrayList<ClientInterceptor>(options.grpcClientInterceptors);
            this.metricsScope = options.metricsScope;
            this.disableHealthCheck = options.disableHealthCheck;
            this.healthCheckAttemptTimeout = options.healthCheckAttemptTimeout;
            this.healthCheckTimeout = options.healthCheckTimeout;
            this.enableKeepAlive = options.enableKeepAlive;
            this.keepAliveTime = options.keepAliveTime;
            this.keepAliveTimeout = options.keepAliveTimeout;
            this.keepAlivePermitWithoutStream = options.keepAlivePermitWithoutStream;
        }

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setEnableHttps(boolean enableHttps) {
            this.enableHttps = enableHttps;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setRpcTimeout(Duration timeout) {
            this.rpcTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        @Deprecated
        public Builder setRpcLongPollTimeout(Duration timeout) {
            Preconditions.checkArgument((timeout.toMillis() > 70000L ? 1 : 0) != 0, (Object)"rpcLongPollTimeout has to be longer 70s");
            this.rpcLongPollTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setRpcQueryTimeout(Duration rpcQueryTimeout) {
            this.rpcQueryTimeout = rpcQueryTimeout;
            return this;
        }

        public Builder setRpcRetryOptions(RpcRetryOptions rpcRetryOptions) {
            this.rpcRetryOptions = rpcRetryOptions;
            return this;
        }

        public Builder setConnectionBackoffResetFrequency(Duration connectionBackoffResetFrequency) {
            this.connectionBackoffResetFrequency = connectionBackoffResetFrequency;
            return this;
        }

        public Builder setGrpcReconnectFrequency(Duration grpcReconnectFrequency) {
            this.grpcReconnectFrequency = grpcReconnectFrequency;
            return this;
        }

        public Builder setQueryRpcTimeout(Duration timeout) {
            this.rpcQueryTimeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder setHeaders(Metadata headers) {
            this.headers = headers;
            return this;
        }

        public Builder addGrpcMetadataProvider(GrpcMetadataProvider grpcMetadataProvider) {
            this.grpcMetadataProviders.add(grpcMetadataProvider);
            return this;
        }

        public Builder setGrpcMetadataProviders(Collection<GrpcMetadataProvider> grpcMetadataProviders) {
            this.grpcMetadataProviders = grpcMetadataProviders;
            return this;
        }

        public Builder addGrpcClientInterceptor(ClientInterceptor grpcClientInterceptor) {
            this.grpcClientInterceptors.add(grpcClientInterceptor);
            return this;
        }

        public Builder setGrpcClientInterceptors(Collection<ClientInterceptor> grpcClientInterceptors) {
            this.grpcClientInterceptors = grpcClientInterceptors;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setDisableHealthCheck(boolean disableHealthCheck) {
            this.disableHealthCheck = disableHealthCheck;
            return this;
        }

        public Builder setHealthCheckAttemptTimeout(Duration healthCheckAttemptTimeout) {
            this.healthCheckAttemptTimeout = healthCheckAttemptTimeout;
            return this;
        }

        public Builder setHealthCheckTimeout(Duration healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public Builder setEnableKeepAlive(boolean enableKeepAlive) {
            this.enableKeepAlive = enableKeepAlive;
            return this;
        }

        public Builder setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public Builder setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
            return this;
        }

        public Builder setKeepAlivePermitWithoutStream(boolean keepAlivePermitWithoutStream) {
            this.keepAlivePermitWithoutStream = keepAlivePermitWithoutStream;
            return this;
        }

        public WorkflowServiceStubsOptions build() {
            return new WorkflowServiceStubsOptions(this);
        }

        public WorkflowServiceStubsOptions validateAndBuildWithDefaults() {
            return new WorkflowServiceStubsOptions(this, true);
        }
    }
}

