/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import com.google.common.base.Preconditions;
import com.uber.m3.tally.Scope;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.temporal.serviceclient.SimpleSslContextBuilder;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.ConnectionProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.util.ResourceUtils;

public class ServiceStubOptionsTemplate {
    @Nonnull
    private final ConnectionProperties connectionProperties;
    @Nullable
    private final Scope metricsScope;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder> workflowServiceStubsCustomizer;

    public ServiceStubOptionsTemplate(@Nonnull ConnectionProperties connectionProperties, @Nullable Scope metricsScope, @Nullable TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder> workflowServiceStubsCustomizer) {
        this.connectionProperties = connectionProperties;
        this.metricsScope = metricsScope;
        this.workflowServiceStubsCustomizer = workflowServiceStubsCustomizer;
    }

    public WorkflowServiceStubsOptions createServiceStubOptions() {
        WorkflowServiceStubsOptions.Builder stubsOptionsBuilder = WorkflowServiceStubsOptions.newBuilder();
        Preconditions.checkNotNull((Object)this.connectionProperties.getTarget(), (Object)"target");
        stubsOptionsBuilder.setTarget(this.connectionProperties.getTarget());
        stubsOptionsBuilder.setEnableHttps(Boolean.TRUE.equals(this.connectionProperties.isEnableHttps()));
        this.configureMTLS(this.connectionProperties.getMTLS(), stubsOptionsBuilder);
        if (this.metricsScope != null) {
            stubsOptionsBuilder.setMetricsScope(this.metricsScope);
        }
        if (this.workflowServiceStubsCustomizer != null) {
            stubsOptionsBuilder = this.workflowServiceStubsCustomizer.customize(stubsOptionsBuilder);
        }
        return stubsOptionsBuilder.build();
    }

    private void configureMTLS(@Nullable ConnectionProperties.MTLSProperties mtlsProperties, WorkflowServiceStubsOptions.Builder stubsOptionsBuilder) {
        SslContext sslContext;
        block32: {
            if (mtlsProperties == null || mtlsProperties.getKeyFile() == null && mtlsProperties.getCertChainFile() == null && mtlsProperties.getKey() == null && mtlsProperties.getCertChain() == null) {
                return;
            }
            Integer pkcs = mtlsProperties.getPKCS();
            if (pkcs != null && pkcs != 8 && pkcs != 12) {
                throw new BeanDefinitionValidationException("Invalid PKCS: " + pkcs);
            }
            String keyFile = mtlsProperties.getKeyFile();
            String key = mtlsProperties.getKey();
            if (keyFile == null && key == null) {
                throw new BeanDefinitionValidationException("key-file or key has to be specified");
            }
            if (keyFile != null && key != null) {
                throw new BeanDefinitionValidationException("Both key-file and key can't be specified at the same time");
            }
            String certChainFile = mtlsProperties.getCertChainFile();
            String certChain = mtlsProperties.getCertChain();
            if (pkcs == null) {
                pkcs = certChainFile != null || certChain != null ? 8 : 12;
            }
            if (pkcs == 8) {
                if (certChainFile == null && certChain == null) {
                    throw new BeanDefinitionValidationException("cert-chain-file or cert-chain has to be specified for PKCS8");
                }
                if (certChainFile != null && certChain != null) {
                    throw new BeanDefinitionValidationException("Both cert-chain-file or cert-chain can't be set at the same time");
                }
                try (InputStream certInputStream = certChainFile != null ? Files.newInputStream(ResourceUtils.getFile((String)certChainFile).toPath(), new OpenOption[0]) : new ByteArrayInputStream(certChain.getBytes(StandardCharsets.UTF_8));
                     InputStream keyInputStream = keyFile != null ? Files.newInputStream(ResourceUtils.getFile((String)keyFile).toPath(), new OpenOption[0]) : new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8));){
                    SimpleSslContextBuilder sslBuilder = SimpleSslContextBuilder.forPKCS8((InputStream)certInputStream, (InputStream)keyInputStream);
                    sslContext = this.applyMTLSPropertiesAndBuildSslContext(mtlsProperties, sslBuilder);
                    break block32;
                }
                catch (IOException e) {
                    throw new BeanCreationException("Failure reading PKCS8 mTLS key or cert chain file", (Throwable)e);
                }
            }
            if (certChainFile != null || certChain != null) {
                throw new BeanDefinitionValidationException("cert-chain-file or cert-chain can't be specified for PKCS12, cert chain is bundled into the key file");
            }
            if (key != null) {
                throw new BeanDefinitionValidationException("key can't be specified for PKCS12, use key-file");
            }
            try (InputStream keyInputStream = Files.newInputStream(ResourceUtils.getFile((String)keyFile).toPath(), new OpenOption[0]);){
                SimpleSslContextBuilder sslBuilder = SimpleSslContextBuilder.forPKCS12((InputStream)keyInputStream);
                sslContext = this.applyMTLSPropertiesAndBuildSslContext(mtlsProperties, sslBuilder);
            }
            catch (IOException e) {
                throw new BeanCreationException("Failure reading PKCS12 mTLS cert key file", (Throwable)e);
            }
        }
        stubsOptionsBuilder.setSslContext(sslContext);
    }

    private SslContext applyMTLSPropertiesAndBuildSslContext(ConnectionProperties.MTLSProperties mtlsProperties, SimpleSslContextBuilder sslBuilder) {
        if (mtlsProperties.getKeyPassword() != null) {
            sslBuilder.setKeyPassword(mtlsProperties.getKeyPassword());
        }
        if (Boolean.TRUE.equals(mtlsProperties.getInsecureTrustManager())) {
            sslBuilder.setUseInsecureTrustManager(true);
        }
        try {
            return sslBuilder.build();
        }
        catch (SSLException e) {
            throw new BeanCreationException("Failure building SSLContext", (Throwable)e);
        }
    }
}

