/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.properties;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConstructorBinding;

public class WorkerProperties {
    @Nonnull
    private final String taskQueue;
    @Nullable
    private final String name;
    @Nullable
    private final Collection<Class<?>> workflowClasses;
    @Nullable
    private final Collection<String> activityBeans;
    @Nullable
    private final CapacityConfigurationProperties capacity;
    @Nullable
    private final RateLimitsConfigurationProperties rateLimits;

    @ConstructorBinding
    public WorkerProperties(@Nonnull String taskQueue, @Nullable String name, @Nullable Collection<Class<?>> workflowClasses, @Nullable Collection<String> activityBeans, @Nullable CapacityConfigurationProperties capacity, @Nullable RateLimitsConfigurationProperties rateLimits) {
        this.name = name;
        this.taskQueue = taskQueue;
        this.workflowClasses = workflowClasses;
        this.activityBeans = activityBeans;
        this.capacity = capacity;
        this.rateLimits = rateLimits;
    }

    @Nonnull
    public String getTaskQueue() {
        return this.taskQueue;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Collection<Class<?>> getWorkflowClasses() {
        return this.workflowClasses;
    }

    @Nullable
    public Collection<String> getActivityBeans() {
        return this.activityBeans;
    }

    @Nullable
    public CapacityConfigurationProperties getCapacity() {
        return this.capacity;
    }

    @Nullable
    public RateLimitsConfigurationProperties getRateLimits() {
        return this.rateLimits;
    }

    public static class RateLimitsConfigurationProperties {
        @Nullable
        private final Double maxWorkerActivitiesPerSecond;
        @Nullable
        private final Double maxTaskQueueActivitiesPerSecond;

        @ConstructorBinding
        public RateLimitsConfigurationProperties(@Nullable Double maxWorkerActivitiesPerSecond, @Nullable Double maxTaskQueueActivitiesPerSecond) {
            this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
            this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
        }

        @Nullable
        public Double getMaxWorkerActivitiesPerSecond() {
            return this.maxWorkerActivitiesPerSecond;
        }

        @Nullable
        public Double getMaxTaskQueueActivitiesPerSecond() {
            return this.maxTaskQueueActivitiesPerSecond;
        }
    }

    public static class CapacityConfigurationProperties {
        @Nullable
        private final Integer maxConcurrentWorkflowTaskExecutors;
        @Nullable
        private final Integer maxConcurrentActivityExecutors;
        @Nullable
        private final Integer maxConcurrentLocalActivityExecutors;
        @Nullable
        private final Integer maxConcurrentWorkflowTaskPollers;
        @Nullable
        private final Integer maxConcurrentActivityTaskPollers;

        @ConstructorBinding
        public CapacityConfigurationProperties(@Nullable Integer maxConcurrentWorkflowTaskExecutors, @Nullable Integer maxConcurrentActivityExecutors, @Nullable Integer maxConcurrentLocalActivityExecutors, @Nullable Integer maxConcurrentWorkflowTaskPollers, @Nullable Integer maxConcurrentActivityTaskPollers) {
            this.maxConcurrentWorkflowTaskExecutors = maxConcurrentWorkflowTaskExecutors;
            this.maxConcurrentActivityExecutors = maxConcurrentActivityExecutors;
            this.maxConcurrentLocalActivityExecutors = maxConcurrentLocalActivityExecutors;
            this.maxConcurrentWorkflowTaskPollers = maxConcurrentWorkflowTaskPollers;
            this.maxConcurrentActivityTaskPollers = maxConcurrentActivityTaskPollers;
        }

        @Nullable
        public Integer getMaxConcurrentWorkflowTaskExecutors() {
            return this.maxConcurrentWorkflowTaskExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentActivityExecutors() {
            return this.maxConcurrentActivityExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentLocalActivityExecutors() {
            return this.maxConcurrentLocalActivityExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentWorkflowTaskPollers() {
            return this.maxConcurrentWorkflowTaskPollers;
        }

        @Nullable
        public Integer getMaxConcurrentActivityTaskPollers() {
            return this.maxConcurrentActivityTaskPollers;
        }
    }
}

