/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.opentracing.OpenTracingClientInterceptor;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowClientOptionsTemplate {
    @Nonnull
    private final String namespace;
    @Nullable
    private final DataConverter dataConverter;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleCustomizer;

    public WorkflowClientOptionsTemplate(@Nonnull String namespace, @Nullable DataConverter dataConverter, @Nullable Tracer tracer, @Nullable TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer, @Nullable TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleCustomizer) {
        this.namespace = namespace;
        this.dataConverter = dataConverter;
        this.tracer = tracer;
        this.clientCustomizer = clientCustomizer;
        this.scheduleCustomizer = scheduleCustomizer;
    }

    public WorkflowClientOptions createWorkflowClientOptions() {
        WorkflowClientOptions.Builder options = WorkflowClientOptions.newBuilder();
        options.setNamespace(this.namespace);
        Optional.ofNullable(this.dataConverter).ifPresent(arg_0 -> ((WorkflowClientOptions.Builder)options).setDataConverter(arg_0));
        if (this.tracer != null) {
            OpenTracingClientInterceptor openTracingClientInterceptor = new OpenTracingClientInterceptor(OpenTracingOptions.newBuilder().setTracer(this.tracer).build());
            options.setInterceptors(new WorkflowClientInterceptor[]{openTracingClientInterceptor});
        }
        if (this.clientCustomizer != null) {
            options = this.clientCustomizer.customize(options);
        }
        return options.build();
    }

    public ScheduleClientOptions createScheduleClientOptions() {
        ScheduleClientOptions.Builder options = ScheduleClientOptions.newBuilder();
        options.setNamespace(this.namespace);
        Optional.ofNullable(this.dataConverter).ifPresent(arg_0 -> ((ScheduleClientOptions.Builder)options).setDataConverter(arg_0));
        if (this.scheduleCustomizer != null) {
            options = this.scheduleCustomizer.customize(options);
        }
        return options.build();
    }
}

