/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import io.opentracing.Tracer;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClient;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.AutoConfigurationUtils;
import io.temporal.spring.boot.autoconfigure.OpenTracingAutoConfiguration;
import io.temporal.spring.boot.autoconfigure.ServiceStubsAutoConfiguration;
import io.temporal.spring.boot.autoconfigure.WorkersPresentCondition;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.NamespaceTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkersTemplate;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.ContextStartedEvent;

@Configuration
@EnableConfigurationProperties(value={TemporalProperties.class})
@AutoConfigureAfter(value={ServiceStubsAutoConfiguration.class, OpenTracingAutoConfiguration.class})
@ConditionalOnBean(value={ServiceStubsAutoConfiguration.class})
@ConditionalOnExpression(value="${spring.temporal.test-server.enabled:false} || '${spring.temporal.connection.target:}'.length() > 0")
public class RootNamespaceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RootNamespaceAutoConfiguration.class);
    private final ConfigurableListableBeanFactory beanFactory;

    public RootNamespaceAutoConfiguration(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean(name={"temporalRootNamespaceTemplate"})
    public NamespaceTemplate rootNamespaceTemplate(TemporalProperties properties, WorkflowServiceStubs workflowServiceStubs, @Autowired List<DataConverter> dataConverters, @Qualifier(value="mainDataConverter") @Autowired(required=false) @Nullable DataConverter mainDataConverter, @Autowired(required=false) @Nullable Tracer otTracer, @Qualifier(value="temporalTestWorkflowEnvironmentAdapter") @Autowired(required=false) @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Autowired(required=false) @Nullable TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer, @Autowired(required=false) @Nullable TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer, @Autowired(required=false) @Nullable TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer, @Autowired(required=false) @Nullable TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleCustomize) {
        DataConverter chosenDataConverter = AutoConfigurationUtils.choseDataConverter(dataConverters, mainDataConverter);
        return new NamespaceTemplate(properties, properties, workflowServiceStubs, chosenDataConverter, otTracer, testWorkflowEnvironment, workerFactoryCustomizer, workerCustomizer, clientCustomizer, scheduleCustomize);
    }

    @Bean(name={"temporalClientTemplate"})
    public ClientTemplate clientTemplate(@Qualifier(value="temporalRootNamespaceTemplate") NamespaceTemplate rootNamespaceTemplate) {
        return rootNamespaceTemplate.getClientTemplate();
    }

    @Bean(name={"temporalWorkflowClient"})
    public WorkflowClient client(ClientTemplate clientTemplate) {
        return clientTemplate.getWorkflowClient();
    }

    @Bean(name={"temporalScheduleClient"})
    public ScheduleClient scheduleClient(ClientTemplate clientTemplate) {
        return clientTemplate.getScheduleClient();
    }

    @Bean(name={"temporalWorkersTemplate"})
    @Conditional(value={WorkersPresentCondition.class})
    @DependsOn(value={"temporalClientTemplate"})
    public WorkersTemplate workersTemplate(@Qualifier(value="temporalRootNamespaceTemplate") NamespaceTemplate temporalRootNamespaceTemplate) {
        return temporalRootNamespaceTemplate.getWorkersTemplate();
    }

    @Bean(name={"temporalWorkerFactory"}, destroyMethod="shutdown")
    @Conditional(value={WorkersPresentCondition.class})
    public WorkerFactory workerFactory(@Qualifier(value="temporalWorkersTemplate") WorkersTemplate workersTemplate) {
        return workersTemplate.getWorkerFactory();
    }

    @Bean(name={"temporalWorkers"})
    @Conditional(value={WorkersPresentCondition.class})
    public Collection<Worker> workers(@Qualifier(value="temporalWorkersTemplate") WorkersTemplate workersTemplate) {
        Collection<Worker> workers = workersTemplate.getWorkers();
        workers.forEach(worker -> this.beanFactory.registerSingleton("temporalWorker-" + worker.getTaskQueue(), worker));
        return workers;
    }

    @ConditionalOnProperty(prefix="spring.temporal", name={"startWorkers"}, matchIfMissing=true)
    @Conditional(value={WorkersPresentCondition.class})
    @Bean
    public WorkerFactoryStarter workerFactoryStarter(WorkerFactory workerFactory) {
        return new WorkerFactoryStarter(workerFactory);
    }

    public static class WorkerFactoryStarter
    implements ApplicationListener<ContextStartedEvent> {
        private final WorkerFactory workerFactory;

        public WorkerFactoryStarter(WorkerFactory workerFactory) {
            this.workerFactory = workerFactory;
        }

        public void onApplicationEvent(@Nonnull ContextStartedEvent event) {
            this.workerFactory.start();
        }
    }
}

