/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import com.google.common.base.Preconditions;
import io.opentracing.Tracer;
import io.temporal.client.WorkflowClient;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.spring.boot.ActivityImpl;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.WorkflowImpl;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import io.temporal.spring.boot.autoconfigure.properties.WorkerProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkerFactoryOptionsTemplate;
import io.temporal.spring.boot.autoconfigure.template.WorkerOptionsTemplate;
import io.temporal.spring.boot.autoconfigure.template.WorkflowImplementationOptionsTemplate;
import io.temporal.worker.TypeAlreadyRegisteredException;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

public class WorkersTemplate
implements BeanFactoryAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(WorkersTemplate.class);
    @Nonnull
    private final TemporalProperties properties;
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    private final ClientTemplate clientTemplate;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer;
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private WorkerFactory workerFactory;
    private Collection<Worker> workers;

    public WorkersTemplate(@Nonnull TemporalProperties properties, @Nonnull NamespaceProperties namespaceProperties, @Nullable ClientTemplate clientTemplate, @Nullable Tracer tracer, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer, @Nullable TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer, @Nullable TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer) {
        this.properties = properties;
        this.namespaceProperties = namespaceProperties;
        this.tracer = tracer;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.clientTemplate = clientTemplate;
        this.workerFactoryCustomizer = workerFactoryCustomizer;
        this.workerCustomizer = workerCustomizer;
        this.workflowImplementationCustomizer = workflowImplementationCustomizer;
    }

    public WorkerFactory getWorkerFactory() {
        if (this.workerFactory == null) {
            this.workerFactory = this.createWorkerFactory(this.clientTemplate.getWorkflowClient());
        }
        return this.workerFactory;
    }

    public Collection<Worker> getWorkers() {
        if (this.workers == null) {
            this.workers = this.createWorkers(this.getWorkerFactory());
        }
        return this.workers;
    }

    WorkerFactory createWorkerFactory(WorkflowClient workflowClient) {
        if (this.testWorkflowEnvironment != null) {
            return this.testWorkflowEnvironment.getWorkerFactory();
        }
        WorkerFactoryOptions workerFactoryOptions = new WorkerFactoryOptionsTemplate(this.namespaceProperties, this.tracer, this.workerFactoryCustomizer).createWorkerFactoryOptions();
        return WorkerFactory.newInstance((WorkflowClient)workflowClient, (WorkerFactoryOptions)workerFactoryOptions);
    }

    private Collection<Worker> createWorkers(WorkerFactory workerFactory) {
        Workers workers = new Workers();
        if (this.properties.getWorkers() != null) {
            this.properties.getWorkers().forEach(workerProperties -> this.createWorkerFromAnExplicitConfig(workerFactory, (WorkerProperties)workerProperties, workers));
        }
        if (this.properties.getWorkersAutoDiscovery() != null && this.properties.getWorkersAutoDiscovery().getPackages() != null) {
            Collection<Class<?>> autoDiscoveredWorkflowImplementationClasses = this.autoDiscoverWorkflowImplementations();
            Map<String, Object> autoDiscoveredActivityBeans = this.autoDiscoverActivityBeans();
            this.configureWorkflowImplementationsByTaskQueue(workerFactory, workers, autoDiscoveredWorkflowImplementationClasses);
            this.configureActivityBeansByTaskQueue(workerFactory, workers, autoDiscoveredActivityBeans);
            this.configureWorkflowImplementationsByWorkerName(workers, autoDiscoveredWorkflowImplementationClasses);
            this.configureActivityBeansByWorkerName(workers, autoDiscoveredActivityBeans);
        }
        return workers.getWorkers();
    }

    private void configureWorkflowImplementationsByTaskQueue(WorkerFactory workerFactory, Workers workers, Collection<Class<?>> autoDiscoveredWorkflowImplementationClasses) {
        for (Class<?> clazz : autoDiscoveredWorkflowImplementationClasses) {
            WorkflowImpl annotation = clazz.getAnnotation(WorkflowImpl.class);
            for (String taskQueue : annotation.taskQueues()) {
                Worker worker = workerFactory.tryGetWorker(taskQueue = this.environment.resolvePlaceholders(taskQueue));
                if (worker == null) {
                    log.info("Creating a worker with default settings for a task queue '{}' caused by an auto-discovered workflow class {}", (Object)taskQueue, clazz);
                    worker = this.createNewWorker(taskQueue, null, workers);
                }
                this.configureWorkflowImplementationAutoDiscovery(worker, clazz, null);
            }
        }
    }

    private void configureActivityBeansByTaskQueue(WorkerFactory workerFactory, Workers workers, Map<String, Object> autoDiscoveredActivityBeans) {
        autoDiscoveredActivityBeans.forEach((beanName, bean) -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            ActivityImpl annotation = (ActivityImpl)AnnotationUtils.findAnnotation((Class)targetClass, ActivityImpl.class);
            if (annotation != null) {
                for (String taskQueue : annotation.taskQueues()) {
                    Worker worker = workerFactory.tryGetWorker(taskQueue = this.environment.resolvePlaceholders(taskQueue));
                    if (worker == null) {
                        log.info("Creating a worker with default settings for a task queue '{}' caused by an auto-discovered activity class {}", (Object)taskQueue, (Object)targetClass);
                        worker = this.createNewWorker(taskQueue, null, workers);
                    }
                    this.configureActivityImplementationAutoDiscovery(worker, bean, (String)beanName, targetClass, null);
                }
            }
        });
    }

    private void configureWorkflowImplementationsByWorkerName(Workers workers, Collection<Class<?>> autoDiscoveredWorkflowImplementationClasses) {
        for (Class<?> clazz : autoDiscoveredWorkflowImplementationClasses) {
            WorkflowImpl annotation = clazz.getAnnotation(WorkflowImpl.class);
            for (String workerName : annotation.workers()) {
                Worker worker = workers.getByName(workerName);
                if (worker == null) {
                    throw new BeanDefinitionValidationException("Worker with name " + workerName + " is not found in the config, but is referenced by auto-discovered workflow implementation class " + clazz);
                }
                this.configureWorkflowImplementationAutoDiscovery(worker, clazz, workerName);
            }
        }
    }

    private void configureActivityBeansByWorkerName(Workers workers, Map<String, Object> autoDiscoveredActivityBeans) {
        autoDiscoveredActivityBeans.forEach((beanName, bean) -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            ActivityImpl annotation = (ActivityImpl)AnnotationUtils.findAnnotation((Class)targetClass, ActivityImpl.class);
            if (annotation != null) {
                for (String workerName : annotation.workers()) {
                    Worker worker = workers.getByName(workerName);
                    if (worker == null) {
                        throw new BeanDefinitionValidationException("Worker with name " + workerName + " is not found in the config, but is referenced by auto-discovered activity bean " + beanName);
                    }
                    this.configureActivityImplementationAutoDiscovery(worker, bean, (String)beanName, targetClass, workerName);
                }
            }
        });
    }

    private Collection<Class<?>> autoDiscoverWorkflowImplementations() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WorkflowImpl.class));
        HashSet implementations = new HashSet();
        for (String pckg : this.properties.getWorkersAutoDiscovery().getPackages()) {
            Set candidateComponents = scanner.findCandidateComponents(pckg);
            for (BeanDefinition beanDefinition : candidateComponents) {
                try {
                    implementations.add(Class.forName(beanDefinition.getBeanClassName()));
                }
                catch (ClassNotFoundException e) {
                    throw new BeanDefinitionValidationException("Fail loading class for bean definition " + beanDefinition, (Throwable)e);
                }
            }
        }
        return implementations;
    }

    private Map<String, Object> autoDiscoverActivityBeans() {
        return this.beanFactory.getBeansWithAnnotation(ActivityImpl.class);
    }

    private void createWorkerFromAnExplicitConfig(WorkerFactory workerFactory, WorkerProperties workerProperties, Workers workers) {
        Collection<String> activityBeans;
        String taskQueue = workerProperties.getTaskQueue();
        if (workerFactory.tryGetWorker(taskQueue) != null) {
            throw new BeanDefinitionValidationException("Worker for the task queue " + taskQueue + " already exists. Duplicate workers in the config?");
        }
        log.info("Creating configured worker for a task queue {}", (Object)taskQueue);
        Worker worker = this.createNewWorker(taskQueue, workerProperties, workers);
        Collection<Class<?>> workflowClasses = workerProperties.getWorkflowClasses();
        if (workflowClasses != null) {
            workflowClasses.forEach(clazz -> {
                log.info("Registering configured workflow class {} on a task queue '{}'", clazz, (Object)taskQueue);
                this.configureWorkflowImplementation(worker, (Class<?>)clazz);
            });
        }
        if ((activityBeans = workerProperties.getActivityBeans()) != null) {
            activityBeans.forEach(beanName -> {
                Object bean = this.beanFactory.getBean(beanName);
                log.info("Registering configured activity bean '{}' of a {} class on task queue '{}'", new Object[]{beanName, AopUtils.getTargetClass((Object)bean), taskQueue});
                worker.registerActivitiesImplementations(new Object[]{bean});
            });
        }
    }

    private void configureActivityImplementationAutoDiscovery(Worker worker, Object bean, String beanName, Class<?> targetClass, String byWorkerName) {
        block3: {
            try {
                worker.registerActivitiesImplementations(new Object[]{bean});
                if (log.isInfoEnabled()) {
                    log.info("Registering auto-discovered activity bean '{}' of class {} on a worker {}with a task queue '{}'", new Object[]{beanName, targetClass, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue()});
                }
            }
            catch (TypeAlreadyRegisteredException registeredEx) {
                if (!log.isInfoEnabled()) break block3;
                log.info("Skipping auto-discovered activity bean '{}' of class {} on a worker {}with a task queue '{}' as activity type '{}' is already registered on the worker", new Object[]{beanName, targetClass, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue(), registeredEx.getRegisteredTypeName()});
            }
        }
    }

    private void configureWorkflowImplementationAutoDiscovery(Worker worker, Class<?> clazz, String byWorkerName) {
        block3: {
            try {
                this.configureWorkflowImplementation(worker, clazz);
                if (log.isInfoEnabled()) {
                    log.info("Registering auto-discovered workflow class {} on a worker {}with a task queue '{}'", new Object[]{clazz, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue()});
                }
            }
            catch (TypeAlreadyRegisteredException registeredEx) {
                if (!log.isInfoEnabled()) break block3;
                log.info("Skip registering of auto-discovered workflow class {} on a worker {}with a task queue '{}' as workflow type '{}' is already registered on the worker", new Object[]{clazz, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue(), registeredEx.getRegisteredTypeName()});
            }
        }
    }

    private <T> void configureWorkflowImplementation(Worker worker, Class<?> clazz) {
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newInstance(clazz);
        List workflowMethods = workflowMetadata.getWorkflowMethods();
        if (workflowMethods.isEmpty()) {
            throw new BeanDefinitionValidationException("Workflow implementation doesn't implement any interface with a workflow method annotated with @WorkflowMethod: " + clazz);
        }
        WorkflowImplementationOptions workflowImplementationOptions = new WorkflowImplementationOptionsTemplate(this.workflowImplementationCustomizer).createWorkflowImplementationOptions();
        for (POJOWorkflowMethodMetadata workflowMethod : workflowMetadata.getWorkflowMethods()) {
            worker.registerWorkflowImplementationFactory(workflowMethod.getWorkflowInterface(), (Functions.Func & Serializable)() -> this.beanFactory.createBean(clazz), workflowImplementationOptions);
        }
    }

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    private Worker createNewWorker(@Nonnull String taskQueue, @Nullable WorkerProperties properties, @Nonnull Workers workers) {
        Preconditions.checkState((this.workerFactory.tryGetWorker(taskQueue) == null ? 1 : 0) != 0, (String)"[BUG] This method should never be called twice for the same Task Queue='%s'", (Object)taskQueue);
        String workerName = properties != null && properties.getName() != null ? properties.getName() : taskQueue;
        WorkerOptions workerOptions = new WorkerOptionsTemplate(workerName, taskQueue, properties, this.workerCustomizer).createWorkerOptions();
        Worker worker = this.workerFactory.newWorker(taskQueue, workerOptions);
        workers.addWorker(workerName, worker);
        return worker;
    }

    private static class Workers {
        private final Map<String, Worker> workersByName = new HashMap<String, Worker>();
        private final Map<String, Worker> workersByTaskQueue = new HashMap<String, Worker>();
        private final List<Worker> workers = new ArrayList<Worker>();

        private Workers() {
        }

        public void addWorker(@Nonnull String workerName, Worker newWorker) {
            Worker existingWorker = this.workersByTaskQueue.get(newWorker.getTaskQueue());
            Preconditions.checkState((existingWorker == null ? 1 : 0) != 0, (String)"[BUG] Worker with Task Queue='%s' already exists.", (Object)newWorker.getTaskQueue());
            existingWorker = this.workersByName.get(workerName);
            if (existingWorker != null) {
                throw new BeanDefinitionValidationException("Worker name " + workerName + " is shared between Workers on different Task Queues '" + existingWorker.getTaskQueue() + "' and '" + newWorker.getTaskQueue() + "'. Worker names should be unique.");
            }
            this.workers.add(newWorker);
            this.workersByTaskQueue.put(newWorker.getTaskQueue(), newWorker);
            this.workersByName.put(workerName, newWorker);
        }

        public List<Worker> getWorkers() {
            return this.workers;
        }

        @Nullable
        public Worker getByName(String workerName) {
            return this.workersByName.get(workerName);
        }
    }
}

