/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.properties;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConstructorBinding;

public class ConnectionProperties {
    public static final String TARGET_LOCAL_SERVICE = "local";
    @Nonnull
    private final String target;
    @Nullable
    private final Boolean enableHttps;
    @Nullable
    private final MTLSProperties mtls;

    @ConstructorBinding
    public ConnectionProperties(@Nonnull String target, @Nullable Boolean enableHttps, @Nullable MTLSProperties mtls) {
        this.target = target;
        this.enableHttps = Boolean.TRUE.equals(enableHttps);
        this.mtls = mtls;
    }

    @Nonnull
    public String getTarget() {
        return this.target;
    }

    @Nullable
    public Boolean isEnableHttps() {
        return this.enableHttps;
    }

    @Nullable
    public MTLSProperties getMTLS() {
        return this.mtls;
    }

    public static class MTLSProperties {
        @Nullable
        private final Integer pkcs;
        @Nullable
        private final String key;
        @Nullable
        private final String certChain;
        @Nullable
        private final String keyFile;
        @Nullable
        private final String certChainFile;
        @Nullable
        private final String keyPassword;
        @Nullable
        private final Boolean insecureTrustManager;
        @Nullable
        private final String serverName;

        @ConstructorBinding
        public MTLSProperties(@Nullable Integer pkcs, @Nullable String key, @Nullable String certChain, @Nullable String keyFile, @Nullable String certChainFile, @Nullable String keyPassword, @Nullable Boolean insecureTrustManager, @Nullable String serverName) {
            this.pkcs = pkcs;
            this.key = key;
            this.certChain = certChain;
            this.keyFile = keyFile;
            this.certChainFile = certChainFile;
            this.keyPassword = keyPassword;
            this.insecureTrustManager = insecureTrustManager;
            this.serverName = serverName;
        }

        @Nullable
        public Integer getPKCS() {
            return this.pkcs;
        }

        @Nullable
        public String getKey() {
            return this.key;
        }

        @Nullable
        public String getCertChain() {
            return this.certChain;
        }

        @Nullable
        public String getKeyFile() {
            return this.keyFile;
        }

        @Nullable
        public String getCertChainFile() {
            return this.certChainFile;
        }

        @Nullable
        public String getKeyPassword() {
            return this.keyPassword;
        }

        @Nullable
        public Boolean getInsecureTrustManager() {
            return this.insecureTrustManager;
        }

        @Nullable
        public String getServerName() {
            return this.serverName;
        }
    }
}

