/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import com.google.common.base.Preconditions;
import io.opentracing.Tracer;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClient;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkflowClientOptionsTemplate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientTemplate {
    @Nonnull
    private final WorkflowClientOptionsTemplate optionsTemplate;
    @Nullable
    private final WorkflowServiceStubs workflowServiceStubs;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    private WorkflowClient workflowClient;
    private ScheduleClient scheduleClient;

    public ClientTemplate(@Nonnull String namespace, @Nullable DataConverter dataConverter, @Nullable Tracer tracer, @Nullable WorkflowServiceStubs workflowServiceStubs, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer, @Nullable TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleCustomer) {
        this.optionsTemplate = new WorkflowClientOptionsTemplate(namespace, dataConverter, tracer, clientCustomizer, scheduleCustomer);
        this.workflowServiceStubs = workflowServiceStubs;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
    }

    public WorkflowClient getWorkflowClient() {
        if (this.workflowClient == null) {
            this.workflowClient = this.createWorkflowClient();
        }
        return this.workflowClient;
    }

    public ScheduleClient getScheduleClient() {
        if (this.scheduleClient == null) {
            this.scheduleClient = this.createScheduleClient();
        }
        return this.scheduleClient;
    }

    private WorkflowClient createWorkflowClient() {
        if (this.testWorkflowEnvironment != null) {
            return this.testWorkflowEnvironment.getWorkflowClient();
        }
        Preconditions.checkState((this.workflowServiceStubs != null ? 1 : 0) != 0, (Object)"ClientTemplate was created without workflowServiceStubs");
        return WorkflowClient.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (WorkflowClientOptions)this.optionsTemplate.createWorkflowClientOptions());
    }

    private ScheduleClient createScheduleClient() {
        if (this.testWorkflowEnvironment != null) {
            return ScheduleClient.newInstance((WorkflowServiceStubs)this.testWorkflowEnvironment.getWorkflowClient().getWorkflowServiceStubs());
        }
        Preconditions.checkState((this.workflowServiceStubs != null ? 1 : 0) != 0, (Object)"ClientTemplate was created without workflowServiceStubs");
        return ScheduleClient.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (ScheduleClientOptions)this.optionsTemplate.createScheduleClientOptions());
    }
}

