/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.opentracingshim.OpenTracingShim;
import io.opentracing.Tracer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OpenTelemetry.class})
@ConditionalOnBean(value={OpenTelemetry.class})
@AutoConfigureAfter(name={"org.springframework.cloud.sleuth.autoconfig.otel.OtelAutoConfiguration"})
public class OpenTracingAutoConfiguration {
    @ConditionalOnMissingBean(value={Tracer.class})
    @Bean(name={"temporalOtTracer"})
    public Tracer openTracingTracer(@Autowired OpenTelemetry otel) {
        return OpenTracingShim.createTracerShim((OpenTelemetry)otel);
    }
}

