/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import com.google.common.base.Preconditions;
import io.nexusrpc.ServiceDefinition;
import io.nexusrpc.handler.ServiceImplInstance;
import io.opentracing.Tracer;
import io.temporal.client.WorkflowClient;
import io.temporal.common.Experimental;
import io.temporal.common.metadata.POJOActivityImplMetadata;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.spring.boot.ActivityImpl;
import io.temporal.spring.boot.NexusServiceImpl;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.WorkflowImpl;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import io.temporal.spring.boot.autoconfigure.properties.WorkerProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkerFactoryOptionsTemplate;
import io.temporal.spring.boot.autoconfigure.template.WorkerOptionsTemplate;
import io.temporal.spring.boot.autoconfigure.template.WorkflowImplementationOptionsTemplate;
import io.temporal.worker.TypeAlreadyRegisteredException;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

public class WorkersTemplate
implements BeanFactoryAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(WorkersTemplate.class);
    @Nonnull
    private final TemporalProperties properties;
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    private final ClientTemplate clientTemplate;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer;
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private WorkerFactory workerFactory;
    private Collection<Worker> workers;
    private final Map<String, RegisteredInfo> registeredInfo = new HashMap<String, RegisteredInfo>();

    public WorkersTemplate(@Nonnull TemporalProperties properties, @Nonnull NamespaceProperties namespaceProperties, @Nullable ClientTemplate clientTemplate, @Nullable Tracer tracer, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer, @Nullable TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer, @Nullable TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer) {
        this.properties = properties;
        this.namespaceProperties = namespaceProperties;
        this.tracer = tracer;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.clientTemplate = clientTemplate;
        this.workerFactoryCustomizer = workerFactoryCustomizer;
        this.workerCustomizer = workerCustomizer;
        this.workflowImplementationCustomizer = workflowImplementationCustomizer;
    }

    public WorkerFactory getWorkerFactory() {
        if (this.workerFactory == null) {
            this.workerFactory = this.createWorkerFactory(this.clientTemplate.getWorkflowClient());
        }
        return this.workerFactory;
    }

    public Collection<Worker> getWorkers() {
        if (this.workers == null) {
            this.workers = this.createWorkers(this.getWorkerFactory());
        }
        return this.workers;
    }

    @Experimental
    public Map<String, RegisteredInfo> getRegisteredInfo() {
        if (this.workers == null) {
            this.workers = this.createWorkers(this.getWorkerFactory());
        }
        return this.registeredInfo;
    }

    WorkerFactory createWorkerFactory(WorkflowClient workflowClient) {
        if (this.testWorkflowEnvironment != null) {
            return this.testWorkflowEnvironment.getWorkerFactory();
        }
        WorkerFactoryOptions workerFactoryOptions = new WorkerFactoryOptionsTemplate(this.namespaceProperties, this.tracer, this.workerFactoryCustomizer).createWorkerFactoryOptions();
        return WorkerFactory.newInstance((WorkflowClient)workflowClient, (WorkerFactoryOptions)workerFactoryOptions);
    }

    private Collection<Worker> createWorkers(WorkerFactory workerFactory) {
        Workers workers = new Workers();
        if (this.properties.getWorkers() != null) {
            this.properties.getWorkers().forEach(workerProperties -> this.createWorkerFromAnExplicitConfig(workerFactory, (WorkerProperties)workerProperties, workers));
        }
        if (this.properties.getWorkersAutoDiscovery() != null && this.properties.getWorkersAutoDiscovery().getPackages() != null) {
            Collection<Class<?>> autoDiscoveredWorkflowImplementationClasses = this.autoDiscoverWorkflowImplementations();
            Map<String, Object> autoDiscoveredActivityBeans = this.autoDiscoverActivityBeans();
            Map<String, Object> autoDiscoveredNexusServiceBeans = this.autoDiscoverNexusServiceBeans();
            this.configureWorkflowImplementationsByTaskQueue(workerFactory, workers, autoDiscoveredWorkflowImplementationClasses);
            this.configureActivityBeansByTaskQueue(workerFactory, workers, autoDiscoveredActivityBeans);
            this.configureNexusServiceBeansByTaskQueue(workerFactory, workers, autoDiscoveredNexusServiceBeans);
            this.configureWorkflowImplementationsByWorkerName(workers, autoDiscoveredWorkflowImplementationClasses);
            this.configureActivityBeansByWorkerName(workers, autoDiscoveredActivityBeans);
            this.configureNexusServiceBeansByWorkerName(workers, autoDiscoveredNexusServiceBeans);
        }
        return workers.getWorkers();
    }

    private void configureWorkflowImplementationsByTaskQueue(WorkerFactory workerFactory, Workers workers, Collection<Class<?>> autoDiscoveredWorkflowImplementationClasses) {
        for (Class<?> clazz : autoDiscoveredWorkflowImplementationClasses) {
            WorkflowImpl annotation = clazz.getAnnotation(WorkflowImpl.class);
            for (String taskQueue : annotation.taskQueues()) {
                Worker worker = workerFactory.tryGetWorker(taskQueue = this.environment.resolvePlaceholders(taskQueue));
                if (worker == null) {
                    log.info("Creating a worker with default settings for a task queue '{}' caused by an auto-discovered workflow class {}", (Object)taskQueue, clazz);
                    worker = this.createNewWorker(taskQueue, null, workers);
                }
                this.configureWorkflowImplementationAutoDiscovery(worker, clazz, null, workers);
            }
        }
    }

    private void configureActivityBeansByTaskQueue(WorkerFactory workerFactory, Workers workers, Map<String, Object> autoDiscoveredActivityBeans) {
        autoDiscoveredActivityBeans.forEach((beanName, bean) -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            ActivityImpl annotation = (ActivityImpl)AnnotationUtils.findAnnotation((Class)targetClass, ActivityImpl.class);
            if (annotation != null) {
                for (String taskQueue : annotation.taskQueues()) {
                    Worker worker = workerFactory.tryGetWorker(taskQueue = this.environment.resolvePlaceholders(taskQueue));
                    if (worker == null) {
                        log.info("Creating a worker with default settings for a task queue '{}' caused by an auto-discovered activity class {}", (Object)taskQueue, (Object)targetClass);
                        worker = this.createNewWorker(taskQueue, null, workers);
                    }
                    this.configureActivityImplementationAutoDiscovery(worker, bean, (String)beanName, targetClass, null, workers);
                }
            }
        });
    }

    private void configureNexusServiceBeansByTaskQueue(WorkerFactory workerFactory, Workers workers, Map<String, Object> autoDiscoveredNexusServiceBeans) {
        autoDiscoveredNexusServiceBeans.forEach((beanName, bean) -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            NexusServiceImpl annotation = (NexusServiceImpl)AnnotationUtils.findAnnotation((Class)targetClass, NexusServiceImpl.class);
            if (annotation != null) {
                for (String taskQueue : annotation.taskQueues()) {
                    Worker worker = workerFactory.tryGetWorker(taskQueue = this.environment.resolvePlaceholders(taskQueue));
                    if (worker == null) {
                        log.info("Creating a worker with default settings for a task queue '{}' caused by an auto-discovered nexus service class {}", (Object)taskQueue, (Object)targetClass);
                        worker = this.createNewWorker(taskQueue, null, workers);
                    }
                    this.configureNexusServiceImplementationAutoDiscovery(worker, bean, (String)beanName, targetClass, null, workers);
                }
            }
        });
    }

    private void configureWorkflowImplementationsByWorkerName(Workers workers, Collection<Class<?>> autoDiscoveredWorkflowImplementationClasses) {
        for (Class<?> clazz : autoDiscoveredWorkflowImplementationClasses) {
            WorkflowImpl annotation = clazz.getAnnotation(WorkflowImpl.class);
            for (String workerName : annotation.workers()) {
                Worker worker = workers.getByName(workerName);
                if (worker == null) {
                    throw new BeanDefinitionValidationException("Worker with name " + workerName + " is not found in the config, but is referenced by auto-discovered workflow implementation class " + clazz);
                }
                this.configureWorkflowImplementationAutoDiscovery(worker, clazz, workerName, workers);
            }
        }
    }

    private void configureActivityBeansByWorkerName(Workers workers, Map<String, Object> autoDiscoveredActivityBeans) {
        autoDiscoveredActivityBeans.forEach((beanName, bean) -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            ActivityImpl annotation = (ActivityImpl)AnnotationUtils.findAnnotation((Class)targetClass, ActivityImpl.class);
            if (annotation != null) {
                for (String workerName : annotation.workers()) {
                    Worker worker = workers.getByName(workerName);
                    if (worker == null) {
                        throw new BeanDefinitionValidationException("Worker with name " + workerName + " is not found in the config, but is referenced by auto-discovered activity bean " + beanName);
                    }
                    this.configureActivityImplementationAutoDiscovery(worker, bean, (String)beanName, targetClass, workerName, workers);
                }
            }
        });
    }

    private void configureNexusServiceBeansByWorkerName(Workers workers, Map<String, Object> autoDiscoveredNexusServiceBeans) {
        autoDiscoveredNexusServiceBeans.forEach((beanName, bean) -> {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            NexusServiceImpl annotation = (NexusServiceImpl)AnnotationUtils.findAnnotation((Class)targetClass, NexusServiceImpl.class);
            if (annotation != null) {
                for (String workerName : annotation.workers()) {
                    Worker worker = workers.getByName(workerName);
                    if (worker == null) {
                        throw new BeanDefinitionValidationException("Worker with name " + workerName + " is not found in the config, but is referenced by auto-discovered nexus service bean " + beanName);
                    }
                    this.configureNexusServiceImplementationAutoDiscovery(worker, bean, (String)beanName, targetClass, workerName, workers);
                }
            }
        });
    }

    private Collection<Class<?>> autoDiscoverWorkflowImplementations() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WorkflowImpl.class));
        HashSet implementations = new HashSet();
        for (String pckg : this.properties.getWorkersAutoDiscovery().getPackages()) {
            Set candidateComponents = scanner.findCandidateComponents(pckg);
            for (BeanDefinition beanDefinition : candidateComponents) {
                try {
                    implementations.add(Class.forName(beanDefinition.getBeanClassName()));
                }
                catch (ClassNotFoundException e) {
                    throw new BeanDefinitionValidationException("Fail loading class for bean definition " + beanDefinition, (Throwable)e);
                }
            }
        }
        return implementations;
    }

    private Map<String, Object> autoDiscoverActivityBeans() {
        return this.beanFactory.getBeansWithAnnotation(ActivityImpl.class);
    }

    private Map<String, Object> autoDiscoverNexusServiceBeans() {
        return this.beanFactory.getBeansWithAnnotation(NexusServiceImpl.class);
    }

    private void createWorkerFromAnExplicitConfig(WorkerFactory workerFactory, WorkerProperties workerProperties, Workers workers) {
        Collection<String> nexusServiceBeans;
        Collection<String> activityBeans;
        String taskQueue = workerProperties.getTaskQueue();
        if (workerFactory.tryGetWorker(taskQueue) != null) {
            throw new BeanDefinitionValidationException("Worker for the task queue " + taskQueue + " already exists. Duplicate workers in the config?");
        }
        log.info("Creating configured worker for a task queue {}", (Object)taskQueue);
        Worker worker = this.createNewWorker(taskQueue, workerProperties, workers);
        Collection<Class<?>> workflowClasses = workerProperties.getWorkflowClasses();
        if (workflowClasses != null) {
            workflowClasses.forEach(clazz -> {
                log.info("Registering configured workflow class {} on a task queue '{}'", clazz, (Object)taskQueue);
                this.configureWorkflowImplementation(worker, (Class<?>)clazz);
            });
        }
        if ((activityBeans = workerProperties.getActivityBeans()) != null) {
            activityBeans.forEach(beanName -> {
                Object bean = this.beanFactory.getBean(beanName);
                log.info("Registering configured activity bean '{}' of a {} class on task queue '{}'", new Object[]{beanName, AopUtils.getTargetClass((Object)bean), taskQueue});
                worker.registerActivitiesImplementations(new Object[]{bean});
                POJOActivityImplMetadata activityImplMetadata = POJOActivityImplMetadata.newInstance((Class)AopUtils.getTargetClass((Object)bean));
                this.addRegisteredActivityImpl(worker, (String)beanName, bean.getClass().getName(), activityImplMetadata);
            });
        }
        if ((nexusServiceBeans = workerProperties.getNexusServiceBeans()) != null) {
            nexusServiceBeans.forEach(beanName -> {
                Object bean = this.beanFactory.getBean(beanName);
                log.info("Registering configured nexus service bean '{}' of a {} class on task queue '{}'", new Object[]{beanName, AopUtils.getTargetClass((Object)bean), taskQueue});
                worker.registerNexusServiceImplementation(new Object[]{bean});
                this.addRegisteredNexusServiceImpl(worker, (String)beanName, bean.getClass().getName(), ServiceImplInstance.fromInstance((Object)AopUtils.getTargetClass((Object)bean)).getDefinition());
            });
        }
    }

    private void configureActivityImplementationAutoDiscovery(Worker worker, Object bean, String beanName, Class<?> targetClass, String byWorkerName, Workers workers) {
        block3: {
            try {
                worker.registerActivitiesImplementations(new Object[]{bean});
                POJOActivityImplMetadata activityImplMetadata = POJOActivityImplMetadata.newInstance((Class)AopUtils.getTargetClass((Object)bean));
                this.addRegisteredActivityImpl(worker, beanName, bean.getClass().getName(), activityImplMetadata);
                if (log.isInfoEnabled()) {
                    log.info("Registering auto-discovered activity bean '{}' of class {} on a worker {} with a task queue '{}'", new Object[]{beanName, targetClass, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue()});
                }
            }
            catch (TypeAlreadyRegisteredException registeredEx) {
                if (!log.isInfoEnabled()) break block3;
                log.info("Skipping auto-discovered activity bean '{}' of class {} on a worker {} with a task queue '{}' as activity type '{}' is already registered on the worker", new Object[]{beanName, targetClass, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue(), registeredEx.getRegisteredTypeName()});
            }
        }
    }

    private void configureNexusServiceImplementationAutoDiscovery(Worker worker, Object bean, String beanName, Class<?> targetClass, String byWorkerName, Workers workers) {
        block3: {
            try {
                worker.registerNexusServiceImplementation(new Object[]{bean});
                this.addRegisteredNexusServiceImpl(worker, beanName, bean.getClass().getName(), ServiceImplInstance.fromInstance((Object)bean).getDefinition());
                if (log.isInfoEnabled()) {
                    log.info("Registering auto-discovered nexus service bean '{}' of class {} on a worker {} with a task queue '{}'", new Object[]{beanName, targetClass, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue()});
                }
            }
            catch (TypeAlreadyRegisteredException registeredEx) {
                if (!log.isInfoEnabled()) break block3;
                log.info("Skipping auto-discovered nexus service bean '{}' of class {} on a worker {} with a task queue '{}' as nexus service type '{}' is already registered on the worker", new Object[]{beanName, targetClass, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue(), registeredEx.getRegisteredTypeName()});
            }
        }
    }

    private void configureWorkflowImplementationAutoDiscovery(Worker worker, Class<?> clazz, String byWorkerName, Workers workers) {
        block3: {
            try {
                this.configureWorkflowImplementation(worker, clazz);
                if (log.isInfoEnabled()) {
                    log.info("Registering auto-discovered workflow class {} on a worker {}with a task queue '{}'", new Object[]{clazz, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue()});
                }
            }
            catch (TypeAlreadyRegisteredException registeredEx) {
                if (!log.isInfoEnabled()) break block3;
                log.info("Skip registering of auto-discovered workflow class {} on a worker {}with a task queue '{}' as workflow type '{}' is already registered on the worker", new Object[]{clazz, byWorkerName != null ? "'" + byWorkerName + "' " : "", worker.getTaskQueue(), registeredEx.getRegisteredTypeName()});
            }
        }
    }

    private <T> void configureWorkflowImplementation(Worker worker, Class<?> clazz) {
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newInstanceForWorkflowFactory(clazz);
        List workflowMethods = workflowMetadata.getWorkflowMethods();
        if (workflowMethods.isEmpty()) {
            throw new BeanDefinitionValidationException("Workflow implementation doesn't implement any interface with a workflow method annotated with @WorkflowMethod: " + clazz);
        }
        WorkflowImplementationOptions workflowImplementationOptions = new WorkflowImplementationOptionsTemplate(this.workflowImplementationCustomizer).createWorkflowImplementationOptions();
        for (POJOWorkflowMethodMetadata workflowMethod : workflowMetadata.getWorkflowMethods()) {
            worker.registerWorkflowImplementationFactory(workflowMethod.getWorkflowInterface(), (Functions.Func & Serializable)() -> this.beanFactory.createBean(clazz), workflowImplementationOptions);
            this.addRegisteredWorkflowImpl(worker, workflowMethod.getWorkflowInterface().getName(), workflowMetadata);
        }
    }

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    private Worker createNewWorker(@Nonnull String taskQueue, @Nullable WorkerProperties properties, @Nonnull Workers workers) {
        Preconditions.checkState((this.workerFactory.tryGetWorker(taskQueue) == null ? 1 : 0) != 0, (String)"[BUG] This method should never be called twice for the same Task Queue='%s'", (Object)taskQueue);
        String workerName = properties != null && properties.getName() != null ? properties.getName() : taskQueue;
        WorkerOptions workerOptions = new WorkerOptionsTemplate(workerName, taskQueue, properties, this.workerCustomizer).createWorkerOptions();
        Worker worker = this.workerFactory.newWorker(taskQueue, workerOptions);
        workers.addWorker(workerName, worker);
        return worker;
    }

    private void addRegisteredWorkflowImpl(Worker worker, String workflowClass, POJOWorkflowImplMetadata metadata) {
        if (!this.registeredInfo.containsKey(worker.getTaskQueue())) {
            this.registeredInfo.put(worker.getTaskQueue(), new RegisteredInfo().addWorkflowInfo(new RegisteredWorkflowInfo().addClassName(workflowClass).addMetadata(metadata)));
        } else {
            this.registeredInfo.get(worker.getTaskQueue()).getRegisteredWorkflowInfo().add(new RegisteredWorkflowInfo().addClassName(workflowClass).addMetadata(metadata));
        }
    }

    private void addRegisteredActivityImpl(Worker worker, String beanName, String beanClass, POJOActivityImplMetadata metadata) {
        if (!this.registeredInfo.containsKey(worker.getTaskQueue())) {
            this.registeredInfo.put(worker.getTaskQueue(), new RegisteredInfo().addActivityInfo(new RegisteredActivityInfo().addBeanName(beanName).addClassName(beanClass).addMetadata(metadata)));
        } else {
            this.registeredInfo.get(worker.getTaskQueue()).getRegisteredActivityInfo().add(new RegisteredActivityInfo().addBeanName(beanName).addClassName(beanClass).addMetadata(metadata));
        }
    }

    private void addRegisteredNexusServiceImpl(Worker worker, String beanName, String beanClass, ServiceDefinition serviceDefinition) {
        if (!this.registeredInfo.containsKey(worker.getTaskQueue())) {
            this.registeredInfo.put(worker.getTaskQueue(), new RegisteredInfo().addNexusServiceInfo(new RegisteredNexusServiceInfo().addBeanName(beanName).addClassName(beanClass).addDefinition(serviceDefinition)));
        } else {
            this.registeredInfo.get(worker.getTaskQueue()).getRegisteredNexusServiceInfos().add(new RegisteredNexusServiceInfo().addBeanName(beanName).addClassName(beanClass).addDefinition(serviceDefinition));
        }
    }

    private static class Workers {
        private final Map<String, Worker> workersByName = new HashMap<String, Worker>();
        private final Map<String, Worker> workersByTaskQueue = new HashMap<String, Worker>();
        private final List<Worker> workers = new ArrayList<Worker>();

        private Workers() {
        }

        public void addWorker(@Nonnull String workerName, Worker newWorker) {
            Worker existingWorker = this.workersByTaskQueue.get(newWorker.getTaskQueue());
            Preconditions.checkState((existingWorker == null ? 1 : 0) != 0, (String)"[BUG] Worker with Task Queue='%s' already exists.", (Object)newWorker.getTaskQueue());
            existingWorker = this.workersByName.get(workerName);
            if (existingWorker != null) {
                throw new BeanDefinitionValidationException("Worker name " + workerName + " is shared between Workers on different Task Queues '" + existingWorker.getTaskQueue() + "' and '" + newWorker.getTaskQueue() + "'. Worker names should be unique.");
            }
            this.workers.add(newWorker);
            this.workersByTaskQueue.put(newWorker.getTaskQueue(), newWorker);
            this.workersByName.put(workerName, newWorker);
        }

        public List<Worker> getWorkers() {
            return this.workers;
        }

        @Nullable
        public Worker getByName(String workerName) {
            return this.workersByName.get(workerName);
        }
    }

    @Experimental
    public static class RegisteredWorkflowInfo {
        private String className;
        private POJOWorkflowImplMetadata metadata;

        public RegisteredWorkflowInfo addClassName(String className) {
            this.className = className;
            return this;
        }

        public RegisteredWorkflowInfo addMetadata(POJOWorkflowImplMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public POJOWorkflowImplMetadata getMetadata() {
            return this.metadata;
        }
    }

    @Experimental
    public static class RegisteredNexusServiceInfo {
        private String beanName;
        private String className;
        private ServiceDefinition definition;

        public RegisteredNexusServiceInfo addClassName(String className) {
            this.className = className;
            return this;
        }

        public RegisteredNexusServiceInfo addBeanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        public RegisteredNexusServiceInfo addDefinition(ServiceDefinition definition) {
            this.definition = definition;
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public ServiceDefinition getDefinition() {
            return this.definition;
        }
    }

    @Experimental
    public static class RegisteredActivityInfo {
        private String beanName;
        private String className;
        private POJOActivityImplMetadata metadata;

        public RegisteredActivityInfo addClassName(String className) {
            this.className = className;
            return this;
        }

        public RegisteredActivityInfo addBeanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        public RegisteredActivityInfo addMetadata(POJOActivityImplMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public POJOActivityImplMetadata getMetadata() {
            return this.metadata;
        }
    }

    public static class RegisteredInfo {
        private final List<RegisteredActivityInfo> registeredActivityInfo = new ArrayList<RegisteredActivityInfo>();
        private final List<RegisteredWorkflowInfo> registeredWorkflowInfo = new ArrayList<RegisteredWorkflowInfo>();
        private final List<RegisteredNexusServiceInfo> registeredNexusServiceInfos = new ArrayList<RegisteredNexusServiceInfo>();

        public RegisteredInfo addActivityInfo(RegisteredActivityInfo activityInfo) {
            this.registeredActivityInfo.add(activityInfo);
            return this;
        }

        public RegisteredInfo addNexusServiceInfo(RegisteredNexusServiceInfo nexusServiceInfo) {
            this.registeredNexusServiceInfos.add(nexusServiceInfo);
            return this;
        }

        public RegisteredInfo addWorkflowInfo(RegisteredWorkflowInfo workflowInfo) {
            this.registeredWorkflowInfo.add(workflowInfo);
            return this;
        }

        public List<RegisteredActivityInfo> getRegisteredActivityInfo() {
            return this.registeredActivityInfo;
        }

        public List<RegisteredWorkflowInfo> getRegisteredWorkflowInfo() {
            return this.registeredWorkflowInfo;
        }

        public List<RegisteredNexusServiceInfo> getRegisteredNexusServiceInfos() {
            return this.registeredNexusServiceInfos;
        }
    }
}

