/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import com.google.common.base.MoreObjects;
import com.uber.m3.tally.Scope;
import io.opentracing.Tracer;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClient;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.AutoConfigurationUtils;
import io.temporal.spring.boot.autoconfigure.properties.ConnectionProperties;
import io.temporal.spring.boot.autoconfigure.properties.NonRootNamespaceProperties;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.NamespaceTemplate;
import io.temporal.spring.boot.autoconfigure.template.NonRootNamespaceTemplate;
import io.temporal.spring.boot.autoconfigure.template.ServiceStubsTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkersTemplate;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class NonRootBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(NonRootBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;
    @Nonnull
    private final TemporalProperties temporalProperties;
    @Nullable
    private final List<NonRootNamespaceProperties> namespaceProperties;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final Scope metricsScope;

    public NonRootBeanPostProcessor(@Nonnull TemporalProperties temporalProperties, @Nullable Tracer tracer, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable Scope metricsScope) {
        this.temporalProperties = temporalProperties;
        this.namespaceProperties = temporalProperties.getNamespaces();
        this.tracer = tracer;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.metricsScope = metricsScope;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof NamespaceTemplate && beanName.equals("temporalRootNamespaceTemplate") && this.namespaceProperties != null) {
            this.namespaceProperties.forEach(this::injectBeanByNonRootNamespace);
        }
        return bean;
    }

    private void injectBeanByNonRootNamespace(NonRootNamespaceProperties ns) {
        String beanPrefix = (String)MoreObjects.firstNonNull((Object)ns.getAlias(), (Object)ns.getNamespace());
        DataConverter dataConverterByNamespace = this.findBeanByNamespace(beanPrefix, DataConverter.class);
        TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workFactoryCustomizer = this.findBeanByNameSpaceForTemporalCustomizer(beanPrefix, WorkerFactoryOptions.Builder.class);
        TemporalOptionsCustomizer<WorkflowServiceStubsOptions.Builder> workflowServiceStubsCustomizer = this.findBeanByNameSpaceForTemporalCustomizer(beanPrefix, WorkflowServiceStubsOptions.Builder.class);
        TemporalOptionsCustomizer<WorkerOptions.Builder> WorkerCustomizer = this.findBeanByNameSpaceForTemporalCustomizer(beanPrefix, WorkerOptions.Builder.class);
        TemporalOptionsCustomizer<WorkflowClientOptions.Builder> workflowClientCustomizer = this.findBeanByNameSpaceForTemporalCustomizer(beanPrefix, WorkflowClientOptions.Builder.class);
        TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleClientCustomizer = this.findBeanByNameSpaceForTemporalCustomizer(beanPrefix, ScheduleClientOptions.Builder.class);
        TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer = this.findBeanByNameSpaceForTemporalCustomizer(beanPrefix, WorkflowImplementationOptions.Builder.class);
        ConnectionProperties connectionProperties = (ConnectionProperties)MoreObjects.firstNonNull((Object)ns.getConnection(), (Object)this.temporalProperties.getConnection());
        ServiceStubsTemplate serviceStubsTemplate = new ServiceStubsTemplate(connectionProperties, this.metricsScope, this.testWorkflowEnvironment, workflowServiceStubsCustomizer);
        WorkflowServiceStubs workflowServiceStubs = serviceStubsTemplate.getWorkflowServiceStubs();
        NonRootNamespaceTemplate namespaceTemplate = new NonRootNamespaceTemplate((BeanFactory)this.beanFactory, ns, workflowServiceStubs, dataConverterByNamespace, this.tracer, this.testWorkflowEnvironment, workFactoryCustomizer, WorkerCustomizer, builder -> Optional.ofNullable(workflowClientCustomizer).map(c -> c.customize(builder)).orElse((WorkflowClientOptions.Builder)builder).setNamespace(ns.getNamespace()), scheduleClientCustomizer, workflowImplementationCustomizer);
        ClientTemplate clientTemplate = namespaceTemplate.getClientTemplate();
        WorkflowClient workflowClient = clientTemplate.getWorkflowClient();
        ScheduleClient scheduleClient = clientTemplate.getScheduleClient();
        WorkersTemplate workersTemplate = namespaceTemplate.getWorkersTemplate();
        WorkerFactory workerFactory = workersTemplate.getWorkerFactory();
        this.beanFactory.registerSingleton(beanPrefix + ServiceStubsTemplate.class.getSimpleName(), (Object)serviceStubsTemplate);
        this.beanFactory.registerSingleton(beanPrefix + WorkflowServiceStubs.class.getSimpleName(), (Object)workflowServiceStubs);
        this.beanFactory.registerSingleton(beanPrefix + NamespaceTemplate.class.getSimpleName(), (Object)namespaceTemplate);
        this.beanFactory.registerSingleton(beanPrefix + ClientTemplate.class.getSimpleName(), (Object)namespaceTemplate.getClientTemplate());
        this.beanFactory.registerSingleton(beanPrefix + WorkersTemplate.class.getSimpleName(), (Object)workersTemplate);
        this.beanFactory.registerSingleton(beanPrefix + WorkflowClient.class.getSimpleName(), (Object)workflowClient);
        this.beanFactory.registerSingleton(beanPrefix + ScheduleClient.class.getSimpleName(), (Object)scheduleClient);
        this.beanFactory.registerSingleton(beanPrefix + WorkerFactory.class.getSimpleName(), (Object)workerFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private <T> T findBeanByNamespace(String beanPrefix, Class<T> clazz) {
        try {
            return (T)this.beanFactory.getBean(beanPrefix + clazz.getSimpleName(), clazz);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    private <T> TemporalOptionsCustomizer<T> findBeanByNameSpaceForTemporalCustomizer(String beanPrefix, Class<T> genericOptionsBuilderClass) {
        String beanName = AutoConfigurationUtils.temporalCustomizerBeanName(beanPrefix, genericOptionsBuilderClass);
        try {
            TemporalOptionsCustomizer genericOptionsCustomizer = (TemporalOptionsCustomizer)this.beanFactory.getBean(beanName, TemporalOptionsCustomizer.class);
            return genericOptionsCustomizer;
        }
        catch (BeansException e) {
            log.warn("No TemporalOptionsCustomizer found for {}. ", (Object)beanName);
            if (genericOptionsBuilderClass.isAssignableFrom(WorkerFactoryOptions.Builder.class)) {
                log.debug("No TemporalOptionsCustomizer found for {}. \n You can add Customizer bean to do by namespace customization. \n Note: bean name should start with namespace name and end with Customizer, and the middle part should be the customizer target class name. \n Example: @Bean(\"nsWorkerFactoryCustomizer\") is a customizer bean for WorkerFactory via TemporalOptionsCustomizer<WorkerFactoryOptions.Builder>", (Object)genericOptionsBuilderClass.getSimpleName());
            }
            return null;
        }
    }
}

