/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.properties;

import io.temporal.common.VersioningBehavior;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConstructorBinding;

public class WorkerProperties {
    @Nonnull
    private final String taskQueue;
    @Nullable
    private final String name;
    @Nullable
    private final Collection<Class<?>> workflowClasses;
    @Nullable
    private final Collection<String> activityBeans;
    @Nullable
    private final Collection<String> nexusServiceBeans;
    @Nullable
    private final CapacityConfigurationProperties capacity;
    @Nullable
    private final RateLimitsConfigurationProperties rateLimits;
    @Nullable
    private final BuildIdConfigurationProperties buildId;
    @Nullable
    private final VirtualThreadConfigurationProperties virtualThreads;
    @Nullable
    private final WorkerDeploymentConfigurationProperties deploymentProperties;

    @ConstructorBinding
    public WorkerProperties(@Nonnull String taskQueue, @Nullable String name, @Nullable Collection<Class<?>> workflowClasses, @Nullable Collection<String> activityBeans, @Nullable Collection<String> nexusServiceBeans, @Nullable CapacityConfigurationProperties capacity, @Nullable RateLimitsConfigurationProperties rateLimits, @Nullable BuildIdConfigurationProperties buildId, @Nullable VirtualThreadConfigurationProperties virtualThreads, @Nullable WorkerDeploymentConfigurationProperties deploymentProperties) {
        this.name = name;
        this.taskQueue = taskQueue;
        this.workflowClasses = workflowClasses;
        this.activityBeans = activityBeans;
        this.nexusServiceBeans = nexusServiceBeans;
        this.capacity = capacity;
        this.rateLimits = rateLimits;
        this.buildId = buildId;
        this.virtualThreads = virtualThreads;
        this.deploymentProperties = deploymentProperties;
    }

    @Nonnull
    public String getTaskQueue() {
        return this.taskQueue;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Collection<Class<?>> getWorkflowClasses() {
        return this.workflowClasses;
    }

    @Nullable
    public Collection<String> getActivityBeans() {
        return this.activityBeans;
    }

    @Nullable
    public CapacityConfigurationProperties getCapacity() {
        return this.capacity;
    }

    @Nullable
    public RateLimitsConfigurationProperties getRateLimits() {
        return this.rateLimits;
    }

    @Nullable
    public BuildIdConfigurationProperties getBuildId() {
        return this.buildId;
    }

    @Nullable
    public VirtualThreadConfigurationProperties getVirtualThreads() {
        return this.virtualThreads;
    }

    @Nullable
    public Collection<String> getNexusServiceBeans() {
        return this.nexusServiceBeans;
    }

    @Nullable
    public WorkerDeploymentConfigurationProperties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public static class WorkerDeploymentConfigurationProperties {
        @Nullable
        private final String deploymentVersion;
        @Nullable
        private final Boolean useVersioning;
        @Nullable
        private final VersioningBehavior defaultVersioningBehavior;

        @ConstructorBinding
        public WorkerDeploymentConfigurationProperties(@Nullable String deploymentVersion, @Nullable Boolean useVersioning, @Nullable VersioningBehavior defaultVersioningBehavior) {
            this.deploymentVersion = deploymentVersion;
            this.useVersioning = useVersioning;
            this.defaultVersioningBehavior = defaultVersioningBehavior;
        }

        @Nullable
        public String getDeploymentVersion() {
            return this.deploymentVersion;
        }

        @Nullable
        public Boolean getUseVersioning() {
            return this.useVersioning;
        }

        @Nullable
        public VersioningBehavior getDefaultVersioningBehavior() {
            return this.defaultVersioningBehavior;
        }
    }

    public static class VirtualThreadConfigurationProperties {
        @Nullable
        private final Boolean usingVirtualThreads;
        @Nullable
        private final Boolean usingVirtualThreadsOnWorkflowWorker;
        @Nullable
        private final Boolean usingVirtualThreadsOnActivityWorker;
        @Nullable
        private final Boolean usingVirtualThreadsOnLocalActivityWorker;
        @Nullable
        private final Boolean usingVirtualThreadsOnNexusWorker;

        @ConstructorBinding
        public VirtualThreadConfigurationProperties(@Nullable Boolean usingVirtualThreads, @Nullable Boolean usingVirtualThreadsOnWorkflowWorker, @Nullable Boolean usingVirtualThreadsOnActivityWorker, @Nullable Boolean usingVirtualThreadsOnLocalActivityWorker, @Nullable Boolean usingVirtualThreadsOnNexusWorker) {
            this.usingVirtualThreads = usingVirtualThreads;
            this.usingVirtualThreadsOnWorkflowWorker = usingVirtualThreadsOnWorkflowWorker;
            this.usingVirtualThreadsOnActivityWorker = usingVirtualThreadsOnActivityWorker;
            this.usingVirtualThreadsOnLocalActivityWorker = usingVirtualThreadsOnLocalActivityWorker;
            this.usingVirtualThreadsOnNexusWorker = usingVirtualThreadsOnNexusWorker;
        }

        @Nullable
        public Boolean isUsingVirtualThreads() {
            return this.usingVirtualThreads;
        }

        @Nullable
        public Boolean isUsingVirtualThreadsOnWorkflowWorker() {
            return this.usingVirtualThreadsOnWorkflowWorker;
        }

        @Nullable
        public Boolean isUsingVirtualThreadsOnLocalActivityWorker() {
            return this.usingVirtualThreadsOnLocalActivityWorker;
        }

        @Nullable
        public Boolean isUsingVirtualThreadsOnNexusWorker() {
            return this.usingVirtualThreadsOnNexusWorker;
        }

        @Nullable
        public Boolean isUsingVirtualThreadsOnActivityWorker() {
            return this.usingVirtualThreadsOnActivityWorker;
        }
    }

    public static class BuildIdConfigurationProperties {
        @Nullable
        private final String workerBuildId;
        @Nullable
        private final boolean enabledWorkerVersioning;

        @ConstructorBinding
        public BuildIdConfigurationProperties(@Nullable String workerBuildId, @Nullable boolean enabledWorkerVersioning) {
            this.workerBuildId = workerBuildId;
            this.enabledWorkerVersioning = enabledWorkerVersioning;
        }

        @Nullable
        public String getWorkerBuildId() {
            return this.workerBuildId;
        }

        @Nullable
        public boolean getEnabledWorkerVersioning() {
            return this.enabledWorkerVersioning;
        }
    }

    public static class RateLimitsConfigurationProperties {
        @Nullable
        private final Double maxWorkerActivitiesPerSecond;
        @Nullable
        private final Double maxTaskQueueActivitiesPerSecond;

        @ConstructorBinding
        public RateLimitsConfigurationProperties(@Nullable Double maxWorkerActivitiesPerSecond, @Nullable Double maxTaskQueueActivitiesPerSecond) {
            this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
            this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
        }

        @Nullable
        public Double getMaxWorkerActivitiesPerSecond() {
            return this.maxWorkerActivitiesPerSecond;
        }

        @Nullable
        public Double getMaxTaskQueueActivitiesPerSecond() {
            return this.maxTaskQueueActivitiesPerSecond;
        }
    }

    public static class CapacityConfigurationProperties {
        @Nullable
        private final Integer maxConcurrentWorkflowTaskExecutors;
        @Nullable
        private final Integer maxConcurrentActivityExecutors;
        @Nullable
        private final Integer maxConcurrentLocalActivityExecutors;
        @Nullable
        private final Integer maxConcurrentNexusTaskExecutors;
        @Nullable
        private final Integer maxConcurrentWorkflowTaskPollers;
        @Nullable
        private final Integer maxConcurrentActivityTaskPollers;
        @Nullable
        private final Integer maxConcurrentNexusTaskPollers;

        @ConstructorBinding
        public CapacityConfigurationProperties(@Nullable Integer maxConcurrentWorkflowTaskExecutors, @Nullable Integer maxConcurrentActivityExecutors, @Nullable Integer maxConcurrentLocalActivityExecutors, @Nullable Integer maxConcurrentNexusTaskExecutors, @Nullable Integer maxConcurrentWorkflowTaskPollers, @Nullable Integer maxConcurrentActivityTaskPollers, @Nullable Integer maxConcurrentNexusTaskPollers) {
            this.maxConcurrentWorkflowTaskExecutors = maxConcurrentWorkflowTaskExecutors;
            this.maxConcurrentActivityExecutors = maxConcurrentActivityExecutors;
            this.maxConcurrentLocalActivityExecutors = maxConcurrentLocalActivityExecutors;
            this.maxConcurrentNexusTaskExecutors = maxConcurrentNexusTaskExecutors;
            this.maxConcurrentWorkflowTaskPollers = maxConcurrentWorkflowTaskPollers;
            this.maxConcurrentActivityTaskPollers = maxConcurrentActivityTaskPollers;
            this.maxConcurrentNexusTaskPollers = maxConcurrentNexusTaskPollers;
        }

        @Nullable
        public Integer getMaxConcurrentWorkflowTaskExecutors() {
            return this.maxConcurrentWorkflowTaskExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentActivityExecutors() {
            return this.maxConcurrentActivityExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentLocalActivityExecutors() {
            return this.maxConcurrentLocalActivityExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentNexusTasksExecutors() {
            return this.maxConcurrentNexusTaskExecutors;
        }

        @Nullable
        public Integer getMaxConcurrentWorkflowTaskPollers() {
            return this.maxConcurrentWorkflowTaskPollers;
        }

        @Nullable
        public Integer getMaxConcurrentActivityTaskPollers() {
            return this.maxConcurrentActivityTaskPollers;
        }

        @Nullable
        public Integer getMaxConcurrentNexusTaskPollers() {
            return this.maxConcurrentNexusTaskPollers;
        }
    }
}

