/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.properties;

import com.google.common.base.MoreObjects;
import io.temporal.spring.boot.autoconfigure.properties.WorkerProperties;
import io.temporal.spring.boot.autoconfigure.properties.WorkersAutoDiscoveryProperties;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class NamespaceProperties {
    public static final String NAMESPACE_DEFAULT = "default";
    @NestedConfigurationProperty
    @Nullable
    private final WorkersAutoDiscoveryProperties workersAutoDiscovery;
    @Nullable
    private final List<WorkerProperties> workers;
    @Nonnull
    private final String namespace;
    @Nullable
    private final WorkflowCacheProperties workflowCache;
    @Nonnull
    private final Boolean ignoreDuplicateDefinitions;

    @ConstructorBinding
    public NamespaceProperties(@Nullable String namespace, @Nullable WorkersAutoDiscoveryProperties workersAutoDiscovery, @Nullable List<WorkerProperties> workers, @Nullable WorkflowCacheProperties workflowCache, @Nullable Boolean ignoreDuplicateDefinitions) {
        this.workersAutoDiscovery = workersAutoDiscovery;
        this.workers = workers;
        this.namespace = (String)MoreObjects.firstNonNull((Object)namespace, (Object)NAMESPACE_DEFAULT);
        this.workflowCache = workflowCache;
        this.ignoreDuplicateDefinitions = (Boolean)MoreObjects.firstNonNull((Object)ignoreDuplicateDefinitions, (Object)Boolean.FALSE);
    }

    @Nullable
    public WorkersAutoDiscoveryProperties getWorkersAutoDiscovery() {
        return this.workersAutoDiscovery;
    }

    @Nullable
    public List<WorkerProperties> getWorkers() {
        return this.workers;
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public WorkflowCacheProperties getWorkflowCache() {
        return this.workflowCache;
    }

    @Nonnull
    public Boolean isIgnoreDuplicateDefinitions() {
        return this.ignoreDuplicateDefinitions;
    }

    public static class WorkflowCacheProperties {
        @Nullable
        private final Integer maxInstances;
        @Nullable
        private final Integer maxThreads;
        @Nullable
        private final Boolean usingVirtualWorkflowThreads;

        @ConstructorBinding
        public WorkflowCacheProperties(@Nullable Integer maxInstances, @Nullable Integer maxThreads, @Nullable Boolean usingVirtualWorkflowThreads) {
            this.maxInstances = maxInstances;
            this.maxThreads = maxThreads;
            this.usingVirtualWorkflowThreads = usingVirtualWorkflowThreads;
        }

        @Nullable
        public Integer getMaxInstances() {
            return this.maxInstances;
        }

        @Nullable
        public Integer getMaxThreads() {
            return this.maxThreads;
        }

        @Nullable
        public Boolean isUsingVirtualWorkflowThreads() {
            return this.usingVirtualWorkflowThreads;
        }
    }
}

