/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.schedules.ScheduleClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.ScheduleClientInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkersTemplate;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamespaceTemplate {
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    @Nonnull
    private final WorkflowServiceStubs workflowServiceStubs;
    @Nullable
    private final DataConverter dataConverter;
    @Nullable
    private final List<WorkflowClientInterceptor> workflowClientInterceptors;
    @Nullable
    private final List<ScheduleClientInterceptor> scheduleClientInterceptors;
    @Nullable
    private final List<WorkerInterceptor> workerInterceptors;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer;
    private ClientTemplate clientTemplate;
    private WorkersTemplate workersTemplate;

    public NamespaceTemplate(@Nonnull NamespaceProperties namespaceProperties, @Nonnull WorkflowServiceStubs workflowServiceStubs, @Nullable DataConverter dataConverter, @Nullable List<WorkflowClientInterceptor> workflowClientInterceptors, @Nullable List<ScheduleClientInterceptor> scheduleClientInterceptors, @Nullable List<WorkerInterceptor> workerInterceptors, @Nullable Tracer tracer, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer, @Nullable TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer, @Nullable TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer, @Nullable TemporalOptionsCustomizer<ScheduleClientOptions.Builder> scheduleCustomizer, @Nullable TemporalOptionsCustomizer<WorkflowImplementationOptions.Builder> workflowImplementationCustomizer) {
        this.namespaceProperties = namespaceProperties;
        this.workflowServiceStubs = workflowServiceStubs;
        this.dataConverter = dataConverter;
        this.workflowClientInterceptors = workflowClientInterceptors;
        this.scheduleClientInterceptors = scheduleClientInterceptors;
        this.workerInterceptors = workerInterceptors;
        this.tracer = tracer;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.workerFactoryCustomizer = workerFactoryCustomizer;
        this.workerCustomizer = workerCustomizer;
        this.clientCustomizer = clientCustomizer;
        this.scheduleCustomizer = scheduleCustomizer;
        this.workflowImplementationCustomizer = workflowImplementationCustomizer;
    }

    public ClientTemplate getClientTemplate() {
        if (this.clientTemplate == null) {
            this.clientTemplate = new ClientTemplate(this.namespaceProperties.getNamespace(), this.dataConverter, this.workflowClientInterceptors, this.scheduleClientInterceptors, this.tracer, this.workflowServiceStubs, this.testWorkflowEnvironment, this.clientCustomizer, this.scheduleCustomizer);
        }
        return this.clientTemplate;
    }

    public WorkersTemplate getWorkersTemplate() {
        if (this.workersTemplate == null) {
            this.workersTemplate = new WorkersTemplate(this.namespaceProperties, this.getClientTemplate(), this.workerInterceptors, this.tracer, this.testWorkflowEnvironment, this.workerFactoryCustomizer, this.workerCustomizer, this.workflowImplementationCustomizer);
        }
        return this.workersTemplate;
    }
}

