/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import com.google.common.base.MoreObjects;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.ScheduleClientInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowClientInterceptor;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.NonRootNamespaceProperties;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;

class AutoConfigurationUtils {
    AutoConfigurationUtils() {
    }

    @Nullable
    static DataConverter chooseDataConverter(List<DataConverter> dataConverters, DataConverter mainDataConverter) {
        DataConverter chosenDataConverter = null;
        if (dataConverters.size() == 1) {
            chosenDataConverter = dataConverters.get(0);
        } else if (dataConverters.size() > 1) {
            if (mainDataConverter != null) {
                chosenDataConverter = mainDataConverter;
            } else {
                throw new NoUniqueBeanDefinitionException(DataConverter.class, dataConverters.size(), "Several DataConverter beans found in the Spring context. Explicitly name 'mainDataConverter' the one bean that should be used by Temporal Spring Boot AutoConfiguration.");
            }
        }
        return chosenDataConverter;
    }

    @Nullable
    static DataConverter chooseDataConverter(Map<String, DataConverter> dataConverters, DataConverter mainDataConverter, TemporalProperties properties) {
        if (Objects.isNull(dataConverters) || dataConverters.isEmpty()) {
            return null;
        }
        List<NonRootNamespaceProperties> nonRootNamespaceProperties = properties.getNamespaces();
        if (Objects.isNull(nonRootNamespaceProperties) || nonRootNamespaceProperties.isEmpty()) {
            return AutoConfigurationUtils.chooseDataConverter(new ArrayList<DataConverter>(dataConverters.values()), mainDataConverter);
        }
        ArrayList<DataConverter> dataConverterList = new ArrayList<DataConverter>();
        List nonRootBeanNames = nonRootNamespaceProperties.stream().map(ns -> (String)MoreObjects.firstNonNull((Object)ns.getAlias(), (Object)ns.getNamespace()) + DataConverter.class.getSimpleName()).collect(Collectors.toList());
        for (Map.Entry<String, DataConverter> dataConverterEntry : dataConverters.entrySet()) {
            String beanName = dataConverterEntry.getKey();
            DataConverter dataConverter = dataConverterEntry.getValue();
            if (beanName.equals("mainDataConverter") || nonRootBeanNames.contains(beanName)) continue;
            dataConverterList.add(dataConverter);
        }
        return AutoConfigurationUtils.chooseDataConverter(dataConverterList, mainDataConverter);
    }

    @Nullable
    static List<WorkflowClientInterceptor> chooseWorkflowClientInterceptors(List<WorkflowClientInterceptor> workflowClientInterceptors, TemporalProperties properties) {
        return workflowClientInterceptors;
    }

    @Nullable
    static List<ScheduleClientInterceptor> chooseScheduleClientInterceptors(List<ScheduleClientInterceptor> scheduleClientInterceptor, TemporalProperties properties) {
        return scheduleClientInterceptor;
    }

    @Nullable
    static List<WorkerInterceptor> chooseWorkerInterceptors(List<WorkerInterceptor> workerInterceptor, TemporalProperties properties) {
        return workerInterceptor;
    }

    private static Comparator<Object> beanFactoryAwareOrderComparator(ListableBeanFactory beanFactory) {
        return OrderComparator.INSTANCE.withSourceProvider(o -> {
            Order order;
            if (!(o instanceof Map.Entry)) {
                throw new IllegalStateException("Unexpected object type: " + o);
            }
            Map.Entry entry = (Map.Entry)o;
            Integer priority = AnnotationAwareOrderComparator.INSTANCE.getPriority(entry.getValue());
            if (priority != null) {
                return () -> priority;
            }
            String beanName = (String)entry.getKey();
            if (beanName != null && (order = (Order)beanFactory.findAnnotationOnBean(beanName, Order.class)) != null) {
                return () -> ((Order)order).value();
            }
            return null;
        });
    }

    static <T> List<TemporalOptionsCustomizer<T>> chooseTemporalCustomizerBeans(ListableBeanFactory beanFactory, Map<String, TemporalOptionsCustomizer<T>> customizerMap, Class<T> genericOptionsBuilderClass, TemporalProperties properties) {
        if (Objects.isNull(customizerMap) || customizerMap.isEmpty()) {
            return null;
        }
        List<NonRootNamespaceProperties> nonRootNamespaceProperties = properties.getNamespaces();
        Stream<Object> customizerStream = customizerMap.entrySet().stream();
        if (!Objects.isNull(nonRootNamespaceProperties) && !nonRootNamespaceProperties.isEmpty()) {
            List nonRootBeanNames = nonRootNamespaceProperties.stream().map(ns -> AutoConfigurationUtils.temporalCustomizerBeanName((String)MoreObjects.firstNonNull((Object)ns.getAlias(), (Object)ns.getNamespace()), genericOptionsBuilderClass)).collect(Collectors.toList());
            customizerStream = customizerStream.filter(entry -> !nonRootBeanNames.contains(entry.getKey()));
        }
        return customizerStream.sorted(AutoConfigurationUtils.beanFactoryAwareOrderComparator(beanFactory)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    static String temporalCustomizerBeanName(String beanPrefix, Class<?> optionsBuilderClass) {
        String builderCanonicalName = optionsBuilderClass.getCanonicalName();
        String bindingCustomizerName = builderCanonicalName.replace("Options.Builder", "Customizer");
        bindingCustomizerName = bindingCustomizerName.substring(bindingCustomizerName.lastIndexOf(".") + 1);
        return beanPrefix + bindingCustomizerName;
    }
}

